/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import redlight.client.Main;

class ServerStatusPanel
extends JPanel {
    JTextField serverName;
    JTextField serverDescription;
    JTextField homeDirectory;
    JButton browseButton;
    JLabel[] values = new JLabel[]{new JLabel("0"), new JLabel("0"), new JLabel("0"), new JLabel("0"), new JLabel("0"), new JLabel("0"), new JLabel("0"), new JLabel("0"), new JLabel("0"), new JLabel("0"), new JLabel("0")};
    JLabel[] labels = new JLabel[]{new JLabel("Server addresses:"), new JLabel("Up since:"), new JLabel("Currently connected:"), new JLabel("Downloads in progress:"), new JLabel("Uploads in progress:"), new JLabel("Downloads in queue:"), new JLabel("Uploads in queue:"), new JLabel("Download counter:"), new JLabel("Upload counter:"), new JLabel("Connection peak:"), new JLabel("Connection counter:")};
    static int SERVER_ADDRESS = 0;
    static int SINCE = 1;
    static int CURRENTLY_CONNECTED = 2;
    static int DOWNLOADS_IN_PROGRESS = 3;
    static int UPLOADS_IN_PROGRESS = 4;
    static int DOWNLOADS_IN_QUEUE = 5;
    static int UPLOADS_IN_QUEUE = 6;
    static int DOWNLOAD_COUNTER = 7;
    static int UPLOAD_COUNTER = 8;
    static int CONNECTION_PEAK = 9;
    static int CONNECTION_COUNTER = 10;

    ServerStatusPanel() {
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        this.serverName = new JTextField(Main.rlo.getStringProperty("ServerName"), 25);
        this.serverDescription = new JTextField(Main.rlo.getStringProperty("ServerDescription"), 25);
        this.homeDirectory = new JTextField(((File)Main.rlo.getProperty("Path.ServerHome")).toString());
        this.homeDirectory.setActionCommand("ActivateSetHomeDir");
        this.browseButton = new JButton("Browse...");
        this.browseButton.setActionCommand("ActivateBrowse");
        JPanel homeDirPanel = new JPanel();
        homeDirPanel.setLayout(new BorderLayout());
        homeDirPanel.add((Component)this.homeDirectory, "Center");
        homeDirPanel.add((Component)this.browseButton, "East");
        this.addRow(new JLabel("Server name:"), this.serverName, gbc);
        this.addRow(new JLabel("Server description:"), this.serverDescription, gbc);
        this.addRow(new JLabel("Share files from:"), homeDirPanel, gbc);
        int i = 0;
        while (i < this.labels.length) {
            this.addRow(i, gbc);
            ++i;
        }
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.addRow(Box.createGlue(), Box.createGlue(), gbc);
    }

    void addRow(int i, GridBagConstraints gbc) {
        this.addRow(this.labels[i], this.values[i], gbc);
    }

    void addRow(Component l, Component v, GridBagConstraints gbc) {
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add(l, gbc);
        ++gbc.gridx;
        gbc.fill = 2;
        gbc.anchor = 13;
        this.add(v, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
    }

    void reset() {
        int i = 0;
        while (i < this.values.length) {
            this.values[i].setText("0");
            ++i;
        }
    }

    public void setVisible(boolean b) {
        int i = 0;
        while (i < this.values.length) {
            this.labels[i].setVisible(b);
            this.values[i].setVisible(b);
            ++i;
        }
    }
}

