/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import redlight.client.ButtonPanel;
import redlight.client.ButtonedPanel;
import redlight.client.ConnectionInterface;
import redlight.client.Error;
import redlight.client.HelpTextPanel;
import redlight.client.Main;
import redlight.client.Options;
import redlight.client.ServerLogPanel;
import redlight.client.ServerStatusPanel;
import redlight.client.ServerTrackerPanel;
import redlight.crypto.UnixCrypt;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerDispatcher;
import redlight.hotline.HLServerListener;
import redlight.hotline.HLServerTrackerTable;
import redlight.server.AccountsTable;
import redlight.utils.DebuggerOutput;
import redlight.utils.TimeFormat;

public class SharingInterface {
    JFrame f;
    ServerStatusPanel serverStatusPanel;
    ServerTrackerPanel serverTrackerPanel;
    ServerLogPanel serverLogPanel;
    JButton cancel;
    JButton startStop;
    JButton admin;
    Thread serverThread;
    Random randomGenerator;
    String adminPassword;
    HLServer hls;
    HLProtocol hlp;
    AccountsTable accountsTable;
    HLServerTrackerTable trackerTable;
    HLProtocol.AccountInfo adminAccount;
    Options rlo;
    ActionListener trackerActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int index = Integer.parseInt(e.getActionCommand().substring(e.getActionCommand().length() - 1));
            try {
                String addressString = SharingInterface.this.serverTrackerPanel.addresses[index].getText();
                if (addressString.equals("")) {
                    return;
                }
                InetAddress address = InetAddress.getByName(addressString);
                String password = SharingInterface.this.serverTrackerPanel.passwords[index].getText();
                if (password.equals("")) {
                    password = null;
                }
                SharingInterface.this.trackerTable.remove(InetAddress.getByName(Main.rlo.getStringProperty("ServerTrackerAddress" + index)));
                SharingInterface.this.trackerTable.put(address, password);
                Main.rlo.setProperty("ServerTrackerAddress" + index, address.getHostName());
            }
            catch (UnknownHostException ex) {
                new Error("Sorry, unknown host: " + ex.getMessage());
            }
            DebuggerOutput.debug(SharingInterface.this.trackerTable.toString());
        }
    };
    HLServerListener listener = new HLServerListener(){

        public void serverReady() {
            SharingInterface.this.serverStatusPanel.setVisible(true);
            SharingInterface.this.admin.setEnabled(true);
            SharingInterface.this.startStop.setText("Stop");
            SharingInterface.this.serverStatusPanel.values[ServerStatusPanel.SINCE].setText(TimeFormat.formatCurrentDateTime(3, 2));
            try {
                InetAddress[] all = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                String adresses = "";
                int i = 0;
                while (i < all.length) {
                    adresses = adresses + all[i].getHostAddress();
                    if (i + 1 < all.length) {
                        adresses = adresses + ", ";
                    }
                    ++i;
                }
                SharingInterface.this.serverStatusPanel.values[ServerStatusPanel.SERVER_ADDRESS].setText(adresses);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }

        public void logLine(String line) {
            SharingInterface.this.serverLogPanel.writeln(line);
        }

        public void userJoined(HLServerDispatcher client) {
            this.updateTextField(ServerStatusPanel.CURRENTLY_CONNECTED, 1);
            this.updateTextField(ServerStatusPanel.CONNECTION_COUNTER, 1);
            int currentlyConnected = this.getTextFieldValue(ServerStatusPanel.CURRENTLY_CONNECTED);
            int connectionPeak = this.getTextFieldValue(ServerStatusPanel.CONNECTION_PEAK);
            if (currentlyConnected > connectionPeak) {
                this.updateTextField(ServerStatusPanel.CONNECTION_PEAK, 1);
            }
        }

        public void userLeft(HLServerDispatcher client) {
            this.updateTextField(ServerStatusPanel.CURRENTLY_CONNECTED, -1);
        }

        public void transferProgressStart(HLServer.TransferRequest tr) {
            this.updateProgress(tr, 1);
            this.updateTransfer(tr, 1, ServerStatusPanel.DOWNLOAD_COUNTER, ServerStatusPanel.UPLOAD_COUNTER);
        }

        public void transferProgressStop(HLServer.TransferRequest tr) {
            this.updateProgress(tr, -1);
        }

        public void transferQueueStart(HLServer.TransferRequest tr) {
            this.updateQueue(tr, 1);
        }

        public void transferQueueStop(HLServer.TransferRequest tr) {
            this.updateQueue(tr, -1);
        }

        void updateProgress(HLServer.TransferRequest tr, int delta) {
            this.updateTransfer(tr, delta, ServerStatusPanel.DOWNLOADS_IN_PROGRESS, ServerStatusPanel.UPLOADS_IN_PROGRESS);
        }

        void updateQueue(HLServer.TransferRequest tr, int delta) {
            this.updateTransfer(tr, delta, ServerStatusPanel.DOWNLOADS_IN_QUEUE, ServerStatusPanel.UPLOADS_IN_QUEUE);
        }

        void updateTransfer(HLServer.TransferRequest tr, int delta, int dlIndex, int ulIndex) {
            int index = dlIndex;
            if (tr.type == 1) {
                index = ulIndex;
            }
            this.updateTextField(index, delta);
        }

        void updateTextField(int index, int delta) {
            int oldValue = this.getTextFieldValue(index);
            SharingInterface.this.serverStatusPanel.values[index].setText("" + (oldValue + delta));
        }

        int getTextFieldValue(int index) {
            return Integer.parseInt(SharingInterface.this.serverStatusPanel.values[index].getText());
        }
    };
    ActionListener cancelListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("ActivateCancel")) {
                SharingInterface.this.close();
            }
        }
    };
    ActionListener startStopListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("ActivateStartStop")) {
                if (SharingInterface.this.serverThread != null && SharingInterface.this.serverThread.isAlive()) {
                    SharingInterface.this.hls.shutdown("Stopped by admin");
                    SharingInterface.this.serverStatusPanel.reset();
                } else {
                    SharingInterface.this.serverThread = new ServerThread();
                    SharingInterface.this.serverThread.start();
                }
            }
        }
    };

    public SharingInterface(Options rlo) {
        this.rlo = rlo;
        this.f = new JFrame("Sharing setup");
        Container contentPane = this.f.getContentPane();
        this.serverStatusPanel = new ServerStatusPanel();
        HelpTextPanel serverStatusHelpPanel = new HelpTextPanel("Server status", "Give your server a name, a description, and select a directory that you want to share files from. Then click Start to start the server. Click the Admin button to login to your server as an administrator and manage your server.", this.serverStatusPanel);
        this.serverTrackerPanel = new ServerTrackerPanel(this.trackerActionListener);
        HelpTextPanel serverTrackerHelpPanel = new HelpTextPanel("Tracker servers", "Enter the addresses of tracker servers that you want your server to appear on. ", this.serverTrackerPanel);
        this.serverLogPanel = new ServerLogPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Status", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), serverStatusHelpPanel, "Server status");
        tabbedPane.addTab("Trackers", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), serverTrackerHelpPanel, "Tracker servers");
        tabbedPane.addTab("Log", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), this.serverLogPanel, "Server log");
        this.cancel = new JButton("Close");
        this.cancel.setActionCommand("ActivateCancel");
        this.cancel.addActionListener(this.cancelListener);
        this.startStop = new JButton("Start");
        this.startStop.setActionCommand("ActivateStartStop");
        this.startStop.addActionListener(this.startStopListener);
        this.admin = new JButton("Admin");
        this.admin.setEnabled(false);
        this.admin.setActionCommand("ActivateAdmin");
        this.admin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ActivateAdmin")) {
                    new ConnectionInterface("127.0.0.1", 5500, SharingInterface.this.adminAccount.login, SharingInterface.this.adminPassword, SharingInterface.this.serverStatusPanel.serverName.getText());
                }
            }
        });
        this.serverStatusPanel.serverName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.rlo.setProperty("ServerName", SharingInterface.this.serverStatusPanel.serverName.getText());
                SharingInterface.this.hls.setServerName(SharingInterface.this.serverStatusPanel.serverName.getText());
            }
        });
        this.serverStatusPanel.serverDescription.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.rlo.setProperty("ServerDescription", SharingInterface.this.serverStatusPanel.serverDescription.getText());
                SharingInterface.this.hls.setServerDescription(SharingInterface.this.serverStatusPanel.serverName.getText());
            }
        });
        ActionListener homeDirListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ActivateBrowse")) {
                    FileDialog fd = new FileDialog((Frame)Main.getActiveShell().f, "Select a file in the directory that you want to share", 0);
                    fd.setDirectory(((File)Main.rlo.getProperty("Path.ServerHome")).getPath());
                    fd.setFile(((File)Main.rlo.getProperty("Path.ServerHome")).getName());
                    fd.show();
                    if (fd.getDirectory() == null) {
                        return;
                    }
                    SharingInterface.this.serverStatusPanel.homeDirectory.setText(fd.getDirectory());
                }
                File newDirectory = new File(SharingInterface.this.serverStatusPanel.homeDirectory.getText());
                try {
                    SharingInterface.this.hls.setHomeDirectory(newDirectory);
                    Main.rlo.setProperty("Path.ServerHome", newDirectory);
                }
                catch (IllegalArgumentException ex) {
                    new Error(ex.getMessage() + ". Please select another home directory.");
                }
            }
        };
        this.serverStatusPanel.browseButton.addActionListener(homeDirListener);
        this.serverStatusPanel.homeDirectory.addActionListener(homeDirListener);
        this.serverStatusPanel.setVisible(false);
        JButton[] adminButton = new JButton[]{this.admin};
        JButton[] buttons = new JButton[]{this.cancel, this.startStop};
        ButtonPanel buttonPanel = new ButtonPanel(adminButton, buttons);
        ButtonedPanel buttonedPanel = new ButtonedPanel(tabbedPane, buttonPanel);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)buttonedPanel, "Center");
        SwingUtilities.getRootPane(this.f).setDefaultButton(this.startStop);
        this.f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SharingInterface.this.close();
            }
        });
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        buttonedPanel.registerKeyboardAction(this.cancelListener, "ActivateCancel", ks, 2);
        this.f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = this.f.getSize();
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        this.randomGenerator = new Random(System.currentTimeMillis());
        this.hlp = new HLProtocol();
        this.hls = new HLServer();
        this.hls.setMaximumUsers(10);
        this.hls.setMaximumDownloads(2);
        this.hls.setMaximumUploads(3);
        this.hls.setMaximumDownloadsPerUser(1);
        this.hls.setMaximumUploadsPerUser(1);
        this.hls.setMaximumDownloadQueueSpots(20);
        this.hls.setMaximumUploadQueueSpots(20);
        this.trackerTable = new HLServerTrackerTable(this.hls);
        this.accountsTable = new AccountsTable(this.hls, new File(Main.CONFIGURATION_DIRECTORY, "accounts")){

            public boolean exists(String login) {
                if (login.equals(SharingInterface.this.adminAccount.login)) {
                    return true;
                }
                return super.exists(login);
            }

            public HLProtocol.AccountInfo get(String login) {
                if (login.equals(SharingInterface.this.adminAccount.login)) {
                    return SharingInterface.this.adminAccount;
                }
                return super.get(login);
            }

            public void put(String login, HLProtocol.AccountInfo newAccount) {
                this.table.remove(SharingInterface.this.adminAccount.login);
                super.put(login, newAccount);
                this.table.put(SharingInterface.this.adminAccount.login, SharingInterface.this.adminAccount);
            }
        };
        try {
            this.hls.setHomeDirectory((File)Main.rlo.getProperty("Path.ServerHome"));
        }
        catch (IllegalArgumentException e) {
            Main.rlo.setProperty("Path.ServerHome", this.hls.getHomeDirectory());
            this.serverStatusPanel.homeDirectory.setText(this.hls.getHomeDirectory().toString());
            new Error(e.getMessage() + ". Please select another path.");
        }
        this.hls.setHLServerListener(this.listener);
        this.hls.setAccountsTable(this.accountsTable);
        this.hls.setTrackerTable(this.trackerTable);
        this.show();
    }

    public void close() {
        this.f.setVisible(false);
    }

    public void show() {
        this.f.setVisible(true);
    }

    String createRandomString() {
        return Integer.toHexString(this.randomGenerator.nextInt()) + Integer.toHexString(this.randomGenerator.nextInt());
    }

    HLProtocol.AccountInfo createRandomAdminAccount() {
        this.adminPassword = this.createRandomString();
        return new HLProtocol.AccountInfo(this.hlp, this.createRandomString(), "rl admin user", UnixCrypt.crypt("aa", this.adminPassword), -1L, null);
    }

    class ServerThread
    extends Thread {
        ServerThread() {
        }

        public void run() {
            try {
                SharingInterface.this.adminAccount = SharingInterface.this.createRandomAdminAccount();
                SharingInterface.this.serverLogPanel.writeln("\nStarting server ...");
                SharingInterface.this.hls.listen();
            }
            catch (Exception e) {
                String reason = e.toString();
                if (e.getMessage() != null) {
                    reason = e.getMessage();
                }
                SharingInterface.this.serverLogPanel.writeln("Server shut down (" + reason + ")");
                DebuggerOutput.stackTrace(e);
            }
            SharingInterface.this.startStop.setText("Start");
            SharingInterface.this.admin.setEnabled(false);
            SharingInterface.this.serverStatusPanel.setVisible(false);
            SharingInterface.this.serverStatusPanel.reset();
        }
    }
}

