/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import redlight.client.AboutInterface;
import redlight.client.BookmarkInterface;
import redlight.client.BookmarkMenuItem;
import redlight.client.ConnectInterface;
import redlight.client.Connection;
import redlight.client.ConnectionInterface;
import redlight.client.Error;
import redlight.client.Interface;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.ManualInterface;
import redlight.client.OptionsInterface;
import redlight.client.Parent;
import redlight.client.SharingInterface;
import redlight.client.TrackerInterface;
import redlight.hotline.HLBookmarkFile;
import redlight.utils.DebuggerOutput;
import redlight.utils.FilenameUtils;
import redlight.utils.TextUtils;

public class Shell
implements Parent,
ActionListener {
    Hashtable connections;
    Container contentPane;
    public JFrame f;
    Shell self = this;
    JMenu bookmarkMenu;
    JMenuItem closeConnectionMenuItem;
    JMenuItem saveBookmarkAsMenuItem;
    JMenuItem addBookmarkMenuItem;
    JMenuItem homeLineMenuItem;
    JMenuItem setHomeMenuItem;
    JTabbedPane connectionsPanel;
    ConnectInterface tripConnect;
    int activeTransfers = 0;
    public boolean existsActiveConnection = false;

    public Shell() {
        this.connections = new Hashtable();
        Font smallFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame("Red Light");
        this.contentPane = this.f.getContentPane();
        this.connectionsPanel = new JTabbedPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.connectionsPanel, "Center");
        JMenu fileMenu = new JMenu("File");
        JMenuItem newConnectionMenuItem = fileMenu.add("New connection ...");
        newConnectionMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        newConnectionMenuItem.addActionListener(this);
        JMenuItem openNewWindowMenuItem = fileMenu.add("Open new window");
        openNewWindowMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 10));
        openNewWindowMenuItem.addActionListener(this);
        this.closeConnectionMenuItem = fileMenu.add("Close connection");
        this.closeConnectionMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.closeConnectionMenuItem.addActionListener(this);
        this.closeConnectionMenuItem.setEnabled(false);
        fileMenu.addSeparator();
        JMenuItem quitMenuItem = fileMenu.add("Quit");
        quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        quitMenuItem.addActionListener(this);
        JMenu editMenu = new JMenu("Edit");
        editMenu.add("Cut").setEnabled(false);
        editMenu.add("Copy").setEnabled(false);
        editMenu.add("Paste").setEnabled(false);
        editMenu.addSeparator();
        JMenuItem optionsMenuItem = editMenu.add("Options ...");
        optionsMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        optionsMenuItem.addActionListener(this);
        optionsMenuItem.setActionCommand("ActivateOptions");
        this.bookmarkMenu = new JMenu("Bookmarks");
        this.rebuildBookmarkMenu();
        JMenu trackerMenu = new JMenu("Trackers");
        JMenuItem manageTrackerMenuItem = trackerMenu.add("Manage trackers ...");
        manageTrackerMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        manageTrackerMenuItem.addActionListener(this);
        JMenu sharingMenu = new JMenu("Sharing");
        JMenuItem sharingSetupMenuItem = sharingMenu.add("Sharing setup ...");
        sharingSetupMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        sharingSetupMenuItem.addActionListener(this);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem aboutMenuItem = helpMenu.add("About ...");
        JMenuItem manualMenuItem = helpMenu.add("Read this ...");
        helpMenu.addSeparator();
        this.homeLineMenuItem = helpMenu.add("Red Light home");
        if ("development".equals("development")) {
            helpMenu.addSeparator();
            helpMenu.add("Toggle debugging output").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DebuggerOutput.setEnabled(!DebuggerOutput.on);
                }
            });
            helpMenu.add("Collect garbage").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.gc();
                }
            });
        }
        manualMenuItem.setActionCommand("ActivateManual");
        aboutMenuItem.setActionCommand("ActivateAbout");
        this.homeLineMenuItem.setActionCommand("ActivateHomeline");
        this.homeLineMenuItem.addActionListener(this);
        aboutMenuItem.addActionListener(this);
        manualMenuItem.addActionListener(this);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(this.bookmarkMenu);
        menuBar.add(trackerMenu);
        menuBar.add(sharingMenu);
        menuBar.add(helpMenu);
        fileMenu.setMnemonic('F');
        editMenu.setMnemonic('E');
        this.bookmarkMenu.setMnemonic('B');
        trackerMenu.setMnemonic('T');
        sharingMenu.setMnemonic('S');
        helpMenu.setMnemonic('H');
        menuBar.setSelected(fileMenu);
        this.f.setJMenuBar(menuBar);
        this.f.setDefaultCloseOperation(0);
        this.setConnectionKeyboardShortcuts();
        this.f.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Main.setActiveShell(Shell.this.self);
            }

            public void windowClosing(WindowEvent e) {
                boolean doClose = false;
                if (Shell.this.activeTransfers > 0) {
                    int r = JOptionPane.showConfirmDialog(null, TextUtils.wordWrap("There are file transfers in progress, which will be interrupted when you close this window (although they may be resumed later). Are you sure you wish to close it?", 40), "Close?", 0, 3);
                    if (r == 0) {
                        doClose = true;
                    }
                } else {
                    doClose = true;
                }
                if (doClose) {
                    Enumeration en = Shell.this.connections.keys();
                    while (en.hasMoreElements()) {
                        ((ConnectionInterface)Shell.this.connections.get(en.nextElement())).close();
                    }
                    Main.setActiveShell(Shell.this.self);
                    Shell.this.f.setVisible(false);
                    Shell.this.f.dispose();
                    Shell.this.f = null;
                    Shell.this.contentPane = null;
                    Main.removeShell(Shell.this.self);
                }
            }
        });
        this.f.pack();
        this.f.setLocation((Point)Main.rlo.getProperty("WindowLocation.Main"));
        this.f.setSize((Dimension)Main.rlo.getProperty("WindowDimension.Main"));
        this.f.show();
        Main.addShell(this);
        Main.setActiveShell(this);
    }

    public void setConnectionKeyboardShortcuts() {
        this.connectionsPanel.registerKeyboardAction(this, "ActivateConnection1", KeyStroke.getKeyStroke(112, 2), 2);
        this.connectionsPanel.registerKeyboardAction(this, "ActivateConnection2", KeyStroke.getKeyStroke(113, 2), 2);
        this.connectionsPanel.registerKeyboardAction(this, "ActivateConnection3", KeyStroke.getKeyStroke(114, 2), 2);
        this.connectionsPanel.registerKeyboardAction(this, "ActivateConnection4", KeyStroke.getKeyStroke(115, 2), 2);
        this.connectionsPanel.registerKeyboardAction(this, "ActivateConnection5", KeyStroke.getKeyStroke(116, 2), 2);
        this.connectionsPanel.registerKeyboardAction(this, "ActivateConnection6", KeyStroke.getKeyStroke(117, 2), 2);
        this.connectionsPanel.registerKeyboardAction(this, "ActivateConnection7", KeyStroke.getKeyStroke(118, 2), 2);
        this.connectionsPanel.registerKeyboardAction(this, "ActivateConnection8", KeyStroke.getKeyStroke(119, 2), 2);
        this.connectionsPanel.registerKeyboardAction(this, "ActivateConnection9", KeyStroke.getKeyStroke(120, 2), 2);
        this.connectionsPanel.registerKeyboardAction(this, "ActivateConnection10", KeyStroke.getKeyStroke(121, 2), 2);
    }

    public void addConnectionPane(final String name, ConnectionInterface tci, final Component pane) {
        this.connections.put(pane, tci);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Shell.this.connectionsPanel.addTab(name, new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), pane);
                Shell.this.connectionsPanel.setSelectedComponent(pane);
                Shell.this.closeConnectionMenuItem.setEnabled(true);
                Shell.this.addBookmarkMenuItem.setEnabled(true);
                Shell.this.existsActiveConnection = true;
            }
        });
    }

    public void removeConnectionPane(final Component pane) {
        this.connections.remove(pane);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Shell.this.connectionsPanel.remove(pane);
                if (Shell.this.connectionsPanel.getTabCount() == 0) {
                    Shell.this.f.getContentPane().remove(Shell.this.connectionsPanel);
                    Shell.this.connectionsPanel = new JTabbedPane();
                    Shell.this.f.getContentPane().setLayout(new BorderLayout());
                    Shell.this.f.getContentPane().add((Component)Shell.this.connectionsPanel, "Center");
                    Shell.this.closeConnectionMenuItem.setEnabled(false);
                    Shell.this.addBookmarkMenuItem.setEnabled(false);
                    Shell.this.existsActiveConnection = false;
                }
            }
        });
    }

    public void rebuildBookmarkMenu() {
        final Shell listener = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Shell.this.bookmarkMenu.removeAll();
                Shell.this.setHomeMenuItem = Shell.this.bookmarkMenu.add("Set current site as home");
                Shell.this.setHomeMenuItem.setActionCommand("ActivateSetHome");
                Shell.this.setHomeMenuItem.addActionListener(Shell.this.self);
                Shell.this.addBookmarkMenuItem = Shell.this.bookmarkMenu.add("Add bookmark");
                Shell.this.addBookmarkMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
                Shell.this.addBookmarkMenuItem.addActionListener(Shell.this.self);
                Shell.this.addBookmarkMenuItem.setEnabled(Shell.this.existsActiveConnection);
                JMenuItem manageBookmarksMenuItem = Shell.this.bookmarkMenu.add("Manage bookmarks ...");
                manageBookmarksMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
                manageBookmarksMenuItem.addActionListener(Shell.this.self);
                Shell.this.bookmarkMenu.addSeparator();
                BookmarkInterface.populateContainerWithBookmarks(Shell.this.bookmarkMenu.getPopupMenu(), listener);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ActivateHomeline")) {
            new ConnectionInterface("redlight.wox.org", 5500, "tubar", "tubar", "Red Light");
        } else if (e.getActionCommand().equals("ActivateOptions")) {
            if (Main.rloInterface == null) {
                Main.rloInterface = new OptionsInterface(this, Main.rlo);
            } else {
                Main.rloInterface.show();
            }
        } else if (e.getActionCommand().equals("ActivateBookmark")) {
            HLBookmarkFile bmf = ((BookmarkMenuItem)e.getSource()).getBookmarkFile();
            String address = bmf.get("address");
            int port = 5500;
            if (address.indexOf(":") != -1) {
                port = new Integer(address.substring(address.indexOf(":") + 1));
                address = address.substring(0, address.indexOf(":"));
            }
            new ConnectionInterface(address, port, bmf.get("login"), bmf.get("password"), bmf.getFile().getName());
        } else if (e.getActionCommand().equals("Sharing setup ...")) {
            if (Main.sharingInterface == null) {
                Main.sharingInterface = new SharingInterface(Main.rlo);
            } else {
                Main.sharingInterface.show();
            }
        } else if (e.getActionCommand().equals("Manage trackers ...")) {
            if (Main.tubeTracker == null) {
                Main.tubeTracker = new TrackerInterface(this, Main.rlo);
            } else {
                Main.tubeTracker.show();
            }
        } else if (e.getActionCommand().equals("Manage bookmarks ...")) {
            if (Main.tubeBookmarks == null) {
                Main.tubeBookmarks = new BookmarkInterface(this, Main.rlo);
            } else {
                Main.tubeBookmarks.show();
            }
        } else if (e.getActionCommand().equals("New connection ...")) {
            if (this.tripConnect == null) {
                this.tripConnect = new ConnectInterface(this);
            } else {
                this.tripConnect.show(true);
            }
        } else if (e.getActionCommand().equals("Close connection")) {
            ConnectionInterface tci = (ConnectionInterface)this.connections.get(this.connectionsPanel.getSelectedComponent());
            if (tci != null) {
                tci.close();
            }
        } else if (e.getActionCommand().equals("Open new window")) {
            new Shell();
        } else if (e.getActionCommand().equals("ActivateSetHome")) {
            ConnectionInterface activeConnection;
            Main.rlo.setProperty("Home", null);
            if (this.connectionsPanel.getSelectedComponent() != null && (activeConnection = (ConnectionInterface)this.connections.get(this.connectionsPanel.getSelectedComponent())) != null && activeConnection.rlm != null) {
                Main.rlo.setProperty("Home", new Connection(activeConnection.rlm.getServer(), activeConnection.rlm.getPort(), activeConnection.rlm.getLogin(), activeConnection.rlm.getPassword(), activeConnection.rlm.getServerName()));
            }
        } else if (e.getActionCommand().equals("Add bookmark")) {
            if (this.connectionsPanel.getSelectedComponent() != null) {
                ConnectionInterface activeConnection = (ConnectionInterface)this.connections.get(this.connectionsPanel.getSelectedComponent());
                if (activeConnection != null && activeConnection.rlm != null) {
                    try {
                        HLBookmarkFile bmf = new HLBookmarkFile(new File((File)Main.rlo.getProperty("Path.Bookmarks"), FilenameUtils.qualify(activeConnection.rlm.getServerName())));
                        bmf.put("address", activeConnection.rlm.getServer() + ":" + activeConnection.rlm.getPort());
                        bmf.put("login", activeConnection.rlm.getLogin());
                        bmf.put("password", activeConnection.rlm.getPassword());
                        if (!((File)Main.rlo.getProperty("Path.Bookmarks")).exists() && !((File)Main.rlo.getProperty("Path.Bookmarks")).mkdir()) {
                            throw new IOException("cannot create " + ((File)Main.rlo.getProperty("Path.Bookmarks")).toString());
                        }
                        bmf.store();
                    }
                    catch (IOException ex) {
                        new Error("Could not save bookmark: " + ex.getMessage());
                    }
                }
                this.displayPropertyChanged("bookmarkentries", "");
            }
        } else if (e.getActionCommand().equals("Quit")) {
            Main.systemEvents.handleQuit();
        } else if (e.getActionCommand().startsWith("ActivateConnection")) {
            int n = Integer.parseInt(e.getActionCommand().substring(new String("ActivateConnection").length())) - 1;
            this.activateConnection(n);
        } else if (e.getActionCommand().startsWith("ActivateAbout")) {
            if (Main.tubeAboutInterface == null) {
                Main.tubeAboutInterface = new AboutInterface();
            } else {
                Main.tubeAboutInterface.show();
            }
        } else if (e.getActionCommand().startsWith("ActivateManual")) {
            if (Main.tubeManualInterface == null) {
                Main.tubeManualInterface = new ManualInterface();
            } else {
                Main.tubeManualInterface.show();
            }
        } else {
            DebuggerOutput.debug("''" + e.getActionCommand() + "'' not implemented");
        }
    }

    public void activateConnection(int n) {
        if (n < this.connectionsPanel.getTabCount()) {
            this.connectionsPanel.setSelectedComponent(this.connectionsPanel.getComponentAt(n));
            this.connectionsPanel.grabFocus();
        }
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void displayPropertyChanged(String what, Object property) {
        Enumeration en = Main.getMachines();
        while (en.hasMoreElements()) {
            Interface iface = ((Machine)en.nextElement()).getInterface();
            if (iface == null) continue;
            iface.displayPropertyChanged(what, property);
        }
        if (Main.tubeBookmarks != null) {
            Main.tubeBookmarks.displayPropertyChanged(what, property);
        }
        if (Main.tubeTracker != null) {
            Main.tubeTracker.displayPropertyChanged(what, property);
        }
        if (what.equals("bookmarkentries")) {
            this.rebuildBookmarkMenu();
        }
    }

    public void error(Object o) {
        new Error(o.toString());
    }
}

