/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PipedInputStream;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import redlight.client.AbstractViewInterface;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.TransferInterface;
import redlight.client.URLHandler;
import redlight.utils.DebuggerOutput;

public class ViewHTMLInterface
extends AbstractViewInterface
implements Runnable {
    JScrollPane scrollPane;
    JEditorPane text;
    StringBuffer content = new StringBuffer();

    ViewHTMLInterface(Machine machine, TransferInterface transferInterface, String filename, long total, PipedInputStream inputPipe) {
        super(machine, transferInterface, "HTML", filename, total, inputPipe);
        this.text = new JEditorPane("text/html", "<b>Please wait ...</b>");
        this.scrollPane = new JScrollPane(this.text);
        this.text.setBackground(machine.getSchemeColor("background"));
        this.text.setForeground(machine.getSchemeColor("foreground"));
        this.text.setEditable(false);
        this.text.setFont((Font)Main.rlo.getProperty("Font.text"));
        this.text.setContentType("text/html");
        this.text.addHyperlinkListener(new URLHandler(this.rlm, transferInterface.path, transferInterface.file));
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.scrollPane, "Center");
        this.f.pack();
        this.show();
        this.f.setSize(300, 300);
        new Thread(this).start();
    }

    public void setContent(Machine rlm, TransferInterface transferInterface, String type, String filename, long total, PipedInputStream inputPipe) {
        super.setContent(rlm, transferInterface, type, filename, total, inputPipe);
        if (this.text != null) {
            new Thread(this).start();
        }
    }

    public void closeWindow() {
        super.closeWindow();
        this.scrollPane.setViewportView(null);
        this.content = null;
        this.text.setText("");
        this.text = null;
        this.scrollPane = null;
    }

    public synchronized void run() {
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(this.inputPipe));
        this.content.setLength(0);
        try {
            String line = lineReader.readLine();
            while (line != null) {
                this.content.append(line + "\n");
                line = lineReader.readLine();
            }
        }
        catch (IOException e) {
            DebuggerOutput.stackTrace(e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ViewHTMLInterface.this.text.setText(ViewHTMLInterface.this.content.toString());
            }
        });
        DebuggerOutput.debug("ViewHTMLInterface.slurper: exiting");
    }
}

