/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import redlight.hotline.ComponentFactory;
import redlight.utils.DebuggerOutput;
import redlight.utils.SignUtils;
import redlight.utils.Sortable;
import redlight.utils.TextUtils;
import redlight.utils.ToArrayConverters;

public class HLProtocol {
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, MMM dd, yyyy, kk:mm:ss");
    public static final int SOCK_SEND_BUF_SIZE = 16384;
    public static final int SOCK_RECEIVE_BUF_SIZE = 16384;
    public static final boolean hexdumpPayload = false;
    public static boolean asynchronousFileTransfers = false;
    public static final short HTRK_TCPPORT = 5498;
    public static final short HTRK_UDPPORT = 5499;
    public static final short HTLS_TCPPORT = 5500;
    static final short HTXF_TCPPORT = 5501;
    public static final char DIR_SEPARATOR = ':';
    static final String HTLC_MAGIC = "TRTPHOTL\u0000\u0001\u0000\u0002";
    static final short HTLC_MAGIC_LEN = 12;
    static final String HTLS_MAGIC = "TRTP\u0000\u0000\u0000\u0000";
    static final short HTLS_MAGIC_LEN = 8;
    static final String HTRK_MAGIC = "HTRK\u0000\u0001";
    static final short HTRK_MAGIC_LEN = 6;
    static final String HTXF_MAGIC = "HTXF";
    static final short HTXF_MAGIC_LEN = 4;
    static final int HTXF_MAGIC_INT = 1213487174;
    static final short SIZEOF_PACKETHEADER = 22;
    static final short SIZEOF_DATACOMPONENT = 4;
    static final int HTLC_HDR_USER_CHANGE = 304;
    static final int HTLC_HDR_CHAT = 105;
    static final int HTLC_HDR_LOGIN = 107;
    static final int HTLC_HDR_MSG = 108;
    static final int HTLC_HDR_NEWS_POST = 103;
    static final int HTLC_HDR_USER_GETINFO = 303;
    static final int HTLC_HDR_USER_KICK = 110;
    static final int HTLC_HDR_DIR_LIST = 200;
    static final int HTLC_HDR_ACCOUNT_CREATE = 350;
    static final int HTLC_HDR_ACCOUNT_DELETE = 351;
    static final int HTLC_HDR_ACCOUNT_READ = 352;
    static final int HTLC_HDR_ACCOUNT_MODIFY = 353;
    static final int HTLC_HDR_FILE_GET = 202;
    static final int HTLC_HDR_FILE_PUT = 203;
    static final int HTLC_HDR_DIR_CREATE = 205;
    static final int HTLC_HDR_FILE_GETINFO = 206;
    static final int HTLC_HDR_USER_LIST = 300;
    static final int HTLC_HDR_NEWS_GET = 101;
    static final int HTLC_HDR_FILE_SETINFO = 207;
    static final int HTLC_HDR_FILE_DELETE = 204;
    static final int HTLC_HDR_FILE_MOVE = 208;
    static final int HTLC_HDR_FILE_MAKE_ALIAS = 209;
    static final int HTLC_HDR_PRIVCHAT_CREATE = 112;
    static final int HTLC_HDR_PRIVCHAT_INVITE = 113;
    static final int HTLC_HDR_PRIVCHAT_DECLINE = 114;
    static final int HTLC_HDR_PRIVCHAT_JOIN = 115;
    static final int HTLC_HDR_PRIVCHAT_LEAVE = 116;
    static final int HTLC_HDR_PRIVCHAT_SUBJECT = 120;
    static final int HTLC_HDR_AGREE = 121;
    static final short HTLC_DATA_ICON = 104;
    static final short HTLC_DATA_NICK = 102;
    static final short HTLC_DATA_OPTION = 109;
    static final short HTLC_DATA_LOGIN = 105;
    static final short HTLC_DATA_PASSWORD = 106;
    static final short HTLC_DATA_SOCKET = 103;
    static final short HTLC_DATA_CHAT = 101;
    static final short HTLC_DATA_MSG = 101;
    static final short HTLC_DATA_NEWS_POST = 101;
    static final short HTLC_DATA_LISTDIR = 202;
    static final short HTLC_DATA_FILE = 201;
    static final short HTLC_DATA_DIR = 202;
    static final short HTLC_DATA_RFLT = 203;
    static final short HTLC_DATA_XFERSIZE = 108;
    static final short HTLC_DATA_BAN = 113;
    static final short HTLC_DATA_CHAT_REF = 114;
    static final short HTLC_DATA_CHAT_SUBJECT = 115;
    static final short HTLC_DATA_FILENAME = 123;
    static final short HTLC_DATA_RESUME = 204;
    static final short HTLC_DATA_FILE_RENAME = 211;
    static final short HTLC_DATA_DIR_RENAME = 212;
    static final int HTLS_HDR_USER_LEAVE = 302;
    static final int HTLS_HDR_USER_CHANGE = 301;
    static final int HTLS_HDR_TASK = 65536;
    static final int HTLS_HDR_NEWS_POST = 102;
    static final int HTLS_HDR_MSG = 104;
    static final int HTLS_HDR_CHAT = 106;
    static final int HTLS_HDR_AGREEMENT = 109;
    static final int HTLS_HDR_POLITEQUIT = 111;
    static final int HTLS_HDR_CHAT_INVITE = 113;
    static final int HTLS_HDR_CHAT_USER_CHANGE = 117;
    static final int HTLS_HDR_CHAT_USER_LEAVE = 118;
    static final int HTLS_HDR_CHAT_SUBJECT = 119;
    static final int HTLS_HDR_USERDISCONNECT = 302;
    static final int HTLS_HDR_QUEUEPOS = 211;
    static final short HTLS_DATA_SOCKET = 103;
    static final short HTLS_DATA_LOGIN = 105;
    static final short HTLS_DATA_PASSWORD = 106;
    static final short HTLS_DATA_PRIVILEGES = 110;
    static final short HTLS_DATA_TASKERROR = 100;
    static final short HTLS_DATA_OPTION = 109;
    static final short HTLS_DATA_ICON = 104;
    static final short HTLS_DATA_COLOUR = 112;
    static final short HTLS_DATA_NICK = 102;
    static final short HTLS_DATA_USER_LIST = 300;
    static final short HTLS_DATA_NEWS = 101;
    static final short HTLS_DATA_AGREEMENT = 101;
    static final short HTLS_DATA_USER_INFO = 101;
    static final short HTLS_DATA_CHAT = 101;
    static final short HTLS_DATA_MSG = 101;
    static final short HTLS_DATA_FILE_LIST = 200;
    static final short HTLS_DATA_FILE_ICON = 213;
    static final short HTLS_DATA_FILE_TYPE = 205;
    static final short HTLS_DATA_FILE_CREATOR = 206;
    static final short HTLS_DATA_FILE_SIZE = 207;
    static final short HTLS_DATA_FILE_NAME = 201;
    static final short HTLS_DATA_FILE_COMMENT = 210;
    static final short HTLS_DATA_FILE_DATE_CREATED = 208;
    static final short HTLS_DATA_FILE_DATE_MODIFIED = 209;
    static final short HTLS_DATA_HTXF_REF = 107;
    static final short HTLS_DATA_HTXF_SIZE = 108;
    static final short HTLS_DATA_HTXF_QUEUEPOS = 116;
    static final short HTLS_DATA_HTXF_RFLT = 203;
    static final short HTLS_DATA_CHAT_REF = 114;
    static final short HTLS_DATA_CHAT_SUBJECT = 115;
    static final short HTLS_DATA_VERSION = 160;
    static final short HTLS_DATA_AUTO_AGREE = 154;
    static final short DL_WHOLE_FILE = 0;
    static final short DL_DATA_FORK = 2;
    static final short HTLX_DATA_APP_ID = 3585;
    static final short HTLX_DATA_APP_STRING = 3586;
    static final short HTLX_DATA_SESSION_KEY = 3587;
    static final short HTLX_DATA_MAC_ALGORITHM = 3588;

    public static Calendar hotlineDateToCalendar(byte[] hotlineDate) {
        if (hotlineDate.length != 8) {
            throw new IllegalArgumentException("Hotline date is not 8 bytes");
        }
        Calendar calendar = Calendar.getInstance();
        byte[] epoch = new byte[]{hotlineDate[0], hotlineDate[1]};
        byte[] seconds = new byte[]{hotlineDate[4], hotlineDate[5], hotlineDate[6], hotlineDate[7]};
        int nEpoch = ToArrayConverters.byteArrayToInt(epoch);
        long nSeconds = ToArrayConverters.byteArrayToLong(seconds);
        int days = (int)(nSeconds / 86400L);
        calendar.setLenient(true);
        calendar.clear();
        calendar.set(1, nEpoch);
        calendar.add(5, days);
        calendar.add(13, (int)nSeconds - days * 86400);
        return calendar;
    }

    public static byte[] calendarToHotlineDate(Calendar calendar) {
        byte[] hotlineDate = new byte[8];
        byte[] epochBytes = ToArrayConverters.shortToByteArray(1970);
        byte[] secondsBytes = ToArrayConverters.intToByteArray((int)(calendar.getTime().getTime() / 1000L));
        hotlineDate = new byte[]{epochBytes[0], epochBytes[1], 0, 0, secondsBytes[0], secondsBytes[1], secondsBytes[2], secondsBytes[3]};
        return hotlineDate;
    }

    static byte[] invert(byte[] b) {
        byte[] encoded = b;
        int i = 0;
        while (i < b.length) {
            encoded[i] = (byte)(255 - encoded[i]);
            ++i;
        }
        return encoded;
    }

    class PathComponent
    extends DataComponent {
        public String path;

        public PathComponent(short dataType, String path) {
            super(dataType);
            this.path = path;
            this.construct();
        }

        PathComponent(short dataType, DataInputStream dis) throws IOException {
            super(dataType, dis);
            ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
            DataInputStream is = new DataInputStream(bis);
            int dc = is.readChar();
            this.path = "";
            if (dc == 0) {
                this.path = String.valueOf(':');
            }
            while (dc-- > 0) {
                short z = is.readShort();
                byte[] el = new byte[is.readUnsignedByte()];
                is.read(el, 0, el.length);
                this.path = this.path + ':' + new String(el);
            }
            this.construct();
        }

        private void construct() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                StringBuffer buf = new StringBuffer(this.path);
                StringTokenizer st = new StringTokenizer(this.path, String.valueOf(':'));
                dos.writeChar((char)st.countTokens());
                while (st.hasMoreTokens()) {
                    String f = st.nextToken();
                    dos.writeShort(0);
                    dos.writeByte((byte)f.getBytes().length);
                    dos.write(f.getBytes(), 0, f.getBytes().length);
                }
                dos.flush();
                this.data = bos.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return "PathComponent[type = 0x" + Integer.toHexString(this.type) + ", " + this.path + "]";
        }
    }

    class FileComponent
    extends DataComponent {
        String file;

        public FileComponent(String file) {
            super((short)201);
            this.file = file;
            this.construct();
        }

        public FileComponent(DataInputStream din) throws IOException {
            super((short)201, din);
            this.file = new String(this.data);
        }

        private void construct() {
            this.data = this.file.getBytes();
        }
    }

    public class FileInfo {
        public String name;
        public String creator;
        public String type;
        public String icon;
        public String comment;
        public long size;
        public Calendar created;
        public Calendar modified;

        public String toString() {
            return "FileInfo[" + this.name + ", " + this.creator + ", " + this.type + ", " + this.icon + ", " + this.comment + ", " + this.size + ", " + HLProtocol.this.dateFormatter.format(this.created.getTime()) + ", " + HLProtocol.this.dateFormatter.format(this.modified.getTime()) + "]";
        }
    }

    public class AccountInfo {
        public String nick;
        public String login;
        public String password;
        public long privileges;
        public String homeDirectory;
        public static final long CAN_RENAME_FOLDERS = 1L;
        public static final long CAN_DELETE_FOLDERS = 2L;
        public static final long CAN_CREATE_FOLDERS = 4L;
        public static final long CAN_MOVE_FILES = 8L;
        public static final long CAN_RENAME_FILES = 16L;
        public static final long CAN_DOWNLOAD_FILES = 32L;
        public static final long CAN_UPLOAD_FILES = 64L;
        public static final long CAN_DELETE_FILES = 128L;
        public static final long CAN_DELETE_ACCOUNTS = 256L;
        public static final long CAN_CREATE_ACCOUNTS = 512L;
        public static final long CAN_SEND_CHAT = 8192L;
        public static final long CAN_READ_CHAT = 16384L;
        public static final long CAN_MOVE_FOLDERS = 32768L;
        public static final long CANNOT_BE_DISCONNECTED = 65536L;
        public static final long CAN_DISCONNECT_USERS = 131072L;
        public static final long CAN_POST_NEWS = 262144L;
        public static final long CAN_READ_NEWS = 524288L;
        public static final long CAN_MODIFY_ACCOUNTS = 0x400000L;
        public static final long CAN_READ_ACCOUNTS = 0x800000L;
        public static final long CAN_MAKE_ALIASES = 0x1000000L;
        public static final long CAN_VIEW_DROPBOXES = 0x2000000L;
        public static final long CAN_COMMENT_FOLDERS = 0x4000000L;
        public static final long CAN_COMMENT_FILES = 0x8000000L;
        public static final long DONT_SHOW_AGREEMENT = 0x10000000L;
        public static final long CAN_USE_ANY_NAME = 0x20000000L;
        public static final long CAN_UPLOAD_ANYWHERE = 0x40000000L;
        public static final long CAN_GET_USER_INFO = 0x80000000L;

        public AccountInfo(String l, String n, String p, long pr, String h) {
            this.login = l;
            this.nick = n;
            this.password = p;
            this.privileges = pr;
            this.homeDirectory = h;
        }

        public AccountInfo() {
            this("", "", "", 0L, "");
        }

        public String toString() {
            return "HLProtocol.AccountInfo[login = " + this.login + ", password = <not shown>, nick = " + this.nick + ", privileges = " + this.privileges + ", homeDirectory = " + this.homeDirectory + "]";
        }
    }

    public class ServerInfo {
        public int address;
        public char port;
        public short nusers;
        public short unknown;
        public String name;
        public String desc;

        public ServerInfo() {
        }

        public ServerInfo(DataInputStream din) throws IOException {
            this.read(din);
        }

        void read(DataInputStream din) throws IOException {
            this.address = din.readInt();
            this.port = (char)din.readShort();
            this.nusers = din.readShort();
            this.unknown = din.readShort();
            byte[] n = new byte[(short)(SignUtils.toUnsigned(din.readByte()) & 0xFF)];
            din.readFully(n, 0, n.length);
            this.name = new String(n, "ISO-8859-1");
            byte[] d = new byte[(short)(SignUtils.toUnsigned(din.readByte()) & 0xFF)];
            din.readFully(d, 0, d.length);
            this.desc = new String(d, "ISO-8859-1");
        }

        public String getAddress() {
            char[] b = ToArrayConverters.intToCharArray(this.address);
            return new String(b[0] + "." + b[1] + "." + b[2] + "." + b[3]);
        }

        public String toString() {
            return "ServerInfo[name = " + this.name + ", description = " + this.desc + "]";
        }
    }

    class TrackerPacketHeader {
        public byte[] unknown;
        public short pack;
        public short nservers;

        public TrackerPacketHeader(DataInputStream din) throws IOException {
            this.read(din);
        }

        void read(DataInputStream din) throws IOException {
            byte[] unknown = new byte[4];
            din.readFully(unknown, 0, 4);
            this.nservers = din.readShort();
            this.pack = din.readShort();
        }
    }

    class FileTransferInfo {
        String fileName;
        String fileType;
        String fileCreator;
        String fileComment;
        Calendar creationDate;
        Calendar modificationDate;
        int numberOfBlocks;
        int finderFlags;
        byte[] data;

        public FileTransferInfo(String fName, String fType, String fCreator, String fComment, Calendar created, Calendar modified, int flags) throws IOException {
            if (fComment.length() > 255) {
                throw new IllegalArgumentException("comment length must be <= 255.");
            }
            if (fType.length() != 4) {
                throw new IllegalArgumentException("file type must be 4 bytes.");
            }
            if (fCreator.length() != 4) {
                throw new IllegalArgumentException("file creator must be 4 bytes.");
            }
            this.fileName = fName;
            this.fileType = fType;
            this.fileCreator = fCreator;
            this.fileComment = fComment;
            this.creationDate = created;
            this.modificationDate = modified;
            this.finderFlags = flags;
            this.construct();
        }

        public FileTransferInfo(DataInputStream originalInput) throws IOException {
            DataInputStream input = originalInput;
            ByteArrayOutputStream monitorBos = new ByteArrayOutputStream();
            DataOutputStream monitorDos = new DataOutputStream(monitorBos);
            byte[] filp = new byte[40];
            originalInput.readFully(filp, 0, 40);
            monitorDos.write(filp);
            ByteArrayInputStream bis = new ByteArrayInputStream(filp);
            input = new DataInputStream(bis);
            byte[] magic = new byte[4];
            input.readFully(magic, 0, 4);
            if (!new String(magic).equals("FILP")) {
                throw new IOException("Not a FileTransferInfo - bad magic.");
            }
            short parameter = input.readShort();
            if (parameter != 1) {
                throw new IOException("Scared of unknown parameter 1 (is " + parameter + ", expected 1).");
            }
            input.skipBytes(14);
            this.numberOfBlocks = input.readInt();
            if (this.numberOfBlocks != 3 && this.numberOfBlocks != 2) {
                throw new IOException("Scared of numberOfBlocks value (is " + this.numberOfBlocks + ", expected 2 or 3).");
            }
            input.readFully(magic, 0, 4);
            if (!new String(magic).equals("INFO")) {
                throw new IOException("Got " + new String(magic) + ", expected INFO.");
            }
            input.skipBytes(8);
            int headerRemaining = input.readInt();
            if (headerRemaining > 65536) {
                throw new IOException("Scared of too large FileTransferInfo size (" + headerRemaining + ").");
            }
            byte[] amac = new byte[headerRemaining];
            originalInput.readFully(amac, 0, headerRemaining);
            monitorDos.write(amac);
            monitorDos.flush();
            this.data = monitorBos.toByteArray();
            bis = new ByteArrayInputStream(amac);
            input = new DataInputStream(bis);
            input.readFully(magic, 0, 4);
            if (!new String(magic).equals("AMAC") && !new String(magic).equals("MWIN")) {
                throw new IOException("Got " + new String(magic) + ", expected AMAC or MWIN.");
            }
            input.readFully(magic, 0, 4);
            this.fileType = new String(magic);
            input.readFully(magic, 0, 4);
            this.fileCreator = new String(magic);
            input.skipBytes(6);
            this.finderFlags = input.readUnsignedByte();
            input.skipBytes(33);
            byte[] date = new byte[8];
            input.readFully(date, 0, 8);
            this.creationDate = HLProtocol.hotlineDateToCalendar(date);
            input.readFully(date, 0, 8);
            this.modificationDate = HLProtocol.hotlineDateToCalendar(date);
            int filenameLength = input.readInt();
            if (filenameLength > (headerRemaining -= 60)) {
                throw new IOException("FileTransferInfo is inconsistent, filename exceeds total header length.");
            }
            byte[] fName = new byte[filenameLength];
            input.readFully(fName, 0, filenameLength);
            this.fileName = new String(fName);
            input.skipBytes(1);
            char commentLength = (char)SignUtils.toUnsigned(input.readByte());
            if (commentLength > (headerRemaining -= filenameLength + 2)) {
                throw new IOException("FileTransferInfo is inconsistent, comment length (" + commentLength + ") exceeds total header length (" + headerRemaining + ").");
            }
            byte[] fComment = new byte[commentLength];
            input.readFully(fComment, 0, commentLength);
            this.fileComment = new String(fComment);
            input.skipBytes(1);
        }

        public void write(DataOutputStream output) throws IOException {
            output.write(this.data);
            output.flush();
        }

        private void construct() throws IOException {
            ByteArrayOutputStream monitorBos = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(monitorBos);
            byte[] buf = new byte[33];
            output.write(new String("FILP").getBytes());
            output.writeShort(1);
            output.write(buf, 0, 14);
            output.writeInt(3);
            output.write(new String("INFO").getBytes());
            output.write(buf, 0, 8);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.write(new String("AMAC").getBytes());
            dos.write(this.fileType.getBytes());
            dos.write(this.fileCreator.getBytes());
            dos.write(buf, 0, 6);
            dos.writeByte((byte)this.finderFlags);
            dos.write(buf, 0, 33);
            byte[] created = HLProtocol.calendarToHotlineDate(this.creationDate);
            byte[] modified = HLProtocol.calendarToHotlineDate(this.modificationDate);
            dos.write(created);
            dos.write(modified);
            dos.writeInt(this.fileName.length());
            dos.write(this.fileName.getBytes());
            dos.writeByte(0);
            dos.writeByte((short)this.fileComment.length());
            dos.write(this.fileComment.getBytes());
            dos.writeByte(0);
            dos.flush();
            output.writeInt(bos.toByteArray().length);
            output.write(bos.toByteArray());
            output.flush();
            this.data = monitorBos.toByteArray();
        }
    }

    class FileTransferHeader {
        public int ref;
        public long len;
        public int unknown = 0;

        FileTransferHeader(int r, long l) {
            this.ref = r;
            this.len = l;
        }

        FileTransferHeader(DataInputStream din) throws IOException {
            this.read(din);
        }

        void write(DataOutputStream dos) throws IOException {
            dos.writeInt(1213487174);
            dos.writeInt(this.ref);
            int low = (int)(this.len & 0xFFFFFFFFL);
            int high = (int)(this.len >> 32);
            dos.writeInt(low);
            dos.writeInt(high);
            dos.flush();
        }

        void read(DataInputStream din) throws IOException {
            int magic = din.readInt();
            if (magic != 1213487174) {
                throw new IOException("not a FileTransferHeader");
            }
            this.ref = din.readInt();
            int low = din.readInt();
            int high = din.readInt();
            this.len = (long)high << 32 | (long)low;
        }

        public String toString() {
            return "FileTransferHeader[ref = 0x" + Integer.toHexString(this.ref) + ", len = " + this.len + ", unknown = " + this.unknown + "]";
        }
    }

    class DateComponent
    extends DataComponent {
        Calendar date;

        public DateComponent(short type, Calendar when) {
            super(type);
            this.date = when;
            this.data = HLProtocol.calendarToHotlineDate(this.date);
        }

        public DateComponent(short type, DataInputStream in) throws IOException {
            super(type, in);
            this.date = HLProtocol.hotlineDateToCalendar(this.data);
        }

        public String toString() {
            return "DateComponent[type = 0x" + Integer.toHexString(this.type) + ", " + HLProtocol.this.dateFormatter.format(this.date.getTime()) + "]";
        }
    }

    public class FileListComponent
    extends DataComponent
    implements Cloneable,
    Sortable {
        public String fileType;
        public String fileCreator;
        public long fileSize;
        public int unknown;
        public String fileName;

        public FileListComponent(String fName, String fType, String fCreator, long fSize, int fExtra) {
            super((short)200);
            if (fType.length() != 4) {
                throw new IllegalArgumentException("File type must be 4 bytes.");
            }
            if (fCreator.length() != 4) {
                throw new IllegalArgumentException("File creator must be 4 bytes.");
            }
            this.fileName = fName;
            this.fileType = fType;
            this.fileCreator = fCreator;
            this.fileSize = fSize;
            this.unknown = fExtra;
            this.construct();
        }

        public FileListComponent(DataInputStream is) throws IOException {
            super((short)200, is);
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(this.data));
            byte[] ftype = new byte[4];
            byte[] fcreator = new byte[4];
            din.read(ftype, 0, 4);
            din.read(fcreator, 0, 4);
            this.fileSize = din.readInt();
            this.unknown = din.readInt();
            byte[] fname = new byte[din.readInt()];
            din.readFully(fname, 0, fname.length);
            this.fileType = new String(ftype);
            this.fileCreator = new String(fcreator);
            this.fileName = new String(fname);
        }

        private void construct() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                byte[] ftype = this.fileType.getBytes();
                byte[] fcreator = this.fileCreator.getBytes();
                dos.write(ftype, 0, 4);
                dos.write(fcreator, 0, 4);
                dos.writeInt((int)this.fileSize);
                dos.writeInt(this.unknown);
                dos.writeInt(this.fileName.length());
                dos.write(this.fileName.getBytes());
                dos.flush();
                this.data = bos.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String toString() {
            return "FileListComponent[" + this.fileType + ", " + (this.fileType.equals("fldr") ? "" : this.fileCreator + ", ") + this.fileSize + ", " + this.fileName + "]";
        }

        public boolean smallerThan(Sortable other) {
            if (other instanceof FileListComponent) {
                FileListComponent otherFile = (FileListComponent)other;
                if (this.fileType.equals("fldr") && !otherFile.fileType.equals("fldr")) {
                    return true;
                }
                if (!this.fileType.equals("fldr") && otherFile.fileType.equals("fldr")) {
                    return false;
                }
                return this.fileName.compareToIgnoreCase(otherFile.fileName) < 0;
            }
            return this.fileName.compareToIgnoreCase(other.toString()) < 0;
        }
    }

    class ResumeTransferComponent
    extends DataComponent {
        Hashtable chunks = new Hashtable();

        ResumeTransferComponent() {
            this(0L, 0L);
        }

        ResumeTransferComponent(long dataSize, long macrSize) {
            super((short)203);
            this.chunks.put("DATA", new Long(dataSize));
            this.chunks.put("MACR", new Long(macrSize));
            this.construct();
        }

        ResumeTransferComponent(DataInputStream is) throws IOException {
            super((short)203, is);
            this.chunks.put("DATA", new Long(0L));
            this.chunks.put("MACR", new Long(0L));
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(this.data));
            byte[] id = new byte[4];
            din.readFully(id, 0, 4);
            if (new String(id).equals("RFLT")) {
                byte[] not_interesting = new byte[38];
                din.readFully(not_interesting, 0, 38);
                int available = this.data.length - 42;
                while (available > 0) {
                    din.readFully(id, 0, 4);
                    int low = din.readInt();
                    int high = din.readInt();
                    long chunkSize = (long)high << 32 | (long)low;
                    din.readInt();
                    this.chunks.put(new String(id), new Long(chunkSize));
                    available -= 16;
                }
            } else {
                throw new IllegalArgumentException("not a ResumeTransferComponent");
            }
            this.construct();
        }

        private void construct() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                dos.write(new String("RFLT").getBytes());
                dos.writeShort(1);
                dos.write(new byte[34], 0, 34);
                dos.writeShort(2);
                dos.write(new String("DATA").getBytes());
                long ds = (Long)this.chunks.get("DATA");
                int low = (int)(ds & 0xFFFFFFFFL);
                int high = (int)(ds >> 32);
                dos.writeInt(low);
                dos.writeInt(high);
                dos.writeInt(0);
                dos.write(new String("MACR").getBytes());
                long rs = (Long)this.chunks.get("MACR");
                low = (int)(rs & 0xFFFFFFFFL);
                high = (int)(rs >> 32);
                dos.writeInt(low);
                dos.writeInt(high);
                dos.writeInt(0);
                dos.flush();
                this.data = bos.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return "ResumeTransferComponent[DATA = " + (Long)this.chunks.get("DATA") + ", MACR = " + (Long)this.chunks.get("MACR") + "]";
        }
    }

    public class UserListComponent
    extends DataComponent {
        public int sock;
        public int icon;
        public short clr;
        public String nick = null;
        public static final short HAS_BEEN_IDLE = 1;
        public static final short CAN_DISCONNECT_USERS = 2;

        UserListComponent(int s, int i, short c, String n) {
            super((short)300);
            this.sock = s;
            this.icon = i;
            this.clr = c;
            this.nick = n;
            this.construct();
        }

        UserListComponent(DataInputStream is) throws IOException {
            super((short)300, is);
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(this.data));
            this.sock = din.readChar();
            this.icon = din.readChar();
            this.clr = din.readShort();
            byte[] n = new byte[din.readChar()];
            din.readFully(n, 0, n.length);
            this.nick = new String(n);
        }

        void write(DataOutputStream os) throws IOException {
            this.construct();
            super.write(os);
        }

        private void construct() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                dos.writeShort(this.sock);
                dos.writeShort(this.icon);
                dos.writeShort(this.clr);
                if (this.nick != null) {
                    dos.writeShort(this.nick.length());
                    dos.write(this.nick.getBytes());
                }
                this.data = bos.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            String s = "UserListComponent[icon: " + this.icon + ", sock: " + this.sock + ", name: " + new String(this.nick);
            String state = null;
            if ((this.clr & 2) == 2) {
                state = "CAN_DISCONNECT_USERS";
            }
            if ((this.clr & 1) == 1) {
                state = state != null ? state + ", " : "";
                state = state + "HAS_BEEN_IDLE";
            }
            if (state != null) {
                s = s + ", state: " + state;
            }
            s = s + "]";
            return s;
        }
    }

    class DataComponent
    implements Cloneable {
        public short type;
        public byte[] data;

        DataComponent(short t) {
            this.type = t;
            this.data = new byte[0];
        }

        DataComponent(short t, byte[] d) {
            this.type = t;
            this.data = d != null ? d : new byte[]{};
        }

        DataComponent(short t, DataInputStream din) throws IOException {
            this.type = t;
            this.data = new byte[din.readChar()];
            din.readFully(this.data, 0, this.data.length);
        }

        DataComponent(DataInputStream din) throws IOException {
            this(din.readShort(), din);
        }

        void write(DataOutputStream dos) throws IOException {
            dos.writeChar(this.type);
            dos.writeChar((char)this.data.length);
            dos.write(this.data, 0, this.data.length);
            dos.flush();
        }

        public String toString() {
            String dataString = new String("");
            switch (this.type) {
                case 103: 
                case 104: 
                case 108: 
                case 109: 
                case 112: 
                case 160: 
                case 207: {
                    dataString = new Integer(ToArrayConverters.byteArrayToInt(this.data)).toString();
                    break;
                }
                case 208: 
                case 209: {
                    try {
                        ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
                        DataInputStream dis = new DataInputStream(bis);
                        dataString = new DateComponent(this.type, dis).toString();
                    }
                    catch (IOException e) {}
                    break;
                }
                case 107: 
                case 114: {
                    dataString = "0x" + Integer.toHexString(ToArrayConverters.byteArrayToInt(this.data));
                    break;
                }
                default: {
                    dataString = new String(this.data);
                    dataString = TextUtils.findAndReplace(dataString, "\r", "\\r");
                    dataString = TextUtils.findAndReplace(dataString, "\n", "\\n");
                    if (dataString.length() <= 40) break;
                    int restLen = dataString.length();
                    dataString = dataString.substring(0, 40);
                    dataString = dataString + "... (" + restLen + ")";
                }
            }
            return "DataComponent[type = 0x" + Integer.toHexString(this.type) + ", data = " + dataString + "]";
        }
    }

    class PacketHeader {
        public int cls;
        public int id;
        public int trans;
        public int isError;
        public long len;
        public long len2;
        public short hc;

        public PacketHeader() {
        }

        public PacketHeader(int t, int i, int tr, int isError, int l, int c) {
            this.cls = t;
            this.id = i;
            this.trans = tr;
            this.isError = isError;
            this.len = this.len2 = (long)l;
            this.hc = (short)c;
        }

        public PacketHeader(DataInputStream din) throws IOException {
            this.read(din);
        }

        public void read(DataInputStream din) throws IOException {
            if (din == null) {
                DebuggerOutput.debug("DataInputStream called with NULL");
            }
            int temp = din.readInt();
            this.cls = temp >> 16;
            this.id = temp == 65536 ? 65536 : temp & 0xFFFF;
            this.trans = din.readInt();
            this.isError = din.readInt();
            this.len = din.readInt();
            this.len2 = din.readInt();
            this.hc = 0;
            if (this.len != this.len2) {
                throw new IOException("Not a Hotline packet");
            }
            if (this.len >= 2L) {
                this.hc = din.readShort();
            }
        }

        public void write(DataOutputStream dos) throws IOException {
            int temp = this.cls << 16 | this.id;
            dos.writeInt(temp);
            dos.writeInt(this.trans);
            dos.writeInt(this.isError);
            dos.writeInt((int)this.len);
            dos.writeInt((int)this.len2);
            dos.writeShort(this.hc);
            dos.flush();
        }

        public String toString() {
            return "PacketHeader[cls = 0x" + Integer.toHexString(this.cls) + ", id = 0x" + Integer.toHexString(this.id) + ", trans = " + this.trans + ", isError = " + this.isError + ", len = " + this.len + ", len2 = " + this.len2 + ", hc = " + this.hc + "]";
        }
    }

    class Packet {
        PacketHeader header;
        DataComponent[] dataComponents;

        Packet(DataInputStream input) throws IOException {
            this.header = new PacketHeader(input);
            if (this.header.len >= 2L) {
                byte[] payload = new byte[(int)this.header.len - 2];
                input.readFully(payload, 0, payload.length);
                ByteArrayInputStream bis = new ByteArrayInputStream(payload);
                DataInputStream dis = new DataInputStream(bis);
                DataComponent[] specifiedComponents = new DataComponent[this.header.hc];
                int actualComponentCount = 0;
                int i = 0;
                while (i < specifiedComponents.length) {
                    specifiedComponents[i] = ComponentFactory.createComponent(dis);
                    if (specifiedComponents[i] != null) {
                        actualComponentCount = (short)(actualComponentCount + 1);
                    }
                    ++i;
                }
                this.dataComponents = new DataComponent[actualComponentCount];
                int j = 0;
                int i2 = 0;
                while (i2 < specifiedComponents.length) {
                    if (specifiedComponents[i2] != null) {
                        this.dataComponents[j++] = specifiedComponents[i2];
                    }
                    ++i2;
                }
                this.header.hc = (short)actualComponentCount;
            }
        }

        Packet(int type, int trans, DataComponent[] dataComponents) {
            if (dataComponents == null) {
                dataComponents = new DataComponent[]{};
            }
            this.header = new PacketHeader(0, type, trans, 0, 2 + 4 * dataComponents.length, 0);
            int k = 0;
            while (k < dataComponents.length) {
                if (dataComponents[k].data != null) {
                    this.header.len += (long)dataComponents[k].data.length;
                }
                ++k;
            }
            this.header.len2 = this.header.len;
            this.header.hc = (short)dataComponents.length;
            this.dataComponents = dataComponents;
        }

        boolean hasMoreComponents() {
            return this.header.hc > 0;
        }

        DataComponent nextComponent() {
            this.header.hc = (short)(this.header.hc - 1);
            return this.dataComponents[this.header.hc];
        }

        void write(DataOutputStream output) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            int k = 0;
            while (k < this.dataComponents.length) {
                this.dataComponents[k].write(dos);
                ++k;
            }
            dos.flush();
            byte[] payload = bos.toByteArray();
            DataOutputStream dataOutputStream = output;
            synchronized (dataOutputStream) {
                this.header.write(output);
                output.write(payload);
                output.flush();
            }
        }

        public String toString() {
            if (!DebuggerOutput.on) {
                return "Packet[debugging output disabled]";
            }
            String s = "Packet[" + this.header.toString() + ", ";
            if (this.dataComponents == null) {
                s = s + "null]";
            } else {
                s = s + "[";
                int i = 0;
                while (i < this.dataComponents.length) {
                    if (this.dataComponents[i] != null) {
                        s = s + this.dataComponents[i].toString();
                        if (i + 1 < this.dataComponents.length) {
                            s = s + ", ";
                        }
                    }
                    ++i;
                }
                s = s + "]";
            }
            s = s + "]";
            return s;
        }
    }
}

