/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerComponent;
import redlight.utils.TimeFormat;

public class HLServerBanTable
extends HLServerComponent {
    protected Hashtable table = new Hashtable();

    public HLServerBanTable(HLServer h) {
        super(h);
    }

    public Enumeration elements() {
        this.checkModified();
        return this.table.elements();
    }

    public boolean contains(InetAddress ip) {
        this.checkModified();
        return this.table.containsKey(ip.getHostAddress());
    }

    public void put(InetAddress ip, long expires) {
        if (ip == null) {
            throw new IllegalArgumentException("ip == null");
        }
        if (expires < 0L) {
            throw new IllegalArgumentException("expires < 0");
        }
        BanRecord b = new BanRecord(ip, expires);
        this.table.put(ip.getHostAddress(), b);
        this.hls.log("Banning " + ip.getHostAddress() + " for" + (expires == 0L ? "ever." : " " + TimeFormat.format(expires - System.currentTimeMillis() / 1000L)));
        this.hasChanged();
    }

    public void remove(InetAddress ip) {
        if (ip == null) {
            throw new IllegalArgumentException("ip == null");
        }
        if (this.table.containsKey(ip.getHostAddress())) {
            this.table.remove(ip.getHostAddress());
            this.hasChanged();
        }
    }

    void expire() {
        boolean changed = false;
        this.checkModified();
        Enumeration en = this.table.elements();
        while (en.hasMoreElements()) {
            BanRecord b = (BanRecord)en.nextElement();
            if (b.expires == 0L || System.currentTimeMillis() / 1000L <= b.expires) continue;
            this.hls.log("Expired ban for " + b.address.getHostAddress());
            this.table.remove(b.address.getHostAddress());
            changed = true;
        }
        if (changed) {
            this.hasChanged();
        }
    }

    public void hasChanged() {
    }

    public void checkModified() {
    }

    public class BanRecord {
        public InetAddress address;
        public long expires;

        public BanRecord(InetAddress a, long e) {
            this.address = a;
            this.expires = e;
        }
    }
}

