/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerDispatcher;
import redlight.hotline.TransferThread;
import redlight.utils.DebuggerOutput;

class HLServerMonitor
extends Thread {
    HLServer hls;

    HLServerMonitor(HLServer h) {
        this.hls = h;
        this.setName("HLServerMonitor " + h);
        this.start();
    }

    public synchronized void run() {
        block12: {
            DebuggerOutput.debug("HLServerMonitor starting ...");
            try {
                while (!this.isInterrupted()) {
                    this.hls.getTrackerTable().broadcast();
                    this.idleUsersAndDisconnectGhosts();
                    this.hls.getTransferQueue().expire();
                    Vector vector = this.hls.transferServer.transferThreads;
                    synchronized (vector) {
                        Enumeration en = this.hls.transferServer.transferThreads.elements();
                        while (en.hasMoreElements()) {
                            TransferThread t;
                            block11: {
                                t = (TransferThread)en.nextElement();
                                if (t.isAlive || System.currentTimeMillis() - t.creationTime <= 60000L) continue;
                                this.hls.log(t.client.getInetAddress(), "Disconnecting ghost file transfer connection.");
                                try {
                                    t.client.getInputStream().close();
                                    t.client.getOutputStream().close();
                                    t.client.close();
                                    t.interrupt();
                                    t.join();
                                }
                                catch (IOException e) {
                                    if (DebuggerOutput.on) {
                                        e.printStackTrace();
                                    }
                                }
                                catch (InterruptedException e) {
                                    if (!DebuggerOutput.on) break block11;
                                    e.printStackTrace();
                                }
                            }
                            this.hls.transferServer.transferThreads.removeElement(t);
                        }
                    }
                    this.wait(60000L);
                }
            }
            catch (InterruptedException _e) {
                if (!DebuggerOutput.on) break block12;
                _e.printStackTrace();
            }
        }
        DebuggerOutput.debug("HLServerMonitor exiting");
    }

    void idleUsersAndDisconnectGhosts() {
        HLServerDispatcher[] clients = this.hls.getClients();
        int i = 0;
        while (i < clients.length) {
            Integer n = clients[i].userStateLock;
            synchronized (n) {
                long deltaTime;
                if (clients[i].sock == -1) {
                    DebuggerOutput.debug("ghost last tranmission = " + clients[i].lastTransmissionTime + ", current = " + System.currentTimeMillis() + ", delta = " + (System.currentTimeMillis() - clients[i].lastTransmissionTime));
                    if (System.currentTimeMillis() - clients[i].lastTransmissionTime > 60000L) {
                        clients[i].disconnect();
                        this.hls.log(clients[i].client.getInetAddress(), "Disconnected ghost client.");
                    }
                } else if ((clients[i].color & 1) != 1 && (deltaTime = System.currentTimeMillis() - clients[i].lastTransmissionTime) > 600000L) {
                    this.hls.changeUser(clients[i], clients[i].sock, clients[i].nick, clients[i].icon, (short)(clients[i].color | 1));
                }
            }
            ++i;
        }
    }
}

