/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerComponent;
import redlight.hotline.HLTracker;
import redlight.utils.DebuggerOutput;

public class HLServerTrackerTable
extends HLServerComponent {
    protected Hashtable table = new Hashtable();

    public HLServerTrackerTable(HLServer h) {
        super(h);
    }

    public Enumeration elements() {
        this.checkModified();
        return this.table.elements();
    }

    public boolean contains(InetAddress ip) {
        this.checkModified();
        return this.table.containsKey(ip.getHostAddress());
    }

    public void put(InetAddress ip, String password) {
        if (ip == null) {
            throw new IllegalArgumentException("ip == null");
        }
        TrackerRecord t = new TrackerRecord(ip, password);
        this.table.put(ip.getHostAddress(), t);
        this.hasChanged();
    }

    public void remove(InetAddress ip) {
        if (ip == null) {
            throw new IllegalArgumentException("ip == null");
        }
        if (this.table.containsKey(ip.getHostAddress())) {
            this.table.remove(ip.getHostAddress());
            this.hasChanged();
        }
    }

    public synchronized void broadcast() {
        this.checkModified();
        Enumeration en = this.table.elements();
        while (en.hasMoreElements()) {
            TrackerRecord t = (TrackerRecord)en.nextElement();
            try {
                new HLTracker(t.address, 5499).sendServerInfo(this.hls.getPort(), this.hls.getServerName(), this.hls.getServerDescription(), (short)this.hls.getClients().length, t.password);
                DebuggerOutput.debug("HLServerTrackerTable.broadcast: sent server info to " + t.address.getHostName());
            }
            catch (IOException e) {
                this.hls.log("Error connecting to tracker " + t.address.toString() + " (" + e.toString() + ")");
            }
        }
    }

    public String toString() {
        Enumeration en = this.table.elements();
        String s = "HLServerTrackerTable[";
        while (en.hasMoreElements()) {
            s = s + en.nextElement().toString() + ", ";
        }
        return s + "]";
    }

    public void hasChanged() {
    }

    public void checkModified() {
    }

    public class TrackerRecord {
        public InetAddress address;
        public String password;

        public TrackerRecord(InetAddress a, String p) {
            this.address = a;
            this.password = p;
        }

        public String toString() {
            return "TrackerRecord[address = " + this.address.getHostName() + ", password = " + this.password + "]";
        }
    }
}

