/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline.iconlib;

import redlight.hotline.iconlib.HLRGB;
import redlight.hotline.iconlib.HLUtils;

public class HLIconData {
    int width;
    int height;
    int widthInBytes;
    int palLengthBytes;
    int palLengthLW;
    int transparency;
    byte[][] palette;
    byte[] rawData;
    int[] data;
    int datCounter = 0;
    int datSize = 0;

    public void malloc(int size) {
        this.datSize = size;
        this.data = new int[this.datSize];
    }

    public boolean add(HLRGB h) {
        if (this.data == null || this.datCounter >= this.datSize) {
            return false;
        }
        this.data[this.datCounter] = h.get();
        ++this.datCounter;
        return true;
    }

    public boolean add(int RGB) {
        if (this.data == null || this.datCounter >= this.datSize) {
            return false;
        }
        this.data[this.datCounter] = RGB;
        ++this.datCounter;
        return true;
    }

    public boolean add(byte red, byte green, byte blue) {
        if (this.data == null || this.datCounter >= this.datSize) {
            return false;
        }
        int val = 0;
        this.data[this.datCounter] = val = HLUtils.signedToUnsigned(red) << 16 | HLUtils.signedToUnsigned(green) << 8 | HLUtils.signedToUnsigned(blue);
        ++this.datCounter;
        return true;
    }

    public HLRGB get(int index) {
        if (index >= this.datCounter || index >= this.datSize || this.data == null) {
            return null;
        }
        return new HLRGB(this.data[index]);
    }

    public int getRGB(int index) {
        if (index >= this.datCounter || index >= this.datSize || this.data == null) {
            return -1;
        }
        return this.data[index];
    }

    public int getARGB(int index) {
        if (index >= this.datCounter || index >= this.datSize || this.data == null) {
            return 0;
        }
        int item = this.data[index];
        if (this.getTransparency() != item) {
            item |= 0xFF000000;
        }
        return item;
    }

    public int[] getARGBField() {
        if (this.datCounter == 0 || this.datSize == 0 || this.data == null) {
            return null;
        }
        int[] argbField = new int[this.datCounter];
        int i = 0;
        while (i < this.datCounter) {
            argbField[i] = this.getARGB(i);
            ++i;
        }
        return argbField;
    }

    public int[] getRGBField() {
        if (this.datCounter == 0 || this.datSize == 0 || this.data == null) {
            return null;
        }
        return this.data;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidthInBytes() {
        return this.widthInBytes;
    }

    public int getPalLengthBytes() {
        return this.palLengthBytes;
    }

    public int getPalLengthLW() {
        return this.palLengthLW;
    }

    public int getTransparency() {
        return this.transparency >> 8;
    }

    public byte[][] getPalette() {
        return this.palette;
    }

    public byte getRed(int index) {
        if (index >= this.datCounter || index >= this.datSize || this.data == null) {
            return -1;
        }
        return HLUtils.intToBytes(this.data[index])[1];
    }

    public byte getGreen(int index) {
        if (index >= this.datCounter || index >= this.datSize || this.data == null) {
            return -1;
        }
        return HLUtils.intToBytes(this.data[index])[2];
    }

    public byte getBlue(int index) {
        if (index >= this.datCounter || index >= this.datSize || this.data == null) {
            return -1;
        }
        return HLUtils.intToBytes(this.data[index])[3];
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public int[] getData() {
        return this.data;
    }
}

