/*
 * Decompiled with CFR 0.152.
 */
package redlight.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import redlight.crypto.UnixCrypt;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerAccountsTable;
import redlight.utils.DebuggerOutput;

public class AccountsTable
extends HLServerAccountsTable {
    HLProtocol hlp = new HLProtocol();
    File accountsFile;
    long lastModified;

    public AccountsTable(HLServer h, File file) {
        super(h);
        this.accountsFile = file;
    }

    public void hasChanged() {
        this.write(this.accountsFile);
    }

    public void checkModified() {
        if (this.accountsFile.lastModified() != this.lastModified) {
            this.hls.log("Accounts file " + this.accountsFile.toString() + " changed, reloading.");
            this.load();
        }
    }

    public void load() {
        this.load(this.accountsFile);
        this.lastModified = this.accountsFile.lastModified();
    }

    public void load(InputStream in) {
        Hashtable<String, HLProtocol.AccountInfo> tempTable = new Hashtable<String, HLProtocol.AccountInfo>();
        LineNumberReader lr = null;
        try {
            lr = new LineNumberReader(new InputStreamReader(in));
            String line = lr.readLine();
            while (line != null) {
                String password;
                String homedir;
                String privsAsString;
                String nick;
                String login;
                int nc = -1;
                int colonPos = 0;
                nc = -1;
                while (colonPos != -1) {
                    colonPos = line.indexOf(58, colonPos + 1);
                    ++nc;
                }
                if (nc > 2) {
                    int offset = 0;
                    login = line.substring(offset, line.indexOf(58));
                    nick = line.substring(offset += login.length() + 1, line.indexOf(58, offset));
                    privsAsString = line.substring(offset += nick.length() + 1, line.indexOf(58, offset));
                    offset += privsAsString.length() + 1;
                    homedir = null;
                    if (nc > 3) {
                        if ((homedir = line.substring(offset += (password = line.substring(offset, line.indexOf(58, offset))).length() + 1)).trim().equals("")) {
                            homedir = null;
                        }
                    } else {
                        password = line.substring(offset);
                    }
                    if (password.equals("")) {
                        password = UnixCrypt.crypt("aa", "");
                    }
                } else {
                    throw new RuntimeException("Format invalid");
                }
                long privileges = Long.parseLong(privsAsString);
                tempTable.put(login, this.hlp.new HLProtocol.AccountInfo(login, nick, password, privileges, homedir));
                DebuggerOutput.debug("AccountsTable.parseAccountsFile: login = " + login + ", nick = " + nick + ", password = " + password + ", privileges = " + privileges + ", homedir = " + homedir);
                line = lr.readLine();
            }
        }
        catch (NumberFormatException e) {
            tempTable = null;
            String error = "Accounts file  has invalid privilege field '" + e.getMessage() + "'";
            if (lr != null) {
                error = error + " at line " + lr.getLineNumber();
            }
            error = error + ".";
            this.hls.log(error);
            this.hls.shutdown(error);
        }
        catch (Exception e) {
            tempTable = null;
            String error = "Accounts file  has invalid format";
            if (lr != null) {
                error = error + " at line " + lr.getLineNumber();
            }
            error = error + ".";
            this.hls.log(error);
            this.hls.shutdown(error);
        }
        if (tempTable != null) {
            this.table.clear();
            this.table = tempTable;
        }
    }

    public void write() {
        this.write(this.accountsFile);
    }

    public void write(OutputStream out) {
        try {
            DebuggerOutput.debug("AccountsTable.write: writing");
            Enumeration en = this.table.elements();
            while (en.hasMoreElements()) {
                HLProtocol.AccountInfo account = (HLProtocol.AccountInfo)en.nextElement();
                String line = account.login + ":" + account.nick + ":" + account.privileges + ":" + account.password;
                if (account.homeDirectory != null) {
                    line = line + ":" + account.homeDirectory;
                }
                line = line + System.getProperty("line.separator");
                out.write(line.getBytes());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

