dnl AC_CHECK_JAVA_CLASS(CLASSNAME, ACTION-IF-FOUND, ACTION-IF-NOT-FOUND)
dnl Determines whether the given class can be imported and executes
dnl ACTION-IF-FOUND or ACTION-IF-NOT-FOUND correspondingly. The 
dnl macro's argument is available to the ACTIONs in the shell variable 
dnl `withval'.
AC_DEFUN(AC_CHECK_JAVA_CLASS,
[AC_REQUIRE([AC_JAVA])
AC_MSG_CHECKING(for $1)
temp_file=/tmp/ClassCheck$$
echo 'import $1;' > "$temp_file.java"
echo "public class ClassCheck$$ { }" >> "$temp_file.java"

dnl Send the output from javac to a temp file and use that temp file
dnl to determine whether compilation succeeded. This because of a bug
dnl with some combinations of the 1.3 javac / glibc (e.g. RedHat 7) which 
dnl causes javac to return 0 even if compilation fails.

"$JAVAC" "$temp_file.java" < /dev/null &> "$temp_file.output"

if test '!' -s "$temp_file.output"; then

  AC_MSG_RESULT(yes)
  rm -f "$temp_file.java" "$temp_file.class" "$temp_file.output"
  withval=$1
  $2

else

  cat "$temp_file.output" >&5
  AC_MSG_RESULT(no)
  rm -f "$temp_file.java" "$temp_file.class" "$temp_file.output"
  withval=$1
  $3

fi
])

dnl AC_JAVA
dnl Finds javac and java executables and tries to compile and run 
dnl test program. Failure to find the executables, or to compile
dnl the test program, or to run the test program, is fatal.
dnl Sets JAVA and JAVAC variables.
AC_DEFUN(AC_JAVA,
[AC_CHECK_PROG(JAVAC,javac,javac)
AC_CHECK_PROG(JAVA,java,java)
if test "x$JAVAC" = "x"; then

  AC_MSG_ERROR([could not find Java compiler javac.])

else

  if test "x$JAVA" = "x"; then

    AC_MSG_ERROR([could not find Java interpreter java.])

  else

    AC_MSG_CHECKING([to see if Java compiler works])

    temp_file=/tmp/GetJavaVersion$$
    cat > "$temp_file.java" <<EOF
public class GetJavaVersion$$ {
   public static void main(String args[[]]) {
      System.out.println(System.getProperty("java.version"));
   }
}
EOF

    "$JAVAC" "$temp_file.java" < /dev/null &> "$temp_file.output"

    if test '!' -s "$temp_file.output"; then

      AC_MSG_RESULT(yes)
      AC_MSG_CHECKING([for java.version property])

      oldpwd="`pwd`"
      cd /tmp
      JAVA_VERSION=`$JAVA GetJavaVersion$$ < /dev/null 2>&5`
      cd "$oldpwd"

      rm -f "$temp_file.java" "$temp_file.class" "$temp_file.output"

      if test "x$JAVA_VERSION" != "x"; then

        AC_MSG_RESULT([$JAVA_VERSION])

      else

        AC_MSG_ERROR([could not run test program; look in config.log for details.])

      fi

    else

      cat "$temp_file.output" >&5
      rm -f "$temp_file.java" "$temp_file.class" "$temp_file.output"
      AC_MSG_ERROR([could not compile test program; look in config.log for details.])
  
    fi

  fi

fi 

AC_SUBST(JAVA)
AC_SUBST(JAVAC)])

dnl AC_UPDATE_CONFIG(VAR, FILE)
dnl Strange utility function for caching configuration values.
AC_DEFUN(AC_UPDATE_CONFIG, [
if test -f "$2"; then
  old=`cat "$2"`
  if test "$old" != "$1"; then
    for i in */targets/"$1"/*.java; do
     dir=`dirname "$i"`
     dir=`dirname "$dir"`
     dir=`dirname "$dir"`
     class=`basename "$i" .java`.class
     rm -f "$dir/$class"
    done
  fi
fi
echo "$1" > "$2"])
