/**
 * $Id: ButtonPanel.java,v 1.1 2001/10/06 14:32:01 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.io.IOException;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import redlight.hotline.*;
import redlight.utils.DebuggerOutput;
import redlight.graphics.Spinner;

/**
 */
public class ButtonPanel extends JPanel {

    JPanel leftButtonPanel;
    JPanel rightButtonPanel;

    public ButtonPanel(JButton[] right) {

        this(right, null);

    }

    public ButtonPanel(JButton[] left, JButton[] right) {

        super();

        if(left != null)
            leftButtonPanel = new JPanel();
        if(right != null)
            rightButtonPanel = new JPanel();

        if(left != null)
            leftButtonPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
        if(right != null)
            rightButtonPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
        
        addButtonsToPanel(right, rightButtonPanel);
        addButtonsToPanel(left, leftButtonPanel);

	setLayout(new BorderLayout());

        if(left != null)
            add(leftButtonPanel, BorderLayout.WEST);
        if(right != null)
            add(rightButtonPanel, BorderLayout.EAST);

        //        registerKeyboardAction(this, "ActivateCancel", KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_IN_FOCUSED_WINDOW);

    }

    void addButtonsToPanel(JButton[] buttons, JPanel panel) {

        if(buttons != null) {

            for(int i = 0; i < buttons.length; i++)
                panel.add(buttons[i]);

        }

    }

}

