/**
 * $Id: ConnectInterface.java,v 1.4 2001/10/03 21:08:36 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.io.IOException;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.plaf.basic.BasicArrowButton;

import redlight.hotline.*;
import redlight.utils.DebuggerOutput;
import redlight.utils.FilenameUtils;

public class ConnectInterface implements ActionListener, 
                                             WindowListener {

    Parent parent;
    Machine rlm;
    Container contentPane;
    JTextField server, port, login, password;
    JButton connect, save;
    JFrame f;
    boolean destroy_on_close;
    String serverName;
    JPopupMenu popupMenu;
    BasicArrowButton arrowButton;

    public ConnectInterface(Parent p) {
	this(p, 
	     "", 
	     "5500", 
	     "guest", 
	     "", 
	     false);
    }
    
    public ConnectInterface(Parent prnt, 
				String the_server,
				String the_port, 
				String the_login, 
				String the_password, 
				boolean destroy) {

        this(prnt, the_server, the_port, the_login, the_password, null, destroy);

    }

    public ConnectInterface(Parent prnt, 
				String the_server,
				String the_port, 
				String the_login, 
				String the_password, 
                                String the_servername,
				boolean destroy) {
	parent = prnt;
	destroy_on_close = destroy;
        serverName = the_servername;

	Font guiFont = (Font) Main.rlo.getProperty("Font.gui");

	f = new JFrame("Connect to " + (serverName == null ? "..." : serverName));
	contentPane = f.getContentPane();

	JPanel p = new JPanel();
	JPanel buttons = new JPanel();
        popupMenu = new JPopupMenu();
	login = new JTextField(the_login);
	password = new JPasswordField(the_password);
	port = new JTextField(the_port);
	server = new JTextField(the_server);
	connect = new JButton("Connect");
	save = new JButton("Save ...");
        JTextArea helpText = new JTextArea("Enter the name of the server that you want to connect to, and optionally the port and user credentials:", 3, 20);
	JLabel l1 = new JLabel("Server:");
	JLabel l2 = new JLabel("Port:");
	JLabel l3 = new JLabel("Login:");
	JLabel l4 = new JLabel("Password:");
        arrowButton = new BasicArrowButton(SwingConstants.SOUTH);
	GridBagLayout gbl = new GridBagLayout();
	GridBagConstraints gbc = new GridBagConstraints();

	connect.addActionListener(this);
	save.addActionListener(this);
        arrowButton.addActionListener(this);

        Border lineBorder = 
            BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "New connection");
        Border emptyBorder = 
            new EmptyBorder((Insets) Main.rlo.getProperty("BorderInsets"));
        Border compound1 = 
            BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        p.setBorder(compound1);

	p.setLayout(new GridBagLayout());
	buttons.setLayout(new FlowLayout(FlowLayout.RIGHT));
	contentPane.setLayout(new GridBagLayout());
        helpText.setForeground(Color.black);
        helpText.setWrapStyleWord(true);
        helpText.setLineWrap(true);
        helpText.setOpaque(false);
        helpText.setEditable(false);
        arrowButton.setActionCommand("ShowBookmarks");
        arrowButton.setMnemonic('B');
        arrowButton.setToolTipText("Show bookmarks");
        save.setMnemonic('S');
        save.setToolTipText("Save bookmark as ...");
        connect.setMnemonic('C');
        connect.setToolTipText("Open a connection.");

        /* Intro text. */

        gbc.fill = gbc.HORIZONTAL;
        gbc.anchor = gbc.NORTHEAST;
        gbc.weightx = 0;
        gbc.weighty = 0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;        
        Insets oldInsets = gbc.insets;
        gbc.insets = new Insets(0, 0, 8, 0);
        p.add(helpText, gbc);
        gbc.insets = oldInsets;

        /* First column. */
        
        gbc.gridwidth = 1;
        gbc.gridy++;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        p.add(l1, gbc);
        gbc.gridy++;
        p.add(l2, gbc);
        gbc.gridy++;
        p.add(l3, gbc);
        gbc.gridy++;
        p.add(l4, gbc);

        /* Second column. */

        gbc.weightx = 0.8;
        gbc.gridx = 1;
        gbc.gridy = 1;
	p.add(server, gbc);
        gbc.gridy++;
	p.add(port, gbc);
        gbc.gridy++;
	p.add(login, gbc);
        gbc.gridy++;
        p.add(password, gbc);

        /* Third column (arrow button). */

        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0;
        p.add(arrowButton, gbc);

	buttons.add(save);
	buttons.add(connect);

        gbc.weightx = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weighty = 0;
        gbc.insets = (Insets) Main.rlo.getProperty("BorderInsets");

        contentPane.add(p, gbc);
        gbc.weighty = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = gbc.SOUTHWEST;
        gbc.insets = new Insets(0, 0, 0, 8);
        contentPane.add(buttons, gbc);

        p.registerKeyboardAction(this, "Cancel", KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_IN_FOCUSED_WINDOW);

        SwingUtilities.getRootPane(f).setDefaultButton(connect);

	f.pack();
		
	Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension w = f.getSize();
		
	f.setLocation((d.width / 2) - (w.width / 2), 
		      (d.height / 2) - (w.height / 2));
	f.addWindowListener(this);
	show(false);

    }

    public void doConnect() {

        f.setVisible(false);
        if(destroy_on_close) f.dispose();

        new ConnectionInterface(server.getText(), 
                                new Integer(port.getText()).intValue(),
                                login.getText(), 
                                password.getText(), 
                                serverName);
        

    }

    /**
     * Following methods implement ActionListener.
     */
    public void actionPerformed(ActionEvent e) {

	if(e.getActionCommand().equals("Connect")) {

            doConnect();

	} else if(e.getActionCommand().equals("Cancel")) {

            if(popupMenu.isVisible()) {

                popupMenu.setVisible(false);
                popupMenu.removeAll();

                /* Workaround: if we don't do this, the key for the
                   Cancel action (usually VK_ESC) somehow appears
                   in the server box as 'i'. */

                SwingUtilities.invokeLater(new Runnable() {

                        public void run() {

                            server.requestFocus();

                        }

                    });

            } else {

                windowClosing(null);

            }

        } else if(e.getActionCommand().equals("ShowBookmarks")) {

            if(!popupMenu.isVisible()) {

                popupMenu.removeAll();
                
                BookmarkInterface.populateContainerWithBookmarks(popupMenu, this);
                
                popupMenu.show(contentPane, arrowButton.getX() + arrowButton.getWidth(), arrowButton.getY() + arrowButton.getHeight());

                /* We have to make sure that the focus is not on a
                   text field, or else Escape (to cancel the
                   JPopupMenu) will show up in that text field as 'i'
                   (???, probably another bug). I would like to put
                   the focus on the JPopupMenu, but that's impossible
                   -- JPopupMenu's don't accept keyboard focus (bug
                   4212563). So, we put the focus on the arrow
                   button. It's useless that way, but hey. You have to
                   stop somewhere. */

                arrowButton.grabFocus();

            } else {

                popupMenu.setVisible(false);
                server.requestFocus();

            }

        } else if(e.getActionCommand().equals("ActivateBookmark")) {

            HLBookmarkFile bmf = ((BookmarkMenuItem) e.getSource()).getBookmarkFile();

            String address = bmf.get("address");
            int p = 5500;

            /* Get the port from the address if it is there. */
            
            if(address.indexOf(":") != -1) {
                
                p = new Integer(address.substring(address.indexOf(":") + 1)).intValue(); 
                address = address.substring(0, address.indexOf(":"));
                
            }

            server.setText(address);
            port.setText(new Integer(p).toString());
            login.setText(bmf.get("login"));
            password.setText(bmf.get("password"));

            server.requestFocus();

        } else if(e.getActionCommand().equals("Save ...")) {

            File bmPath = ((File) Main.rlo.getProperty("Path.Bookmarks"));

            if(!bmPath.exists()) {

                bmPath.mkdirs();
                
                if(!bmPath.exists()) {

                    new Error("Could not create bookmark path! Set bookmark path in Options->Paths...");
                    return;

                }

            }

	    FileDialog fd = new FileDialog(f, "Save Bookmark", FileDialog.SAVE);
	    fd.setDirectory(bmPath.toString());

            if(serverName != null)
                fd.setFile(serverName);
            else
                fd.setFile(FilenameUtils.qualify(server.getText() + ":" + port.getText()));
            
	    fd.show();
	    String save_file = fd.getFile();

	    if(save_file != null) {

                serverName = save_file;

                SwingUtilities.invokeLater(new Runnable() {

                        public void run() {

                            f.setTitle("Connect to " + serverName);

                        }

                    });

		try {

		    HLBookmarkFile bmf = 
			new HLBookmarkFile(new File(((File) Main.rlo.getProperty("Path.Bookmarks")), save_file));
		    String address = server.getText();

		    if(!port.getText().equals(""))
                        address += (":" + port.getText());

		    bmf.put("address", address);
		    bmf.put("login", login.getText());
		    bmf.put("password", password.getText());
		    bmf.store();
		    parent.displayPropertyChanged("bookmarkentries", "");

		} catch (IOException ex) {

                    new Error("Cannot save bookmark " + save_file + ": " + ex.getMessage());

		}

	    }

	}

    }
	
    /**
     * Following methods implement WindowListener.
     */
    public void windowActivated(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) { }
    public void windowClosing(WindowEvent e) {

	f.setVisible(false);
	if(destroy_on_close) 
            f.dispose();

    }
    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
	
    public void show(boolean initServerName) {

        if(initServerName)
            serverName = null;

        SwingUtilities.invokeLater(new Runnable() {

                public void run() {

                    f.show();
                    f.setTitle("Connect to " + (serverName == null ? "..." : serverName));
        
                    SwingUtilities.invokeLater(new Runnable() {
                            
                            public void run() {
                                
                                server.requestFocus();
                                
                            }
                            
                        });

                }

            });

    }

}
