/**
 * $Id: DepthFirstFileSearch.java,v 1.1 2001/09/14 01:54:22 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import java.io.IOException;

import redlight.hotline.*;
import redlight.utils.DebuggerOutput;
import redlight.utils.BytesFormat;
import redlight.utils.TextUtils;

/**
 * A depth first file search.
 */
public class DepthFirstFileSearch {
    static int MAX_DEPTH = 16;
    boolean interrupted = false;

    public void interrupt() {

        interrupted = true;

    }

    /**
     * Recursively descend paths and log their contents.
     */
    public int descend(HLClient hlc, String path, int depth, int scannedSoFar, FileSearchAction action) throws InterruptedException, IOException, HLException {

        /* Never scan more than 20000 files regardless. */

        if(scannedSoFar > 20000)
            return 0;

	int filesScanned = 0;

	HLProtocol.FileListComponent[] files = hlc.getFileList(path);

	for(int i = 0; i < files.length; i++) {

	    if(interrupted) 
                throw new InterruptedException();

            action.fileFound(path, files[i]);

	}

	for(int i = 0; i < files.length; i++) {

	    if(interrupted) 
                throw new InterruptedException();

	    if(hlc.isConnected() == false) 
                return 0;

	    filesScanned++;

	    if(files[i].fileType.equals("fldr") && 
	       files[i].fileSize != 0 && depth < MAX_DEPTH) {

		try {

                    /* Sleep for a while or the server might ban
                       us. */

                    Thread.currentThread().sleep(20);

		} catch (InterruptedException ex) {}

		filesScanned += descend(hlc, path + files[i].fileName + ":", depth + 1, filesScanned + scannedSoFar, action);

	    }

	}

	return filesScanned;

    }

}





