/**
 * $Id: Error.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import redlight.utils.TextUtils;

public class Error {

    JOptionPane warningDialog;
    Thread showPane;
    String message;
    String info;
    static int WRAP_AT_COLS = 40;
    static char[] qChar = { 0xd2 };
    static char[] uqChar = { 0xd3 };
    String quoteChar = new String(qChar);
    String unquoteChar = new String(uqChar);

    public Error(String err) {

	message = TextUtils.findAndReplace(err, quoteChar, "`");
	message = TextUtils.findAndReplace(message, unquoteChar, "'");

	if(Main.rlo != null)
	    Main.rlo.playAudioClip("error");

        SwingUtilities.invokeLater(new Runnable() {

                public void run() {

                    Object[] options = { "OK" };

                    JOptionPane.showOptionDialog(null, 
                                                 TextUtils.wordWrap(message, 
                                                                    WRAP_AT_COLS), 
                                                 "Error", 
                                                 JOptionPane.DEFAULT_OPTION, 
                                                 JOptionPane.WARNING_MESSAGE,
                                                 null, options, options[0]);
                }

            });

    }

}
