/**
 * $Id: Main.java,v 1.10 2001/10/06 14:31:30 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import java.io.*;
import java.util.*;
import java.util.zip.*;
import java.awt.Point;
import java.awt.Dimension;

import javax.swing.JOptionPane;

import redlight.Version;
import redlight.utils.DebuggerOutput;
import redlight.utils.SystemEvents;
import redlight.utils.SystemEventHandler;
import redlight.utils.TextUtils;
import redlight.hotline.HLBookmarkFile;
import redlight.hotline.HLIconFile;

import redlight.hotline.iconlib.*;

/**
 * Main entry point for the Red Light client.
 */
public class Main {
    static Vector shells, machines;
    static String[] hosts = null;
    static File CONFIGURATION_DIRECTORY = 
	new File(System.getProperty("user.home"), ".redlight");
    static File CONFIGURATION_FILE = 
	new File(CONFIGURATION_DIRECTORY, "rl.conf");
    static File ICON_FILE = 
	new File(CONFIGURATION_DIRECTORY, "hotline.dat");
    static String lSep = System.getProperty("line.separator");
    static String VERSION = "rl version " + redlight.Version.VERSION + " " +
        redlight.Version.RELEASE_TYPE + ", " + 
        redlight.Version.BUILD_DATE + lSep +
        "Options: " + redlight.Version.OPTIONS + lSep;
    static String LEGALESE = 
        "rl (C) 1998 - 2001 Pascal Haakmat <groomed@users.sourceforge.net>" + lSep + 
        "rl is free software, covered by the GNU General Public License." + lSep + 
        "Modification and redistribution are encouraged. No warranty.";
    static Shell activeShell = null;
    static public int activeTransfers = 0;
    static SystemEvents systemEvents = new SystemEvents();
    static Options rlo = null;
    static TrackerInterface tubeTracker = null;
    static BookmarkInterface tubeBookmarks = null;
    static OptionsInterface rloInterface = null;
    static ManualInterface tubeManualInterface = null;
    static AboutInterface tubeAboutInterface = null;
    static SharingInterface sharingInterface = null;
    static Dimension activeShellDimension;
    static Point activeShellLocation;
    static boolean quitting = false;
    static Vector startupConnections;
    static HLIconFile iconFile = null;

    /**
     * Main entry point.
     */
    public static void main(String args[]) {

	systemEvents.registerSystemEventHandler(new SystemEventHandler() {

                public void handleQuit() {

                    boolean doQuit = false;
                    
                    if(activeTransfers > 0) {
            
                        int r = JOptionPane.showConfirmDialog(null, TextUtils.wordWrap("There are file transfers in progress, which will be interrupted when you quit now (although they may be resumed later). Are you sure you wish to quit?", 40), "Quit?", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
                        
                        if(r == JOptionPane.YES_OPTION) 
                            doQuit = true;
                        
                    } else {
                        
                        doQuit = true;
            
                    }

                    if(!doQuit)
                        return;

                    /* Need to close all open shells here ... */
                    
                    if(tubeTracker != null) 
                        tubeTracker.close();
                    
                    if(tubeBookmarks != null) 
                        tubeBookmarks.close();
                    
                    Main.rlo.setProperty("WindowLocation.Main", activeShellLocation);
                    Main.rlo.setProperty("WindowDimension.Main", activeShellDimension);
                    try {
                        
                        Main.rlo.store(Main.CONFIGURATION_FILE);
                        
                    } catch (IOException ex) {
                        
                        DebuggerOutput.debug("Exception writing Options: " + ex);
                        
                    }
                    
                    System.exit(0);

                }
                
                public void handleOpenDocument(File f) {
                    
                }
                
                public void handlePrintDocument(File f) {
                    
                }
                
                public void handleAbout() {
                    
                }
                
            } );
        
        shells = new Vector();
        machines = new Vector();
        startupConnections = new Vector();

        parseArgs(args);

        /* Try to create directory for private storage. */

	if(!CONFIGURATION_DIRECTORY.exists()) {

	    if(!CONFIGURATION_DIRECTORY.mkdir()) {

		DebuggerOutput.debug("Could not create "+
				   CONFIGURATION_DIRECTORY.toString() +
				   ", exiting ...");
                System.exit(1);

            }

	}

        rlo = new Options();

        /* Try to unserialize options. */

	if(Main.CONFIGURATION_FILE.exists())
            rlo.load(Main.CONFIGURATION_FILE);

        /* Try to find icon file. */

        if(rlo.getBooleanProperty("Toggle.ShowIcons") && 
           Main.ICON_FILE.exists()) {

            try {

                iconFile = new HLIconFile(Main.ICON_FILE);

            } catch(IOException e) {

                iconFile = null;

            }

        }

	/* Load graphics and sound. */

	rlo.registerAudioClips(new String[] { "snd/login.au", 
						 "snd/userjoin.au", 
						 "snd/userleave.au", 
						 "snd/receivemsg.au", 
						 "snd/receivechat.au", 
						 "snd/error.au", 
						 "snd/filedone.au", 
						 "snd/receivenewspost.au" });
	rlo.registerImageSet("Spinner", new String[] { "img/801.gif", 
							  "img/802.gif", 
							  "img/803.gif", 
							  "img/804.gif", 
							  "img/805.gif",
							  "img/806.gif", 
							  "img/807.gif", 
							  "img/808.gif" });
        rlo.registerImageSet("FunctionIcons", new String[] { "img/chat.gif",
                                                            "img/news.gif",
                                                            "img/file.gif",
                                                            "img/message.gif",
                                                            "img/stop.gif",
                                                            "img/forbid.gif",
                                                            "img/user.gif",
                                                            "img/ul.gif",
                                                            "img/dl.gif",
                                                            "img/refresh.gif",
                                                            "img/trash.gif",
                                                            "img/folder.gif",
                                                            "img/find.gif",
                                                            "img/info.gif",
                                                            "img/spacer.gif",
                                                            "img/newuser.gif",
                                                            "img/openuser.gif" });

	new Shell();

        if(rlo.getProperty("Home") != null) 
            startupConnections.addElement(rlo.getProperty("Home"));

        for(Enumeration en = startupConnections.elements(); en.hasMoreElements(); ) {

            Connection c = (Connection) en.nextElement();
            new ConnectionInterface(c.address, 
                                    c.port, 
                                    c.login, 
                                    c.password, 
                                    c.name);

        }
        
        startupConnections.removeAllElements();

    }

    static synchronized Shell getActiveShell() {

        return activeShell;

    }

    static synchronized void setActiveShell(Shell shell) {

        activeShell = shell;

        activeShellLocation = activeShell.f.getLocationOnScreen();
        activeShellDimension = activeShell.f.getSize();

    }

    static void addShell(Shell shell) {
        
        synchronized(shells) {

            shells.addElement(shell);

        }

    }

    static void removeShell(Shell shell) {

        synchronized(shells) {
            
            shells.removeElement(shell);
            
            if(activeShell == shell) {

                if(shells.size() > 0) 
                    activeShell = (Shell) shells.elementAt(shells.size() - 1);
                else
                    systemEvents.handleQuit();
            }

        }

    }

    static void addMachine(Machine m) {

	machines.addElement(m);

    }

    static void removeMachine(Machine m) {

	machines.removeElement(m);

    }

    static Enumeration getMachines() {

	return machines.elements();

    }

    /**
     * Parse commandline arguments. 
     */
    static void parseArgs(String argv[]) {

	for(int i = 0; i < argv.length; i++) {

            if(argv[i].equals("-v") || argv[i].equals("--version")) {

                printVersion();
                System.exit(0);

            } else if(argv[i].equals("-h") || argv[i].equals("--help")) {

                printUsage();
                System.exit(0);

            } else if(argv[i].equals("-d") || argv[i].equals("--debug")) {
                
                DebuggerOutput.setEnabled(true);

            } else {

                Connection c = new Connection();

                File f = new File(argv[i]);

                if(!f.isAbsolute()) 
                    f = new File(System.getProperty("user.dir"), f.toString());

                if(f.exists()) {

                    HLBookmarkFile bmf = new HLBookmarkFile(f);

                    try {

                        bmf.load();
                        c.address = bmf.get("address");
                        c.login = bmf.get("login");
                        c.password = bmf.get("password");
                        c.name = f.getName();

                    } catch(IOException e) {

                        DebuggerOutput.debug(f + ": not a bookmark file.");
                        printUsage();

                    }

                } else {

                    /* Assume hostname[:port]. */

                    c.address = argv[i];
                    c.login = "guest";
                    c.password = "";
                    c.name = argv[i];

                }
                    
                if(c.address.indexOf(":") != -1) {
                    
                    c.port = new Integer(c.address.substring(c.address.lastIndexOf(":") + 1)).intValue(); 
                    c.address = c.address.substring(0, c.address.lastIndexOf(":"));
                }

                startupConnections.addElement(c);

            }

        }

    }

    /**
     * Print usage. 
     */
    static void printUsage() {

	String s = 
	    LEGALESE + lSep + lSep + 
	    "Usage: rl [options] [FILE|HOST[:PORT]]..." + lSep + lSep +
	    "Options:" + lSep + lSep +
	    " -v, --version      display version information and exit" + lSep +
	    " -h, --help         show this message and exit" + lSep +
            " -d, --debug        output lots of debugging information" + lSep + lSep +
            "FILE can be a relative or absolute path to a bookmark file." + lSep +
            "If FILE does not exist, then the argument is interpreted as" + lSep +
            "a hostname with an optional port specification." + lSep;
	printVersion();
	System.out.print(s);

    }
    
    /**
     * Print version.
     */
    static void printVersion() {

	System.out.print(VERSION + lSep);
	
    }

}

class Connection implements Serializable {

    public String address;
    public int port = 5500;
    public String login;
    public String password;
    public String name;

    Connection() {}

    Connection(String address, 
               int port, 
               String login, 
               String password,
               String name) {

        this.address = address;
        this.port = port;
        this.login = login;
        this.password = password;
        this.name = name;

    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {

	in.defaultReadObject();

    }

    private void writeObject(ObjectOutputStream out) throws IOException {

	out.defaultWriteObject();

    }

}
