/**
 * $Id: MessageTransmit.java,v 1.7 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.io.IOException;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import redlight.hotline.*;
import redlight.utils.TextUtils;

/**
 * Small subclass for the send message interface. You could make this
 * to let this subclass listen for user leave events and disable the
 * 'send' button as appropriate.  
 */
public class MessageTransmit extends MessageInterface {
    
    public MessageTransmit(Machine machine,
                           User user) {

	super(machine, user, false);
	f.setVisible(true);

        SwingUtilities.invokeLater(new Runnable() {

                public void run() {

                    message.requestFocus();

                }

            });

    }

    public MessageTransmit(Machine machine,
                           User user,
                           String replyMessage) {

        super(machine, user, false);        
        message.setText("\n\n" + replyMessage);
        f.setVisible(true);

        SwingUtilities.invokeLater(new Runnable() {

                public void run() {

                    message.setCaretPosition(message.getText().length());
                    message.moveCaretPosition(0);
                    message.requestFocus();

                }

            });
    }
    
    /*
     * Following method implements ActionListener.
     */
    public void actionPerformed(ActionEvent e) {
        
	try {

	    if(e.getActionCommand().equals("Send"))
		rlm.getHLC().requestMessageSend(user.sock, message.getText().replace('\n', '\r'));
            
	} catch(IOException ex) {}
        
        closeWindow();

    }

}

