/**
 * $Id: PrivChatInterface.java,v 1.7 2001/10/04 01:03:59 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;
import java.io.IOException;
import java.io.File;
import javax.swing.*;
import javax.swing.border.*;

import redlight.hotline.*;
import redlight.utils.TextUtils;
import redlight.utils.DebuggerOutput;
import redlight.script.*;

class UserMenuItem extends JMenuItem {
    User user;
    public UserMenuItem(User u) {
	super(u.nick);
	user = u;
    }

    public User getUser() {
	return user;
    }
}

class OptionCheckBox extends JCheckBox {
    String d;
    public OptionCheckBox(String s, boolean b) {
	super(s, b);
	d = s;
    }
    public String toString() {
	return d;
    }
}

class OptionCellRenderer extends JCheckBox implements ListCellRenderer {
    JLabel textLabel;
    public OptionCellRenderer() {
	setOpaque(true);
	textLabel = new JLabel();
    }
    public Component getListCellRendererComponent(
						  JList list,
						  Object value,
						  int index,
						  boolean isSelected,
						  boolean cellHasFocus)
    {
	if(value instanceof JCheckBox)
	    setSelected(((JCheckBox) value).isSelected());
	else {
	    textLabel.setText(value.toString());
	    return textLabel;
	}
	setText(value.toString());
	setBackground(isSelected ? 
		      list.getSelectionBackground() : 
		      list.getBackground());
	setForeground(isSelected ? 
		      list.getSelectionForeground() : 
		      list.getForeground());
	return this;
    }
}
 
public class PrivChatInterface extends ChatWindow
    implements ActionListener, 
	       MouseListener, 
	       WindowListener, 
	       Scriptable,
	       Child {

    Machine rlm;
    Container contentPane;
    JComboBox options;
    JTextField input;
    JList list;
    JPopupMenu invitePopup;
    JMenuItem[] inviteMenuItems;
    JSplitPane topPart;
    JFrame f;
    OptionCheckBox joinLeaveOption, logOption;
    DefaultListModel listModel;
    String nick;
    Hashtable users, indices;
    Font guiFont;
    static int x = 0, y = 0;
    static Integer lock = new Integer(0);
    int sock = 0, pcref = 0, color = 0, icon = 0;
    int joinID;

    public PrivChatInterface(Machine machine, 
				 int ref, 
				 int s, 
				 String n, 
				 int i, 
				 int c) {
	this(machine, ref, s, n, -1);
    }
	
    public PrivChatInterface(Machine machine, 
				 int ref, 
				 int s, 
				 String n, 
				 int jid) {
	rlm = machine;
	pcref = ref;
	sock = s;
	nick = n;
	joinID = jid;
	users = new Hashtable();
	indices = new Hashtable();

	guiFont = (Font) Main.rlo.getProperty("Font.gui");

	f = new JFrame("Private chat (" + rlm.getServerName() + ")");
	contentPane = f.getContentPane();
	invitePopup = new JPopupMenu();
	GridBagConstraints gbc = new GridBagConstraints();
	GridBagConstraints gbc2 = new GridBagConstraints();
	JMenuItem x = new JMenuItem("Invite:");
	chat = new JTextArea("", 10, 45);
	input = new JTextField();
        DebuggerOutput.debug("PrivChatInterface: getting user list model");
	listModel = rlm.getUserListModel(new Integer(pcref));
        DebuggerOutput.debug("PrivChatInterface: got user list model " + listModel);

	list = new JList(listModel);
        DebuggerOutput.debug("PrivChatInterface: created new list");

	joinLeaveOption = new OptionCheckBox("Show join/leave", Main.rlo.getBooleanProperty("Toggle.JoinLeave"));

	logOption = new OptionCheckBox("Log", Main.rlo.getBooleanProperty("Toggle.Log"));

        options = new JComboBox(new Object[] { "Options...", 
					       joinLeaveOption, 
					       logOption } );
	JPanel optionPane = new JPanel();
	JPanel bottomPart = new JPanel();
	topPart = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, 
                                 Main.rlo.getBooleanProperty("Toggle.LiveResizing"),
                                 new JScrollPane(chat),
                                 new JScrollPane(list));

        Border emptyBorder = 
            new EmptyBorder((Insets) Main.rlo.getProperty("BorderInsets"));

        Border lineBorder = 
            BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Private chat");        
        Border chatBorder = 
            BorderFactory.createCompoundBorder(lineBorder, emptyBorder);

        JPanel borderPanel = new JPanel();

	bottomPart.setLayout(new GridBagLayout());
	optionPane.setLayout(new GridBagLayout());
        borderPanel.setLayout(new BorderLayout());
	joinLeaveOption.setFont(guiFont);
	logOption.setFont(guiFont);
	options.setFont(guiFont);
	x.setEnabled(false);
	x.setFont(guiFont);
	chat.setLineWrap(true);
	chat.setWrapStyleWord(true);
	chat.setFont((Font) Main.rlo.getProperty("Font.text"));
	chat.setEditable(false);
	input.setFont((Font) Main.rlo.getProperty("Font.text"));
	input.requestFocus();
	list.setToolTipText("Invite users by right-clicking (or control-clicking)");
	list.setCellRenderer(new UserCellRenderer((Font) Main.rlo.getProperty("Font.list")));
	list.setFont((Font) Main.rlo.getProperty("Font.list"));
	options.setSelectedIndex(0);
	options.setMaximumRowCount(5);
	options.setRenderer(new OptionCellRenderer());

	input.addActionListener(this);
	list.addMouseListener(this);
	options.addActionListener(this);
	f.addWindowListener(this);
	joinLeaveOption.addActionListener(this);
	logOption.addActionListener(this);

	invitePopup.add(x);
	borderPanel.add(topPart, BorderLayout.CENTER);
	gbc2.anchor = GridBagConstraints.EAST;
	gbc2.insets = 
	    (Insets) Main.rlo.getProperty("BorderInsets");
	optionPane.add(options, gbc2);
	gbc.gridx = 0; gbc.gridy = 0;
	gbc.weightx = 1; gbc.weighty = 0;
	gbc.insets = new Insets(0, 0, 0, 0);
	gbc.fill = GridBagConstraints.BOTH;
	gbc.ipady = 2; gbc.ipadx = 2;
	bottomPart.add(input, gbc);
	gbc.gridx = 1; gbc.gridy = 0;
	gbc.weightx = 0; gbc.weighty = 0;
	bottomPart.add(optionPane, gbc);	
	borderPanel.add(bottomPart, BorderLayout.SOUTH);

        borderPanel.setBorder(BorderFactory.createCompoundBorder(emptyBorder, chatBorder));

        contentPane.add(borderPanel);

	setElementColors();

	f.pack();
		
        topPart.setDividerLocation(input.getWidth());

	Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension w = f.getSize();
		
        f.setLocation((d.width / 2) - (w.width / 2), 
                      (d.height / 2) - (w.height / 2));

	f.setVisible(true);
        
        DebuggerOutput.debug("PrivChatInterface: registering as child ...");
	rlm.getInterface().registerChild(this);
        DebuggerOutput.debug("PrivChatInterface: registered as child");
	rlm.getHLC().addHLClientListener(this);
        DebuggerOutput.debug("PrivChatInterface: registered as event listener");
	rlm.registerChat(new Integer(pcref), this);
        DebuggerOutput.debug("PrivChatInterface: registered as chat");
	rlm.getScriptBroker().addTarget(this);
        DebuggerOutput.debug("PrivChatInterface: registered as script target");

        DebuggerOutput.debug("PrivChatInterface: created");

    }

    void setElementColors() {

	input.setBackground(rlm.getSchemeColor("background"));
	input.setForeground(rlm.getSchemeColor("foreground"));
	chat.setBackground(rlm.getSchemeColor("background"));
	chat.setForeground(rlm.getSchemeColor("foreground"));
	list.setBackground(rlm.getSchemeColor("background"));
	list.setForeground(rlm.getSchemeColor("foreground"));

    }

    ScriptResult processStateChange(StateObject state) {

	Integer domain = new Integer(pcref);

	if(state.domain.equals(domain)) {

	    switch(state.what) {
	    case StateObject.LOG:
		logOption.setSelected(rlm.isLogEnabled(domain));
		break;

	    case StateObject.SHOW_JOIN_LEAVE:
		joinLeaveOption.setSelected(rlm.isShowJoinLeaveEnabled(domain));

	    }

	    
	}

	return new ScriptResult(this, null);
    }

    /**
     * Following methods extend HLClientAdapter.
     */
    public void handlePrivateChatJoin(int id, 
				      HLProtocol.UserListComponent[] uh) {

	if(id == joinID) 
	    rlm.addUsersToDomain(new Integer(pcref), uh);

    }
    
    public void handlePrivateChatSubject(int ref, String subject) {

	if(ref == pcref) 
	    f.setTitle("Private chat [" + subject  + "] (" + 
		       rlm.getServerName() + ")");

    }

    public void handleTaskError(int id, String s) {

	if(id == joinID) {

	    rlm.getInterface().unregisterChild(this);
	    close();

	}
    }

    /**
     * Following method implements ActionListener.
     */
    public void actionPerformed(ActionEvent e) {

	if(e.getSource() == options) {
	    
	    if(options.getSelectedIndex() > 0) {

		JCheckBox box = (JCheckBox) options.getSelectedItem();
		box.setSelected(!box.isSelected()); 
		options.setSelectedIndex(0);

		if(box.getText().equals("Log")) {

		    rlm.setState(new Integer(pcref),
					 StateObject.LOG,
					 new Boolean(logOption.isSelected()));

		} else if(box.getText().equals("Show join/leave")) {

		    rlm.setState(new Integer(pcref),
					 StateObject.SHOW_JOIN_LEAVE,
					 new Boolean(joinLeaveOption.
						     isSelected()));

		}

	    }
	    
	} else if(e.getSource() == input) {

	    if(!input.getText().trim().equals("")) {

		try {

		    if(((e.getModifiers() & ActionEvent.SHIFT_MASK) == 
			ActionEvent.SHIFT_MASK) || 
                       (input.getText().length() > 4 && 
                        input.getText().substring(0,4).equals("/me ")))
			rlm.getHLC().sendPrivateChatAction(pcref, input.getText().substring(4));

		    else
			rlm.getHLC().sendPrivateChat(pcref, input.getText());

		    input.setText("");

		} catch (IOException ex) {

                    DebuggerOutput.stackTrace(ex);

		}

	    }

	} else if(e.getSource() instanceof JMenuItem) {

	    try {

		rlm.getHLC().requestPrivateChatInvite(pcref, ((UserMenuItem) e.getSource()).getUser().sock);

	    } catch(IOException ex) {}

	}

    }

    /**
     * Following methods implement WindowListener.
     */
    public void windowActivated(WindowEvent e) { 

	chat.requestFocus();
	input.requestFocus();

    }

    public void windowDeactivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {

	rlm.getInterface().unregisterChild(this);
	close();

    }

    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
	
    /**
     * Following methods implement MouseListener.
     */
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {

        mouseReleased(e);

    }

    public void mouseReleased(MouseEvent e) {

	if(e.isPopupTrigger()) {

	    if(inviteMenuItems != null) {
		for(int i=0; i<inviteMenuItems.length; i++) {
		    inviteMenuItems[i].removeActionListener(this);
		    invitePopup.remove(inviteMenuItems[i]);
		}
	    }
	    User[] u = rlm.getUsers();
	    inviteMenuItems = new JMenuItem[u.length];

	    for(int i=0; i<u.length; i++) {
		inviteMenuItems[i] = new UserMenuItem(u[i]);
		inviteMenuItems[i].setFont(guiFont);
		inviteMenuItems[i].addActionListener(this);
		invitePopup.add(inviteMenuItems[i]);
	    }

	    invitePopup.show(list, e.getX(), e.getY());

	}

    }

    public void mouseClicked(MouseEvent e) {

	if(e.getClickCount() == 2) {

	    User user = (User) list.getSelectedValue();

            if(user != null) 
                new MessageTransmit(rlm, user);
	    
	}


    }

    /**
     * Following methods implement Child.
     */
    public void close() {

	if(rlm.getHLC() != null) {

	    rlm.getHLC().removeHLClientListener(this);

	    try {

		rlm.getHLC().sendPrivateChatLeave(pcref);

	    } catch(IOException _e) {}

	}

	rlm.getScriptBroker().removeTarget(this);
	rlm.unregisterChat(new Integer(pcref), this);
	rlm.destroyDomain(new Integer(pcref));
	f.setVisible(false);
	f.dispose();

    }
	
    public void displayPropertyChanged(String what, Object property) {

	if(what.equals("textfont")) {

	    chat.setEnabled(false);
	    chat.setFont((Font) property);
	    input.setFont((Font) property);
	    chat.setText(chat.getText());
	    chat.repaint();
	    input.repaint();
	    chat.setEnabled(true);

	} else if(what.equals("listfont")) {

	    list.setFont((Font) property);
	    list.repaint();

	}
	
	setElementColors();
	topPart.setContinuousLayout(Main.rlo.getBooleanProperty("Toggle.LiveResizing"));

    }

    /**
     * Following methods implement Scriptable.
     */
    public void gotTarget(ScriptBroker sb) {}

    public void lostTarget(ScriptBroker sb) {}

    public long getKnownMessages() {

	return Scripting.STATE_CHANGED;

    }

    public ScriptResult executeScript(ScriptObject s) 
	throws UnknownMessageException {

	int value = (int) s.getType();

	switch(value) {

	case Scripting.STATE_CHANGED:
	    StateObject state = (StateObject) s.getUserObject();
	    return processStateChange(state);	    

	}

	throw new UnknownMessageException();
    }
}
