/**
 * $Id: TransferListInterface.java,v 1.3 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.*;
import java.awt.event.*;

import java.util.Hashtable;
import java.util.Vector;

import javax.swing.*;
import javax.swing.event.*;

import redlight.hotline.*;
import redlight.utils.DebuggerOutput;
import redlight.script.*;

class TransferCellRenderer extends JPanel implements ListCellRenderer { 
   
    public Component getListCellRendererComponent(JList list,
						  Object value,
						  int index,
						  boolean isSelected,
						  boolean cellHasFocus) {
	((Container) value).setBackground(isSelected ? 
					  list.getSelectionBackground() :
		      list.getBackground());
	((Container) value).setForeground(isSelected ? 
					  list.getSelectionForeground() :
		      list.getForeground());
	return (Container) value;
    }
}

/**
 * The transfer list interface.
 */
public class TransferListInterface 
    implements Scriptable, 
	       ActionListener, 
	       WindowListener, 
	       ListSelectionListener { 
    Machine rlm;
    Container contentPane;
    JFrame f;
    JList list;
    JButton stop;
    static int x = 0, y = 0;
    static Integer lock = new Integer(0);
    Vector transfers;
    DefaultListModel listModel;
    Hashtable targets;
    boolean swallow;

    public TransferListInterface(Machine machine, boolean sw) {
	rlm = machine;
        swallow = sw;

	Font guiFont = (Font) Main.rlo.getProperty("Font.gui");

	rlm.getScriptBroker().addTarget(this);

	if(swallow == false) {

            f = new JFrame("Transfers (" + rlm.getServerName() + ")");

	    contentPane = f.getContentPane();

	} else {

	    try {
                
		ScriptResult[] sr = rlm.getScriptBroker().
		    executeScript(new ScriptObject(Scripting.
						   SWALLOW_REQUEST, 
						   this));
                contentPane = (Container) sr[0].getUserObject();
                
	    } catch (UnknownMessageException e) {
                
		e.printStackTrace();

	    }

	}

	listModel = new DefaultListModel();
	list = new JList(listModel);
	stop = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.DISCONNECT_ICON]));
	GridBagLayout gbl = new GridBagLayout();
	GridBagConstraints gbc = new GridBagConstraints();
        JToolBar toolbar = new JToolBar();

	contentPane.setLayout(gbl);
	list.setCellRenderer(new TransferCellRenderer());
	list.setFont((Font) Main.rlo.getProperty("Font.list"));
	list.setBackground(rlm.getSchemeColor("background"));
	list.setForeground(rlm.getSchemeColor("foreground"));
        toolbar.setFloatable(false);
        stop.setToolTipText("Stop the selected transfer");
        stop.setActionCommand("Stop");
	stop.setEnabled(false);
	stop.setFont(guiFont);

	list.addListSelectionListener(this);
	stop.addActionListener(this);
        
	gbc.gridwidth = gbc.RELATIVE;
	gbc.fill = GridBagConstraints.BOTH;
        toolbar.add(stop, gbc);
	contentPane.add(toolbar, gbc);
	gbc.weightx = 1;
        gbc.insets =
            (Insets) Main.rlo.getProperty("BorderInsets");
	gbc.fill = GridBagConstraints.NONE;
	gbc.anchor = GridBagConstraints.WEST;
       	gbc.gridx = 0; 
        gbc.gridy = 1;
	gbc.weightx = 1; 
        gbc.weighty = 1;
	gbc.fill = GridBagConstraints.BOTH;
	contentPane.add(new JScrollPane(list), gbc);

        if(!swallow) {

            f.pack();
            f.setSize(300, 300);
            f.addWindowListener(this);

        }

    }

    public void show() {

        if(!swallow) 
            f.show();

        if(list.getSelectionModel().isSelectionEmpty())
            if(list.getFirstVisibleIndex() != -1)
                list.getSelectionModel().setSelectionInterval(list.getFirstVisibleIndex(), list.getFirstVisibleIndex());

        list.requestFocus();

    }

    void unswallow(Container c) {
	listModel.removeElement(c);
	if(list.getSelectedIndex() == -1) 
	    stop.setEnabled(false);
	else
	    stop.setEnabled(true);
    }

    Container getNewTransferContainer() {
	if(!swallow)
            f.show();
	TransferCellRenderer tr = new TransferCellRenderer();
	listModel.addElement(tr);
	return tr;
    }
    
    /**
     * Following method implements ActionListener.
     */
    public void actionPerformed(ActionEvent e) {
	if(e.getActionCommand().equals("Stop")) {
	    try {
		rlm.getScriptBroker().
		    executeScript(new ScriptObject(Scripting.CLOSE_WINDOW, list.getSelectedValue()));
	    } catch (UnknownMessageException ex) {
	    }
	}
    }
    
    /**
     * Following method implements WindowListener.
     */
    public void windowActivated(WindowEvent e) {
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) { }
    public void windowClosing(WindowEvent e) {
	e.getWindow().setVisible(false);
    }
    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}

    /**
     * Following method implements ListSelectionListener.
     */
    public void valueChanged(ListSelectionEvent e) {
	if(!e.getValueIsAdjusting()) {
	    if(e.getFirstIndex() != -1) 
		stop.setEnabled(true);
	    else
		stop.setEnabled(false);
	}
    }

    /**
     * Following methods implement Child.
     */
    public void close() {

        if(swallow == false) {
            
            f.setVisible(false);
            f.removeWindowListener(this);
            f.dispose();
            f = null;

        } else {
            
            try {
                
                rlm.getScriptBroker().
                    executeScript(new ScriptObject(Scripting.
                                                   UNSWALLOW_REQUEST, 
                                                   contentPane));

            } catch (UnknownMessageException e) {

                e.printStackTrace();

            }

        }

	rlm.getScriptBroker().removeTarget(this);

    }

    public void displayPropertyChanged(String what, Object property) {
	if(what.equals("listfont")) { 
	    synchronized(list) {
		list.setFont((Font) property);
		list.repaint();
	    }
	}
	else {
	    list.setBackground(rlm.getSchemeColor("background"));
	    list.setForeground(rlm.getSchemeColor("foreground"));	    
	}
	list.repaint();
    }

    /**
     * Following methods implement Scriptable.
     */
    public void gotTarget(ScriptBroker sb) {
    }
    public void lostTarget(ScriptBroker sb) {
    }
    public long getKnownMessages() {
	return Scripting.SWALLOW_REQUEST |
	    Scripting.UNSWALLOW_REQUEST |
	    Scripting.REPAINT;
    }
    public ScriptResult executeScript(ScriptObject s) 
	throws UnknownMessageException {
	Object o = s.getUserObject();
	int value = (int) s.getType();   // losing 32 bits of precision here
	switch(value) {
	case Scripting.SWALLOW_REQUEST:
	    if(o != null && o instanceof TransferInterface) 
		return new ScriptResult(this, getNewTransferContainer());
	    break;
	case Scripting.UNSWALLOW_REQUEST:
	    unswallow((Container) s.getUserObject());
	    return new ScriptResult(this, null);
	case Scripting.REPAINT:
	    list.repaint();
	    return new ScriptResult(this, null);
	}
	throw new UnknownMessageException("Unknown message in TransferListInterface");
    }

}










