/**
 * $Id: HLTransferServer.java,v 1.16 2001/10/05 14:19:07 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

package redlight.hotline;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.InetAddress;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Random;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.io.File;
import java.io.DataOutputStream;
import java.io.DataInputStream;
import java.io.ByteArrayOutputStream;

import redlight.utils.InterruptableInputStream;
import redlight.utils.DebuggerOutput;
import redlight.utils.ToArrayConverters;
import redlight.utils.QuickSort;
import redlight.utils.Meter;
import redlight.utils.MeterSource;
import redlight.utils.MacFileUtils;
import redlight.utils.FilenameUtils;
import redlight.utils.TimeFormat;
import redlight.utils.BytesFormat;
import redlight.macfiles.MacFile;
import redlight.macfiles.Transferrer;

/**
 * A part of the Hotline server that handles file transfers.
 */
class HLTransferServer extends Thread {

    ServerSocket transferSocket;
    HLServer hls;
    protected Vector transferThreads;

    HLTransferServer(HLServer hls, ServerSocket transferSocket) {

        transferThreads = new Vector();
        this.hls = hls; 
        this.transferSocket = transferSocket;
        this.setName("HLTransferServer " + transferSocket);        
        this.start();

    }

    public void run() {

        DebuggerOutput.debug("HLTransferServer starting ...");

        while(!isInterrupted()) {
            
            try {
                
                transferSocket.setSoTimeout(2000);
                Socket client = transferSocket.accept();
                
                /* Check whether client is on the bantable. If so,
                   just disconnect immediately */
                
                if(hls.banTable.contains(client.getInetAddress())) {
                    
                    hls.log("Client " + 
                            client.getInetAddress().toString() + 
                            " is on bantable, disconnecting.");
                    
                    try {
                        
                        client.close();
                        
                    } catch(IOException _e) {}
                    
                    
                } else {
                    
                    client.setSoLinger(true, 5);

                    if(!isInterrupted())
                        new TransferThread(this, client);
                    
                    
                }
                
            } catch(InterruptedIOException e) {
                
            } catch(IOException e) {
                
                DebuggerOutput.stackTrace(e);
                
            }
            
        }           

        DebuggerOutput.debug("HLTransferServer: stopping transfer threads");
        
        /* Stop transfer threads. */
        
        for(Enumeration en = transferThreads.elements(); 
            en.hasMoreElements(); ) {
            
            TransferThread t = (TransferThread) en.nextElement();
            t.disconnect();
            
        }
                
        transferThreads.clear();
        
        DebuggerOutput.debug("HLTransferServer exiting");

    }

}

