/**
 * $Id: MacBinaryFork.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.macfiles;

import java.io.*;

import redlight.utils.DebuggerOutput;


public abstract class MacBinaryFork 
    extends Fork {
    byte[] pad = new byte[128];

    public MacBinaryFork(MacFile parent) {
	super(parent);
    }

    public DataOutput getDataOutput() {
	return ((MacBinaryMacFile) parent).getRandomAccessFile();
    }

    public DataInput getDataInput() {
	return ((MacBinaryMacFile) parent).getRandomAccessFile();
    }

    public void close(long len) throws IOException {
	try {
	    DebuggerOutput.debug("MacBinaryFork: padding (len = "+len+")");
	    int padlen = 128 - ((int) len % 128);
	    if(padlen != 128)
		((MacBinaryMacFile) parent).getRandomAccessFile().write(pad, 0, padlen);
	} catch(IOException e) {
	    e.printStackTrace();
	}
    }

    public boolean delete() {
	return false;
    }

    public boolean exists() {
	return false;
    }
}















