/**
 * $Id: ResourceOutputStream.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.macfiles;

import java.io.OutputStream;
import java.io.IOException;

import com.apple.MacOS.*;
import com.apple.memory.*;
import com.apple.mrj.*;

import redlight.utils.DebuggerOutput;
import redlight.utils.MacFileUtils;

public class ResourceOutputStream 
    extends OutputStream implements com.apple.NativeObject {    

    private short refNum;
    private ResourceFork parent;

    public ResourceOutputStream(ResourceFork fork) throws IOException {
	parent = fork;
	refNum = parent.refNum;
    }
        
    public void close() throws  IOException {
	parent.close();
    }

    public void flush() {
    }

    public void write(int b) {
	byte[] buf = new byte[1];
	buf[0] = (byte) b;
	short err = FSWrite(refNum, new PInt(1), buf);
	MacOSError.CheckResult(err);
    }
        
    public void write(byte[] b, int offset, int length) {
	PInt r = new PInt(length); 
	short err = FSWrite(refNum, r, b);
	MacOSError.CheckResult(err);
    }
    
    /**
     * The JDirect implementation
     */

    /** specify the library names that we need to work */
    private static String[] kNativeLibraryNames = { "InterfaceLib" };

    /** Declare the native methods that we're accessing */
    private static native short FSWrite(
					short refNum, 
					PInt bytesWritten, 
					byte[] buf);
}
