/**
 * $Id: ScriptResult.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.script;

/**
 * A ScriptResult encapsulates the reply to a 
 * message. It defines origin, status and data for a reply.
 */
public class ScriptResult {
    public static int RESULT_NO_ERROR = 0;
    public static int RESULT_ERROR = 1;
    public static int RESULT_UNDEFINED = -1;
    public static int RESULT_UNKNOWN = 255;
    int status;
    Object userObject;
    Scriptable origin;

    /**
     * Create a ScriptResult with given status and 
     * null data.
     * @param o the originator of this reply
     * @param s the status
     */
    public ScriptResult(Scriptable o, int s) {
	this(o, s, null);
    }
    /**
     * Create a ScriptResult with given data and
     * status RESULT_NO_ERROR.
     * @param o the originator of this reply
     * @param d the data
     */
    public ScriptResult(Scriptable o, Object d) {
	this(o, RESULT_NO_ERROR, d);
    }
    /**
     * Create a ScriptResult with given data and status.
     * @param o the originator of this reply
     * @param s the status
     * @param d the data
     */
    public ScriptResult(Scriptable o, int s, Object d) {
	status = s;
	userObject = d;
	origin = o;
    }
    /**
     * Returns the reply status.
     * @return the status
     */
    public int getStatus() {
	return status;
    }
    /**
     * Returns the data.
     * @return a data object
     */
    public Object getUserObject() {
	return userObject;
    }

    public String toString() {
	return this.getClass().getName() + "[status = " + status + ", origin = " + origin + ", userObject = " + userObject + "]";
    }
}


