/**
 * $Id: MacFileUtils.java,v 1.1.1.1 2001/07/22 02:44:50 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.utils;

import java.io.File;
import java.io.IOException;

import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;

public class MacFileUtils {

    public static byte[] getFileCreator(File f) {
	try {
	    MRJOSType creator = MRJFileUtils.getFileCreator(f);
	    return creator.toString().getBytes();
	} catch(IOException e) {
	    return new byte[4];
	}
    }

    public static byte[] getFileType(File f) {
	try {
	    MRJOSType type = MRJFileUtils.getFileType(f);
	    return type.toString().getBytes();
	} catch(IOException e) {
	    return new byte[4];
	}
    }

    public static void setFileTypeAndCreator(File f, byte[] type, byte[] creator) {
	try {
	    MRJFileUtils.setFileTypeAndCreator(f,
					       new MRJOSType(new String(type)), new MRJOSType(new String(creator)));
	} catch(IOException e) {
	}
    }

}
