import java.io.*;

public class localurl
{
 protected String name; /* jmeno bez adresare */
 protected String localname; /* jmeno souboru, kde to je */
 protected String location; /* redirect info */
 protected String dir; /* kde jsem ulozen ? */

 protected long date; /* update time */
 protected String ctype; /* content-type */
 protected String enc; /* Content-Encoding */


 /* interni flagy */
 protected boolean modified;
 protected boolean exists;


 public localurl(String ldir,String uname)
 {
  dir=ldir;
  name=localname=uname;
  if(uname.length()==0) localname="index.html";
  modified=false;
  checkFile();
 }

 protected void checkFile()
 {
  File f=new File(dir,localname);
  if(f.isFile()) exists=true; else { exists=false;return;}
  if(date==0) date=f.lastModified();
  if(ctype==null)
   {
    String ln=localname.toLowerCase();
    if(ln.endsWith(".gif") ||
       ln.endsWith(".jpeg") ||
       ln.endsWith(".jpg") ||
       ln.endsWith(".png") ||
       ln.endsWith(".xbm"))
         ctype="image/unknown"; else ctype="text/html";
   }
 }


 public localurl(String ldir,String uname,String localname,String ctype,String enc,String location,long date)
 {
  dir=ldir;
  name=uname;
  this.ctype=ctype;
  this.location=location;
  this.date=date;
  this.localname=localname;
  this.enc=enc;
  modified=false;
  exists=true;
 }

 public static void init(String z[])
 {
 }

 public long getDate()
 {
  return date;
 }

 public void setDate(long d)
 {
  date=d;
  modified=true;
 }

 public boolean isModified()
 {
  return modified;
 }

 public boolean exists()
 {
  return exists;
 }

 public InputStream getInputStream() throws IOException
 {
  if(!exists) throw new FileNotFoundException();
  if(enc==null) return new FileInputStream(dir+localname);
  if(enc.toLowerCase().indexOf("gzip")>-1) return new java.util.zip.GZIPInputStream(new FileInputStream(dir+localname),4096);
  return new FileInputStream(dir+localname);
 }

 public OutputStream getOutputStream() throws IOException
 {
  OutputStream res;
  res=new FileOutputStream(dir+localname);
  touch();
  return res;
 }

 public void touch()
 {
  modified=true;
  date=System.currentTimeMillis();
 }

 public String getLocation()
 {
  return location;
 }

 public int hashCode()
 {
  return name.hashCode();
 }

 public void setLocation(String s)
 {
  location=s;
  modified=true;
 }

 public boolean isParseable()
 {
  if(exists==true && ctype.startsWith("text/html")) return true;
   else return false;
 }
}
