/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLEditorPane
extends JEditorPane {
    public void initialize() {
        this.setContentType("text/html");
        this.setEditable(false);
        this.addHyperlinkListener(new Hyperactive());
    }

    public HTMLEditorPane() {
        this.initialize();
    }

    public HTMLEditorPane(URL uRL) throws IOException {
        super(uRL);
        this.initialize();
    }

    private class Hyperactive
    implements HyperlinkListener {
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        jEditorPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        private Hyperactive() {
        }
    }
}

