/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.gui;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.ValidatedTextField;
import xnap.gui.XNapFrame;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.util.NapPreferences;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NapPreferencesPanel
extends AbstractPreferencesPanel
implements PropertyChangeListener {
    private NapPreferences napPrefs;
    private ValidatedTextField jteLocalPort;
    private JCheckBox jcAutoFetchNapigator;
    private JCheckBox jcUseAutoconnector;
    private ValidatedTextField jteMaxAutoconnectServers;
    private ValidatedTextField jteMaxSearchServers;
    private ValidatedTextField jteMaxSearchResultsPerServer;

    public void apply() {
        this.napPrefs.setLocalPortRange(this.jteLocalPort.getText());
        this.napPrefs.setAutoFetchNapigator(this.jcAutoFetchNapigator.isSelected());
        this.napPrefs.setUseAutoconnector(this.jcUseAutoconnector.isSelected());
        this.napPrefs.setMaxAutoconnectServers(this.jteMaxAutoconnectServers.getIntValue());
        this.napPrefs.setMaxSearchServers(this.jteMaxSearchServers.getIntValue());
        this.napPrefs.setMaxSearchResultsPerServer(this.jteMaxSearchResultsPerServer.getIntValue());
    }

    public void close() {
        prefs.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateFirewall();
    }

    protected void updateFirewall() {
        this.jteLocalPort.setEnabled(prefs.isFirewalled() ^ true);
    }

    public Icon getIcon() {
        return XNapFrame.getSmallIcon("network_local.png");
    }

    public String getTitle() {
        return "OpenNap";
    }

    private final /* synthetic */ void this() {
        this.napPrefs = NapPreferences.getInstance();
    }

    public NapPreferencesPanel() {
        this.this();
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(Plugin.tr("Local Port", 1)));
        GridBagHelper.add((Container)jPanel, Plugin.tr("If text field is disabled, check firewall settings"));
        this.jteLocalPort = new ValidatedTextField(this.napPrefs.getLocalPortRange(), 20, "0123456789;-");
        GridBagHelper.add(jPanel, this.jteLocalPort, false);
        GridBagHelper.add((Container)this, jPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(Plugin.tr("Startup", 1)));
        GridBagHelper.add((Container)this, jPanel2);
        this.jcAutoFetchNapigator = new JCheckBox(Plugin.tr("Download Napigator List", 1), this.napPrefs.getAutoFetchNapigator());
        GridBagHelper.add((Container)jPanel2, this.jcAutoFetchNapigator);
        this.jcUseAutoconnector = new JCheckBox(Plugin.tr("Connect automatically", 1), this.napPrefs.getUseAutoconnector());
        GridBagHelper.add((Container)jPanel2, this.jcUseAutoconnector);
        GridBagHelper.addLabel(this, Plugin.tr("Automatically connected servers"));
        this.jteMaxAutoconnectServers = new ValidatedTextField("" + this.napPrefs.getMaxAutoconnectServers(), 5, "0123456789");
        GridBagHelper.add(this, this.jteMaxAutoconnectServers, false);
        GridBagHelper.addLabel(this, Plugin.tr("Max Search Servers"));
        this.jteMaxSearchServers = new ValidatedTextField("" + this.napPrefs.getMaxSearchServers(), 5, "0123456789");
        GridBagHelper.add(this, this.jteMaxSearchServers, false);
        GridBagHelper.addLabel(this, Plugin.tr("Max Search Results Per Server"));
        this.jteMaxSearchResultsPerServer = new ValidatedTextField("" + this.napPrefs.getMaxSearchResultsPerServer(), 5, "0123456789");
        GridBagHelper.add(this, this.jteMaxSearchResultsPerServer, false);
        GridBagHelper.addVerticalSpacer(this);
        this.updateFirewall();
        prefs.addPropertyChangeListener("firewalled", this);
    }
}

