/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import xnap.net.AbstractBrowse;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.BrowseSocket;
import xnap.plugin.nap.net.SearchResult;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.DirectBrowseRequestMessage;
import xnap.plugin.nap.net.msg.server.DirectBrowseAckMessage;
import xnap.plugin.nap.net.msg.server.DirectBrowseErrorMessage;
import xnap.plugin.nap.net.msg.server.MessageStream;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.util.QuotedStringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DirectBrowse
extends AbstractBrowse {
    public static final int SERVER_TIMEOUT = 120000;
    protected static Logger logger;
    protected Server server;
    protected Socket socket;
    protected InputStream in;
    protected OutputStream out;
    protected StringBuffer readBuffer;
    static /* synthetic */ Class class$xnap$plugin$nap$net$DirectBrowse;

    public synchronized int available() throws IOException {
        int n = this.in.available();
        if (n > 0) {
            byte[] byArray = new byte[n];
            int n2 = this.in.read(byArray, 0, n);
            String string = new String(byArray);
            this.readBuffer.append(string);
            this.parse();
        } else if (n == -1) {
            throw new IOException("Socket closed");
        }
        return super.available();
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void connect() throws IOException {
        try {
            this.establishConnection();
            logger.debug("connected to " + this.getUser().getName());
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    private final void establishConnection() throws IOException {
        String string = "";
        int n = 0;
        BrowseSocket browseSocket = null;
        MessageStream messageStream = new MessageStream(this.server);
        MessageHandler.subscribe(641, messageStream);
        MessageHandler.subscribe(642, messageStream);
        this.server.send(new DirectBrowseRequestMessage(this.getUser().getName()));
        IOException iOException = null;
        long l = System.currentTimeMillis();
        while (true) {
            long l2;
            if ((l2 = 120000L - (System.currentTimeMillis() - l)) <= 0L) {
                iOException = new IOException("server timeout");
                break;
            }
            if (messageStream.hasNext(100L)) {
                ServerMessage serverMessage;
                ServerMessage serverMessage2 = messageStream.next();
                if (serverMessage2 instanceof DirectBrowseErrorMessage) {
                    serverMessage = (DirectBrowseErrorMessage)serverMessage2;
                    if (!serverMessage.nick.equals(this.getUser().getName())) continue;
                    iOException = new IOException(serverMessage.message);
                } else {
                    if (!(serverMessage2 instanceof DirectBrowseAckMessage)) continue;
                    serverMessage = (DirectBrowseAckMessage)serverMessage2;
                    if (!((DirectBrowseAckMessage)serverMessage).nick.equals(this.getUser().getName())) continue;
                    string = ((DirectBrowseAckMessage)serverMessage).ip;
                    n = ((DirectBrowseAckMessage)serverMessage).port;
                }
                break;
            }
            if (this.server.getListener() != null && (browseSocket = (BrowseSocket)this.server.getListener().waitForSocket(new BrowseSocket(this.getUser().getName()), 100L)) != null) break;
        }
        MessageHandler.unsubscribe(641, messageStream);
        MessageHandler.unsubscribe(642, messageStream);
        if (iOException != null) {
            throw iOException;
        }
        if (browseSocket != null) {
            this.handle(browseSocket);
        } else if (n == 0) {
            this.establishReverseStream();
        } else {
            this.establishStream(string, n);
        }
    }

    private final void establishStream(String string, int n) throws IOException {
        logger.debug("opening socket " + string + ':' + n);
        this.socket = new Socket(string, n);
        try {
            this.socket.setSoTimeout(60000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.out = this.socket.getOutputStream();
        this.in = new BufferedInputStream(this.socket.getInputStream());
        logger.debug("reading magic number");
        char c = (char)this.in.read();
        if (c != '1') {
            throw new IOException(Plugin.tr("Invalid request"));
        }
        this.write("GETLIST");
        byte[] byArray = new byte[2048];
        this.in.mark(2048);
        int n2 = this.in.read(byArray);
        if (n2 > 0) {
            String string2 = new String(byArray, 0, n2);
            int n3 = string2.indexOf("\n");
            if (n3 == -1) {
                this.in.read();
            } else {
                string2 = string2.substring(0, n3).trim();
                this.in.reset();
                this.in.skip(n3 + 1);
            }
            if (!string2.equals(this.getUser().getName())) {
                throw new IOException("Invalid user: " + string2);
            }
        } else {
            throw new IOException("Socket error");
        }
    }

    private final void establishReverseStream() throws IOException {
        if (this.server.getListener() == null) {
            throw new IOException("Both parties firewalled");
        }
        BrowseSocket browseSocket = (BrowseSocket)this.server.getListener().waitForSocket(new BrowseSocket(this.getUser().getName()), 60000L);
        if (browseSocket == null) {
            throw new IOException("Listener timeout");
        }
        this.handle(browseSocket);
    }

    private final void handle(BrowseSocket browseSocket) throws IOException {
        this.socket = browseSocket.socket;
        try {
            this.socket.setSoTimeout(60000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.out = this.socket.getOutputStream();
        this.in = browseSocket.in;
    }

    protected void parse() {
        int n;
        while ((n = this.readBuffer.toString().indexOf("\n")) != -1) {
            String string = this.readBuffer.substring(0, n);
            this.readBuffer.delete(0, n + 1);
            logger.debug("parse [" + string + ']');
            if (string.equals("")) {
                this.finished = true;
                logger.debug("browse finished");
                return;
            }
            try {
                QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string);
                if (quotedStringTokenizer.countTokens() < 6) continue;
                String string2 = quotedStringTokenizer.nextToken();
                String string3 = quotedStringTokenizer.nextToken();
                long l = Long.parseLong(quotedStringTokenizer.nextToken());
                int n2 = Integer.parseInt(quotedStringTokenizer.nextToken());
                int n3 = Integer.parseInt(quotedStringTokenizer.nextToken());
                int n4 = Integer.parseInt(quotedStringTokenizer.nextToken());
                this.add(new SearchResult(l, n2, n3, n4, (User)this.getUser(), string2, string3));
            }
            catch (Exception exception) {
                logger.warn("parse " + string, exception);
            }
        }
    }

    protected void write(String string) throws IOException {
        logger.debug("> " + string);
        this.out.write(string.getBytes());
        this.out.flush();
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.readBuffer = new StringBuffer();
    }

    public DirectBrowse(User user) {
        super(user);
        this.this();
        this.server = user.getServer();
    }

    static {
        Class clazz = class$xnap$plugin$nap$net$DirectBrowse;
        if (clazz == null) {
            clazz = class$xnap$plugin$nap$net$DirectBrowse = DirectBrowse.class$("[Lxnap.plugin.nap.net.DirectBrowse;", false);
        }
        logger = Logger.getLogger(clazz);
    }
}

