/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import raskob.geometry.InsecSweepPoint;
import raskob.geometry.Point;

public final class InsecSweepInsec {
    private final Point insec;
    private final int edge0;
    private final int polN0;
    private final int polN1;
    private final InsecSweepPoint isp0;
    private final InsecSweepPoint isp1;

    public InsecSweepInsec(int edge0, int polN0, int edge1, int polN1, Point insec, InsecSweepPoint isp0, InsecSweepPoint isp1) {
        this.edge0 = edge0;
        this.polN0 = polN0;
        this.polN1 = polN1;
        this.insec = insec;
        this.isp0 = isp0;
        this.isp1 = isp1;
    }

    public final Point getIntersection() {
        return this.insec;
    }

    public final InsecSweepPoint getIsp0() {
        return this.isp0;
    }

    public final InsecSweepPoint getIsp1() {
        return this.isp1;
    }

    public static int compare(InsecSweepInsec insec1, InsecSweepInsec insec2) {
        Point p1 = insec1.insec;
        Point p2 = insec2.insec;
        int compare = Point.compare(p1, p2);
        if (compare != 0) {
            return compare;
        }
        if (insec1.edge0 < insec2.edge0) {
            return -1;
        }
        if (insec1.edge0 > insec2.edge0) {
            return 1;
        }
        if (insec1.polN0 < insec2.polN0) {
            return -1;
        }
        return insec1.polN1 <= insec2.polN1 ? 0 : 1;
    }
}

