/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

public final class MathP {
    public static boolean equals(double x, double y) {
        return MathP.round(x) == MathP.round(y);
    }

    public static int compare(double x, double y) {
        if (MathP.less(x, y)) {
            return -1;
        }
        return !MathP.greater(x, y) ? 0 : 1;
    }

    public static boolean less(double x, double y) {
        return MathP.round(x) < MathP.round(y);
    }

    public static boolean lessEqual(double x, double y) {
        return MathP.round(x) <= MathP.round(y);
    }

    public static boolean greater(double x, double y) {
        return MathP.round(x) > MathP.round(y);
    }

    public static boolean greaterEqual(double x, double y) {
        return MathP.round(x) >= MathP.round(y);
    }

    public static double min(double x, double y) {
        if (MathP.lessEqual(x, y)) {
            return x;
        }
        return y;
    }

    public static double max(double x, double y) {
        if (MathP.greater(x, y)) {
            return x;
        }
        return y;
    }

    public static double getPrecision() {
        return 1.0E-4;
    }

    public static double round(double x) {
        return MathP.round(x, 1.0E-4);
    }

    public static double round(double x, double prec) {
        return (double)Math.round(x / prec) * prec;
    }
}

