/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import raskob.geometry.MathP;

public class Point {
    private double x;
    private double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final void setX(double x) {
        this.x = x;
    }

    public final double getX() {
        return this.x;
    }

    public final void setY(double y) {
        this.y = y;
    }

    public final double getY() {
        return this.y;
    }

    public final boolean lessEqual(Point p) {
        return Point.compare(this, p) <= 0;
    }

    public final boolean equals(Point p) {
        return Point.compare(this, p) == 0;
    }

    public final boolean isLeftupper(Point p) {
        if (MathP.less(this.x, p.getX())) {
            return true;
        }
        return MathP.equals(this.x, p.getX()) && MathP.greater(this.y, p.getY());
    }

    public static int compare(Point p1, Point p2) {
        int x = MathP.compare(p1.getX(), p2.getX());
        int y = MathP.compare(p1.getY(), p2.getY());
        if (x != 0) {
            return x;
        }
        return y;
    }

    public static int compareEx(Point p1, Point p2) {
        int x = p1.getX() < p2.getX() ? -1 : (p1.getX() > p2.getX() ? 1 : 0);
        int y = p1.getY() < p2.getY() ? -1 : (p1.getY() > p2.getY() ? 1 : 0);
        if (x != 0) {
            return x;
        }
        return y;
    }

    public static Point first(Point p1, Point p2) {
        if (p1.lessEqual(p2)) {
            return p1;
        }
        return p2;
    }

    public static Point second(Point p1, Point p2) {
        if (p1.lessEqual(p2)) {
            return p2;
        }
        return p1;
    }

    public static double distance(Point p1, Point p2) {
        return Math.sqrt((p1.getX() - p2.getX()) * (p1.getX() - p2.getX()) + (p1.getY() - p2.getY()) * (p1.getY() - p2.getY()));
    }

    public double distance(Point p) {
        double xDiff = Math.abs(this.x - p.getX());
        double yDiff = Math.abs(this.y - p.getY());
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    public final void round() {
        this.x = MathP.round(this.x);
        this.y = MathP.round(this.y);
    }

    public final String toString() {
        return new StringBuilder(String.valueOf(this.x)).append("/").append(this.y).toString();
    }
}

