/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.arrays;

public final class ArrayVector {
    public static final void sub(float[] fArray, float[] fArray2, float[] fArray3) {
        for (int i = 0; i < fArray3.length; ++i) {
            fArray3[i] = fArray[i] - fArray2[i];
        }
    }

    public static final void add(float[] fArray, float[] fArray2, float[] fArray3) {
        for (int i = 0; i < fArray3.length; ++i) {
            fArray3[i] = fArray[i] + fArray2[i];
        }
    }

    public static final float lengthSquared(float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i] * fArray[i];
        }
        return f;
    }

    public static final float length(float[] fArray) {
        return (float)Math.sqrt(ArrayVector.lengthSquared(fArray));
    }

    public static final float distanceSquared(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += (fArray[i] - fArray2[i]) * (fArray[i] - fArray2[i]);
        }
        return f;
    }

    public static final float distance(float[] fArray, float[] fArray2) {
        return (float)Math.sqrt(ArrayVector.distanceSquared(fArray, fArray2));
    }

    public static final void cross(float[] fArray, float[] fArray2, float[] fArray3) {
        for (int i = 0; i < fArray3.length; ++i) {
            fArray3[i] = fArray[(i + 1) % fArray.length] * fArray2[(i + 2) % fArray2.length] - fArray[(i + 2) % fArray.length] * fArray2[(i + 1) % fArray2.length];
        }
    }

    public static final float dot(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i] * fArray2[i];
        }
        return f;
    }

    public static final void set(float[] fArray, float[] fArray2) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[i];
        }
    }

    public static final float[] clone(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        ArrayVector.set(fArray, fArray2);
        return fArray2;
    }

    public static final void normalize(float[] fArray) {
        float f = ArrayVector.length(fArray);
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] / f;
        }
    }

    public static final void scale(float f, float[] fArray) {
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] * f;
        }
    }

    public static final void negate(float[] fArray) {
        ArrayVector.scale(-1.0f, fArray);
    }

    public static final void absolute(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = Math.abs(fArray[i]);
        }
    }

    public static final float angle(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray.length];
        ArrayVector.cross(fArray, fArray2, fArray3);
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray3[i] * fArray3[i];
        }
        double d = Math.sqrt(f);
        return (float)Math.abs(Math.atan2(d, ArrayVector.dot(fArray, fArray2)));
    }

    public static final void clampMin(float f, float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            fArray[i] = f;
        }
    }

    public static final void clampMin(float f, float[] fArray, float[] fArray2) {
        ArrayVector.set(fArray, fArray2);
        ArrayVector.clampMin(f, fArray2);
    }

    public static final void clampMax(float f, float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] > f)) continue;
            fArray[i] = f;
        }
    }

    public static final void clampMax(float f, float[] fArray, float[] fArray2) {
        ArrayVector.set(fArray, fArray2);
        ArrayVector.clampMax(f, fArray2);
    }

    public static final void clamp(float f, float f2, float[] fArray) {
        ArrayVector.clampMin(f, fArray);
        ArrayVector.clampMax(f2, fArray);
    }

    public static final void clamp(float f, float f2, float[] fArray, float[] fArray2) {
        ArrayVector.set(fArray, fArray2);
        ArrayVector.clamp(f, f2, fArray2);
    }

    public static void round(float[] fArray, int n) {
        float f = (float)Math.pow(10.0, n);
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)((int)(fArray[i] * f)) / f;
        }
    }

    public static final void interpolate(float[] fArray, float[] fArray2, float f) {
        float f2 = 1.0f - f;
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f2 * fArray[i] + f * fArray2[i];
        }
    }

    public static final void interpolate(float[] fArray, float[] fArray2, float f, float[] fArray3) {
        ArrayVector.set(fArray, fArray3);
        ArrayVector.interpolate(fArray3, fArray2, f);
    }

    public static final String toString(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(fArray[i]);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

