/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d;

import de.grogra.ext.x3d.X3DParser;
import de.grogra.ext.x3d.importation.SceneImport;
import de.grogra.ext.x3d.xmlbeans.SceneDocument;
import de.grogra.ext.x3d.xmlbeans.X3DDocument;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Null;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.ui.Workbench;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlTokenSource;

public class X3DImport
extends FilterBase
implements ObjectSource {
    protected static X3DImport theImport = null;
    protected Stack<X3DParser> parsers = null;
    protected Null sceneNode = null;
    protected Workbench workbench = Workbench.current();

    public X3DImport(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.workbench.beginStatus((Object)this);
        this.workbench.setStatus((Object)this, "Import X3D", -1.0f);
        this.setFlavor(IOFlavor.valueOf(Node.class));
        theImport = this;
        this.parsers = new Stack();
        File file = new File(filterSource.getSystemId());
        X3DDocument x3DDocument = null;
        try {
            x3DDocument = X3DDocument.Factory.parse((File)file);
        }
        catch (XmlException xmlException) {
            xmlException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        SceneDocument.Scene scene = x3DDocument.getX3D().getScene();
        this.sceneNode = SceneImport.createInstance(scene);
        X3DParser x3DParser = new X3DParser((XmlTokenSource)scene, file);
        this.addNewParser(x3DParser);
        x3DParser.parseScene(this.sceneNode);
        this.removeCurrentParser();
        this.workbench.clearStatusAndProgress((Object)this);
    }

    public Object getObject() throws IOException {
        return this.sceneNode;
    }

    public static X3DImport getTheImport() {
        return theImport;
    }

    public X3DParser getCurrentParser() {
        return this.parsers.peek();
    }

    public void addNewParser(X3DParser x3DParser) {
        this.parsers.push(x3DParser);
    }

    public void removeCurrentParser() {
        this.parsers.pop();
    }

    public void increaseProgress() {
        this.workbench.setStatus((Object)this, "Import X3D");
        this.workbench.setIndeterminateProgress((Object)this);
    }
}

