/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.importation;

import de.grogra.ext.x3d.ProtoInstanceImport;
import de.grogra.ext.x3d.X3DImport;
import de.grogra.ext.x3d.util.Util;
import de.grogra.ext.x3d.xmlbeans.DirectionalLightDocument;
import de.grogra.ext.x3d.xmlbeans.X3DNode;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.EdgePatternImpl;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.DirectionalLight;
import de.grogra.imp3d.objects.LightNode;
import de.grogra.imp3d.shading.Light;
import de.grogra.math.RGBColor;
import java.util.HashMap;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectionalLightImport {
    private static float intensityFactor = 10.0f;
    private static Vector3d upVec = new Vector3d(0.0, 0.0, 1.0);

    public static LightNode createInstance(DirectionalLightDocument.DirectionalLight directionalLight) {
        LightNode lightNode = null;
        HashMap<String, Object> hashMap = X3DImport.getTheImport().getCurrentParser().getReferenceMap();
        if (directionalLight.isSetUSE()) {
            try {
                lightNode = (LightNode)((Node)hashMap.get(directionalLight.getUSE())).cloneGraph((EdgePattern)EdgePatternImpl.TREE, true);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        } else {
            lightNode = new LightNode();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            if (directionalLight.isSetIS()) {
                ProtoInstanceImport.calcFinalValueMap(hashMap2, (X3DNode)directionalLight);
            }
            DirectionalLightImport.setValues(lightNode, directionalLight, hashMap2);
            if (directionalLight.isSetDEF()) {
                hashMap.put(directionalLight.getDEF(), lightNode);
            }
        }
        lightNode.setName("X3DDirectionalLight");
        return lightNode;
    }

    private static void setValues(LightNode lightNode, DirectionalLightDocument.DirectionalLight directionalLight, HashMap<String, String> hashMap) {
        DirectionalLight directionalLight2 = new DirectionalLight();
        RGBColor rGBColor = new RGBColor();
        String string = hashMap.get("color") != null ? hashMap.get("color") : directionalLight.getColor();
        Util.splitStringToTuple3f((Tuple3f)rGBColor, string);
        directionalLight2.getColor().set((Tuple3f)rGBColor);
        Vector3d vector3d = new Vector3d();
        String string2 = hashMap.get("direction") != null ? hashMap.get("direction") : directionalLight.getDirection();
        Util.convertStringToTuple3d((Tuple3d)vector3d, string2);
        lightNode.setTransform(Util.vectorsToTransMatrix(upVec, vector3d));
        float f = hashMap.get("intensity") != null ? Float.valueOf(hashMap.get("intensity")).floatValue() : directionalLight.getIntensity();
        directionalLight2.setPowerDensity(f * intensityFactor);
        lightNode.setLight((Light)directionalLight2);
    }
}

