/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp;

import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.IMPWorkbench;
import de.grogra.imp.View;
import de.grogra.imp.io.ImageWriter;
import de.grogra.imp.net.ClientConnection;
import de.grogra.imp.net.Commands;
import de.grogra.imp.net.Connection;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceConnection;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FileTypeItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ObjectSourceImpl;
import de.grogra.pf.io.OutputStreamSource;
import de.grogra.pf.io.ProjectLoader;
import de.grogra.pf.io.RegistryLoader;
import de.grogra.pf.registry.Application;
import de.grogra.pf.registry.Directory;
import de.grogra.pf.registry.Executable;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Plugin;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.Expression;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.HeadlessToolkit;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.event.ActionEditEvent;
import de.grogra.pf.ui.registry.CommandItem;
import de.grogra.pf.ui.registry.CommandPlugin;
import de.grogra.pf.ui.registry.SourceFile;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import de.grogra.util.I18NBundle;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.MemoryFileSystem;
import de.grogra.xl.lang.ObjectConsumer;
import de.grogra.xl.util.ObjectList;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.swing.filechooser.FileFilter;
import javax.vecmath.Tuple3f;

public final class IMP
extends Plugin
implements CommandPlugin {
    public static final I18NBundle I18N = I18NBundle.getInstance(IMP.class);
    public static final MimeType TYPES_MIME_TYPE = MimeType.valueOf(Type[].class);
    public static final IOFlavor TYPES_FLAVOR = new IOFlavor(TYPES_MIME_TYPE);
    public static final Command CLOSE = new Command(){

        public void run(Object object, Context context) {
            ((IMPWorkbench)context.getWorkbench()).close((Command)object);
        }

        public String getCommandName() {
            return null;
        }
    };
    private static IMP PLUGIN;
    private ObjectList workbenches = new ObjectList(4, false);
    private IMPWorkbench mainWorkbench;
    private UIToolkit ui;

    public static IMP getInstance() {
        return PLUGIN;
    }

    public IMP() {
        assert (PLUGIN == null);
        PLUGIN = this;
    }

    public UIToolkit getToolkit() {
        return this.ui;
    }

    public IMPWorkbench getMainWorkbench() {
        return this.mainWorkbench;
    }

    public static void run(Application application) {
        IMP.getInstance().runImpl(application);
    }

    private void runImpl(Application application) {
        Registry registry = Registry.create((Registry)this.getRegistry());
        try {
            IMP.loadRegistry(registry, null, false);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        registry.setEmptyGraph();
        if ("true".equals(Main.getProperty((String)"headless"))) {
            this.ui = new HeadlessToolkit();
        } else {
            Object object;
            Expression expression = (Expression)this.getRegistry().getItem("/ui/toolkits");
            if (expression == null || !((object = expression.evaluate((RegistryContext)this, new StringMap().putObject("registry", (Object)this.getRegistry()))) instanceof UIToolkit)) {
                Main.showMessage((String)"No UI toolkit found", (boolean)true);
                return;
            }
            this.ui = (UIToolkit)object;
        }
        this.mainWorkbench = new IMPWorkbench(registry, null);
        this.mainWorkbench.getIMPJobManager().run();
        this.mainWorkbench = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerWorkbench(IMPWorkbench iMPWorkbench) {
        ObjectList objectList = this.workbenches;
        synchronized (objectList) {
            this.workbenches.add((Object)iMPWorkbench);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final IMPWorkbench iMPWorkbench, Window window) {
        boolean bl;
        ObjectList objectList = this.workbenches;
        synchronized (objectList) {
            bl = this.workbenches.size() == 2;
        }
        if (bl) {
            this.mainWorkbench.getJobManager().runLater(new Command(){

                public void run(Object object, Context context) {
                    Window window = context.getWindow();
                    if (window != null && window.getPanels(null).length == 0) {
                        window.hide();
                    }
                    iMPWorkbench.getIMPJobManager().start(null);
                }

                public String getCommandName() {
                    return null;
                }
            }, null, (Context)this.mainWorkbench, 70536);
        } else {
            iMPWorkbench.getIMPJobManager().start(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterWorkbench(IMPWorkbench iMPWorkbench, Window window) {
        ObjectList objectList = this.workbenches;
        synchronized (objectList) {
            this.workbenches.remove((Object)iMPWorkbench);
            if (this.workbenches.size() == 1) {
                this.mainWorkbench.getJobManager().runLater(new Command(){

                    public void run(Object object, Context context) {
                        if (context.getWorkbench().isHeadless()) {
                            return;
                        }
                        context.getWindow().show(true, null);
                    }

                    public String getCommandName() {
                        return null;
                    }
                }, null, (Context)this.mainWorkbench, 70536);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        IMPWorkbench iMPWorkbench;
        ObjectList objectList = this.workbenches;
        synchronized (objectList) {
            if (this.workbenches.isEmpty()) {
                return;
            }
            iMPWorkbench = (IMPWorkbench)this.workbenches.peek(1);
        }
        iMPWorkbench.getJobManager().execute(CLOSE, (Object)new Command(){

            public void run(Object object, Context context) {
                IMP.this.exit();
            }

            public String getCommandName() {
                return null;
            }
        }, (Context)iMPWorkbench, 10000);
    }

    public static void loadRegistry(Registry registry, RegistryLoader registryLoader, boolean bl) throws IOException {
        StringMap stringMap = new StringMap().putObject("registry", (Object)registry);
        if (bl) {
            ((Item)registry.getRoot()).add((Item)new Directory("project"));
        }
        Executable.runExecutables((Registry)registry.getRootRegistry(), (String)"/hooks/configure", (RegistryContext)registry, (StringMap)stringMap);
        if (registryLoader != null) {
            registryLoader.loadRegistry(registry);
        }
        Executable.runExecutables((Registry)registry.getRootRegistry(), (String)"/hooks/complete", (RegistryContext)registry, (StringMap)stringMap);
        registry.activateItems();
    }

    public void run(Object object, Context context, CommandItem commandItem) {
        final IMPWorkbench iMPWorkbench = (IMPWorkbench)context.getWorkbench();
        String string = commandItem.getName();
        if ("close".equals(string)) {
            CLOSE.run(null, context);
        } else if ("exit".equals(string)) {
            this.exit();
        } else if ("aboutsoftware".equals(string)) {
            iMPWorkbench.showAboutAppDialog(this.getPluginDescriptor());
        } else if ("export".equals(string)) {
            if (!(object instanceof ActionEditEvent)) {
                return;
            }
            ActionEditEvent actionEditEvent = (ActionEditEvent)object;
            if (actionEditEvent.isConsumed() || !(actionEditEvent.getPanel() instanceof View)) {
                return;
            }
            context.getWorkbench().export(IMP.toFilterSource((View)actionEditEvent.getPanel()));
        } else if ("snapshot".equals(string)) {
            if (!(object instanceof ActionEditEvent)) {
                return;
            }
            ActionEditEvent actionEditEvent = (ActionEditEvent)object;
            if (actionEditEvent.isConsumed() || !(actionEditEvent.getPanel() instanceof View)) {
                return;
            }
            final View view = (View)actionEditEvent.getPanel();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Snapshot
            implements Command,
            ObjectConsumer<RenderedImage> {
                Snapshot() {
                }

                public String getCommandName() {
                    return null;
                }

                public void run(Object object, Context context) {
                    FileChooserResult fileChooserResult;
                    IOFlavor iOFlavor = ImageWriter.RENDERED_IMAGE_FLAVOR;
                    FileTypeItem.Filter filter = null;
                    FileTypeItem.Filter[] filterArray = IO.getWritableFileTypes((IOFlavor)iOFlavor);
                    if (filterArray != null) {
                        for (int i = 0; i < filterArray.length; ++i) {
                            FileTypeItem fileTypeItem = filterArray[i].getItem();
                            MimeType mimeType = fileTypeItem.getMimeType();
                            if (!mimeType.equals((Object)MimeType.PNG)) continue;
                            filter = filterArray[i];
                            break;
                        }
                    }
                    if ((fileChooserResult = iMPWorkbench.chooseFileToSave(I18N.msg("snapshot.title"), iOFlavor, filter)) == null) {
                        return;
                    }
                    IMP.writeImage((Context)view, (RenderedImage)object, fileChooserResult.getMimeType(), fileChooserResult.file);
                }

                public void consume(RenderedImage renderedImage) {
                    iMPWorkbench.getJobManager().runLater((Command)this, (Object)renderedImage, (Context)view, 10000);
                }
            }
            view.getViewComponent().makeSnapshot(new Snapshot());
        }
    }

    private static FilterSource toFilterSource(View view) {
        return new ObjectSourceImpl((Object)view, "view", view.getFlavor(), view.getWorkbench().getRegistry().getRootRegistry(), null);
    }

    public static void export(View view, MimeType mimeType, File file) {
        view.getWorkbench().export(IMP.toFilterSource(view), mimeType, file);
    }

    public static void writeImage(Image image, File file) {
        if (!(image instanceof RenderedImage)) {
            throw new IllegalArgumentException("image has to be instance of RenderedImage");
        }
        Workbench workbench = Workbench.current();
        if (workbench == null) {
            throw new IllegalStateException("no current workbench");
        }
        FileTypeItem fileTypeItem = FileTypeItem.get((RegistryContext)workbench, (String)file.getName());
        if (fileTypeItem == null) {
            throw new UnsupportedOperationException("unsupported image format of " + file);
        }
        IMP.writeImage((Context)workbench, (RenderedImage)((Object)image), fileTypeItem.getMimeType(), file);
    }

    public static void writeImage(Context context, RenderedImage renderedImage, MimeType mimeType, File file) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            IMP.writeImage(context, renderedImage, mimeType, bufferedOutputStream, file.getPath());
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            context.getWorkbench().logGUIInfo(I18N.msg("snapshot.failed", (Object)file), (Throwable)iOException);
        }
    }

    public static void writeImage(Context context, RenderedImage renderedImage, MimeType mimeType, OutputStream outputStream, String string) {
        FilterSource filterSource = IO.createPipeline((FilterSource)new ObjectSourceImpl((Object)renderedImage, "snapshot", ImageWriter.RENDERED_IMAGE_FLAVOR, context.getWorkbench().getRegistry().getRootRegistry(), null), (IOFlavor)new IOFlavor(mimeType, 2, null));
        if (filterSource == null) {
            context.getWorkbench().logGUIInfo(IO.I18N.msg("save.unsupported", (Object)string, (Object)IO.getDescription((MimeType)mimeType)));
            return;
        }
        try {
            ((OutputStreamSource)filterSource).write(outputStream);
        }
        catch (IOException iOException) {
            context.getWorkbench().logGUIInfo(I18N.msg("snapshot.failed", (Object)string), (Throwable)iOException);
        }
    }

    public static void closeWorkbench(Context context) {
        UI.getJobManager((Context)context).runLater(CLOSE, null, context, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMPWorkbench openWorkbench(IMPWorkbench iMPWorkbench, FilterSource filterSource, Map map) {
        FilterSource filterSource2 = IO.createPipeline((FilterSource)filterSource, (IOFlavor)IOFlavor.PROJECT_LOADER);
        if (!(filterSource2 instanceof ObjectSource)) {
            iMPWorkbench.logGUIInfo(IO.I18N.msg("openproject.unsupported", (Object)IO.toName((String)filterSource.getSystemId()), (Object)IO.getDescription((MimeType)filterSource.getFlavor().getMimeType())));
            return null;
        }
        Registry registry = Registry.create((Registry)this.getRegistry());
        IMPWorkbench iMPWorkbench2 = new IMPWorkbench(registry, map);
        try {
            ProjectLoader projectLoader = (ProjectLoader)((ObjectSource)filterSource2).getObject();
            Registry.setCurrent((RegistryContext)registry);
            iMPWorkbench2.setName(IO.toSimpleName((String)filterSource.getSystemId()));
            IMP.loadRegistry(registry, (RegistryLoader)projectLoader, true);
            projectLoader.loadGraph(registry);
            if (filterSource instanceof FileSource) {
                iMPWorkbench2.setFile(((FileSource)filterSource).getInputFile(), filterSource.getFlavor().getMimeType());
            }
            if (projectLoader instanceof Workbench.Loader) {
                ((Workbench.Loader)projectLoader).loadWorkbench((Workbench)iMPWorkbench2);
            }
        }
        catch (Exception exception) {
            iMPWorkbench2.disposeWhenNotInitialized();
            iMPWorkbench.logGUIInfo(IO.I18N.msg("openproject.failed", (Object)IO.toName((String)filterSource.getSystemId())), exception);
            IMPWorkbench iMPWorkbench3 = null;
            return iMPWorkbench3;
        }
        finally {
            Registry.setCurrent((RegistryContext)iMPWorkbench);
        }
        this.start(iMPWorkbench2, iMPWorkbench.getWindow());
        return iMPWorkbench2;
    }

    public static void openClientWorkbench(Item item, Object object, Context context) throws IOException {
        Socket socket = Commands.getSocket(context, "localhost:58090");
        if (socket != null) {
            Connection connection = new Connection(socket);
            connection.start();
            IMP.openClientWorkbench(connection, context);
        }
    }

    public static void openClientWorkbench(final Connection connection, Context context) throws IOException {
        final IMPWorkbench iMPWorkbench = (IMPWorkbench)context.getWorkbench();
        iMPWorkbench.removeConnection(connection);
        final Registry registry = new Registry(IMP.getInstance().getRegistry());
        final ClientConnection clientConnection = new ClientConnection(new PersistenceBindings((TypeLoader)registry, (SharedObjectProvider.Binding)registry), connection);
        registry.createGraphs((PersistenceConnection)clientConnection);
        new Thread(new Runnable(){

            public void run() {
                try {
                    clientConnection.initialize((PersistenceManager)registry.getRegistryGraph());
                    registry.initialize();
                    registry.initFileSystem((FileSystem)new MemoryFileSystem("pfs"));
                }
                catch (IOException iOException) {
                    iMPWorkbench.logGUIInfo(null, iOException);
                    return;
                }
                IMPWorkbench iMPWorkbench2 = new IMPWorkbench(registry, null);
                Registry.setCurrent((RegistryContext)registry);
                try {
                    IMP.loadRegistry(registry, null, true);
                    clientConnection.initialize((PersistenceManager)registry.getProjectGraph());
                    iMPWorkbench2.setName(clientConnection.getName() + '@' + connection.getSocket().getRemoteSocketAddress());
                    iMPWorkbench2.ignoreIfModified();
                    IMP.getInstance().start(iMPWorkbench2, iMPWorkbench.getWindow());
                    iMPWorkbench2.addConnection(connection);
                }
                catch (IOException iOException) {
                    iMPWorkbench.logGUIInfo(null, iOException);
                }
            }
        }, "OpenClientWorkbench@" + connection).start();
    }

    public static SourceFile getFileToAdd(Context context) {
        IMPWorkbench iMPWorkbench = (IMPWorkbench)context.getWorkbench();
        FileChooserResult fileChooserResult = iMPWorkbench.chooseFile(null, (FileFilter[])IO.getReadableFileTypes((IOFlavor[])new IOFlavor[]{IOFlavor.RESOURCE_LOADER}), 1, false, null);
        if (fileChooserResult == null) {
            return null;
        }
        MimeType mimeType = fileChooserResult.getMimeType();
        if (fileChooserResult.file.exists()) {
            switch (context.getWindow().showChoiceDialog(fileChooserResult.file.getName(), UI.I18N, "addfiledialog", new String[]{"add", "link"})) {
                case 0: {
                    break;
                }
                case 1: {
                    return new SourceFile(IO.toSystemId((File)fileChooserResult.file), mimeType);
                }
                default: {
                    return null;
                }
            }
        }
        return IMP.toSourceFile(fileChooserResult.file, mimeType, context);
    }

    public static SourceFile toSourceFile(File file, MimeType mimeType, Context context) {
        Object object;
        FileSystem fileSystem = context.getWorkbench().getRegistry().getFileSystem();
        try {
            object = file.exists() ? fileSystem.addLocalFile(file, fileSystem.getRoot(), file.getName()) : fileSystem.create(fileSystem.getRoot(), file.getName(), false);
        }
        catch (IOException iOException) {
            context.getWorkbench().logGUIInfo(IO.I18N.msg("addfile.failed", (Object)file), (Throwable)iOException);
            return null;
        }
        return new SourceFile(IO.toSystemId((FileSystem)fileSystem, (Object)object), mimeType);
    }

    public static SourceFile addSourceFile(File file, MimeType mimeType, Context context) {
        SourceFile sourceFile = IMP.toSourceFile(file, mimeType, context);
        if (sourceFile != null) {
            context.getWorkbench().getRegistry().getDirectory("/project/objects/files", null).addUserItem((Item)sourceFile);
        }
        return sourceFile;
    }

    public static void addNode(Item item, Object object, Context context) {
        ActionEditEvent actionEditEvent;
        Expression expression;
        Node node;
        if (object instanceof Node) {
            node = (Node)object;
            expression = null;
        } else if (object instanceof ActionEditEvent) {
            node = null;
            actionEditEvent = (ActionEditEvent)object;
            if (actionEditEvent.isConsumed() || !((object = actionEditEvent.getSource()) instanceof Expression)) {
                return;
            }
            actionEditEvent.consume();
            expression = (Expression)object;
        } else {
            return;
        }
        actionEditEvent = context.getWorkbench();
        UI.executeLockedly((Lockable)actionEditEvent.getRegistry().getProjectGraph(), (boolean)true, (Command)new Command((Workbench)actionEditEvent){
            final /* synthetic */ Workbench val$w;
            {
                this.val$w = workbench;
            }

            public String getCommandName() {
                return null;
            }

            public void run(Object object, Context context) {
                Node node2;
                Object object2 = node2 = node != null ? node : expression.evaluate((RegistryContext)this.val$w, UI.getArgs((Context)context, (Map)expression));
                if (!(node2 instanceof Node)) {
                    return;
                }
                node2.setExtentIndex(7);
                GraphManager graphManager = this.val$w.getRegistry().getProjectGraph();
                graphManager.getRoot().addEdgeBitsTo(node2, 512, graphManager.getActiveTransaction());
            }
        }, null, (Context)context, (int)10000);
    }

    public static void addEdgeBits(final Node node, final Node node2, final int n, Context context) {
        final Workbench workbench = context.getWorkbench();
        UI.executeLockedly((Lockable)workbench.getRegistry().getProjectGraph(), (boolean)true, (Command)new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object object, Context context) {
                GraphManager graphManager = workbench.getRegistry().getProjectGraph();
                node.addEdgeBitsTo(node2, n, graphManager.getActiveTransaction());
            }
        }, null, (Context)context, (int)10000);
    }

    public static void removeEdgeBits(final Node node, final Node node2, final int n, Context context) {
        final Workbench workbench = context.getWorkbench();
        UI.executeLockedly((Lockable)workbench.getRegistry().getProjectGraph(), (boolean)true, (Command)new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object object, Context context) {
                GraphManager graphManager = workbench.getRegistry().getProjectGraph();
                node.removeEdgeBitsTo(node2, n, graphManager.getActiveTransaction());
            }
        }, null, (Context)context, (int)10000);
    }

    private static float clamp(float f) {
        return f >= 1.0f ? 1.0f : (f <= 0.0f ? 0.0f : f);
    }

    public static Color getAWTColor(float f, float f2, float f3, float f4) {
        return new Color(IMP.clamp(f), IMP.clamp(f2), IMP.clamp(f3), IMP.clamp(f4));
    }

    public static Color getAWTColor(Tuple3f tuple3f) {
        return IMP.getAWTColor(tuple3f.x, tuple3f.y, tuple3f.z, 1.0f);
    }

    public static Tuple3f setColor(Tuple3f tuple3f, int n) {
        tuple3f.set((float)(n >> 16 & 0xFF) * 0.003921569f, (float)(n >> 8 & 0xFF) * 0.003921569f, (float)(n & 0xFF) * 0.003921569f);
        return tuple3f;
    }
}

