/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.awt;

import de.grogra.imp.IMP;
import de.grogra.imp.View;
import de.grogra.imp.ViewComponent;
import de.grogra.imp.awt.ViewComponentAdapter;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.pf.io.FileWriterSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSourceImpl;
import de.grogra.pf.registry.Item;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.UI;
import de.grogra.util.EventListener;
import de.grogra.util.ImageAndGraphics;
import de.grogra.util.Lock;
import de.grogra.util.LockProtectedRunnable;
import de.grogra.util.Lockable;
import de.grogra.util.MimeType;
import de.grogra.util.Utils;
import de.grogra.xl.lang.ObjectConsumer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.vecmath.Tuple3f;
import org.jibble.epsgraphics.EpsGraphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CanvasAdapter
extends ViewComponentAdapter
implements ImageObserver {
    private static final String ANTIALIASING_OPTION = "antialiasing";
    protected static final AffineTransform IDENTITY = new AffineTransform();
    private Component canvas;
    private Graphics2D graphics;
    private ImageAndGraphics canvasBuffer = null;
    private ImageAndGraphics newCanvasBuffer = null;
    protected ImageAndGraphics sceneBuffer = null;
    private ImageAndGraphics newSceneBuffer = null;
    private ImageAndGraphics drawBuffer = null;
    private ImageAndGraphics newDrawBuffer = null;
    private EpsGraphics2D epsGraphics;
    private int currentWidth = -1;
    private int currentHeight;
    private int bufferWidth;
    private int bufferHeight;
    private int paintWidth;
    private int paintHeight;
    private final Object canvasBufferLock = new Object();
    private RenderedImage imageFromRenderer;
    protected boolean antialiasing = false;
    private BufferedImage copyBuffer;
    private Graphics2D copyBufferGraphics;
    private int[] copyBufferSamples;
    private static final int COPY_BUFFER_HEIGHT = 32;

    public void initCanvas(Component component) {
        this.canvas = component;
    }

    @Override
    public void initView(View view, EventListener eventListener) {
        this.antialiasing = Boolean.TRUE.equals(this.getOption(ANTIALIASING_OPTION, Boolean.FALSE));
        super.initView(view, eventListener);
        this.installListeners(this.canvas);
    }

    @Override
    protected void optionValueChanged(String string, Object object) {
        if (ANTIALIASING_OPTION.equals(string)) {
            this.antialiasing = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else {
            super.optionValueChanged(string, object);
        }
    }

    @Override
    protected ImageObserver getObserverForRenderer() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkBuffers() {
        int n = this.canvas.getWidth();
        int n2 = this.canvas.getHeight();
        if (n != this.currentWidth || n2 != this.currentHeight) {
            Object object = this.renderFlagsLock;
            synchronized (object) {
                if (n > this.bufferWidth || n2 > this.bufferHeight || n * n2 << 2 < this.bufferWidth * this.bufferHeight) {
                    this.bufferWidth = n * 5 >> 2;
                    this.bufferHeight = n2 * 5 >> 2;
                    this.newCanvasBuffer = this.createIG(this.newCanvasBuffer, this.bufferWidth, this.bufferHeight);
                    this.newSceneBuffer = this.createIG(this.newSceneBuffer, this.bufferWidth, this.bufferHeight);
                    this.newDrawBuffer = this.createIG(this.newDrawBuffer, this.bufferWidth, this.bufferHeight);
                }
                this.currentWidth = n;
                this.currentHeight = n2;
                this.repaint(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics graphics) {
        Image image;
        this.checkBuffers();
        Object object = this.canvasBufferLock;
        synchronized (object) {
            image = this.canvasBuffer != null ? this.canvasBuffer.getImage() : null;
        }
        if (graphics != null && image != null) {
            graphics.drawImage(image, 0, 0, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initRender(int n) {
        if (this.newCanvasBuffer != null) {
            Object object = this.canvasBufferLock;
            synchronized (object) {
                this.canvasBuffer = CanvasAdapter.replace(this.canvasBuffer, this.newCanvasBuffer);
            }
        }
        this.newCanvasBuffer = null;
        this.sceneBuffer = CanvasAdapter.replace(this.sceneBuffer, this.newSceneBuffer);
        this.newSceneBuffer = null;
        this.drawBuffer = CanvasAdapter.replace(this.drawBuffer, this.newDrawBuffer);
        this.newDrawBuffer = null;
        this.paintWidth = this.currentWidth;
        this.paintHeight = this.currentHeight;
    }

    public Object getComponent() {
        return this.canvas;
    }

    private void copyImage(Image image, int n, int n2, int n3, int n4, ImageAndGraphics imageAndGraphics) {
        if (this.copyBuffer == null || this.copyBuffer.getWidth() < n3) {
            this.copyBuffer = new BufferedImage(n3, 32, 2);
            this.copyBufferGraphics = this.copyBuffer.createGraphics();
            this.copyBufferGraphics.setComposite(AlphaComposite.Src);
            this.copyBufferSamples = new int[n3 * 32 * 4];
        }
        int n5 = n2 + n4;
        while (n2 < n5) {
            n4 = Math.min(n5 - n2, 32);
            this.copyBufferGraphics.drawImage(image, 0, 0, n3, n4, n, n2, n + n3, n2 + n4, null);
            this.copyBufferSamples = this.copyBuffer.getRaster().getPixels(0, 0, n3, n4, this.copyBufferSamples);
            int n6 = 0;
            for (int i = n2; i < n2 + n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n7 = this.copyBufferSamples[n6 + 3];
                    int n8 = (255 - n7) * (410 + ((j ^ i) & 8) * 26) >> 10;
                    this.copyBufferSamples[n6] = this.copyBufferSamples[n6++] * n7 / 255 + n8;
                    this.copyBufferSamples[n6] = this.copyBufferSamples[n6++] * n7 / 255 + n8;
                    this.copyBufferSamples[n6] = this.copyBufferSamples[n6++] * n7 / 255 + n8;
                    this.copyBufferSamples[n6++] = 255;
                }
            }
            this.copyBuffer.getRaster().setPixels(0, 0, n3, n4, this.copyBufferSamples);
            imageAndGraphics.getGraphics().drawImage(this.copyBuffer, n, n2, n + n3, n2 + n4, 0, 0, n3, n4, null);
            n2 += n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (n4 <= 0 || n5 <= 0) {
            return true;
        }
        if ((n & 0xE0) != 0) {
            if ((n & 0x20) != 0) {
                Object object = this.renderFlagsLock;
                synchronized (object) {
                    this.copyImage(image, n2, n3, n4, n5, this.sceneBuffer);
                    this.repaint(2048);
                    if (image instanceof RenderedImage) {
                        this.imageFromRenderer = (RenderedImage)((Object)image);
                    }
                }
            }
            return false;
        }
        if ((n & 8) != 0) {
            Object object = this.renderFlagsLock;
            synchronized (object) {
                this.copyImage(image, n2, n3, n4, n5, this.sceneBuffer);
                this.repaint(2048);
            }
        }
        return true;
    }

    private static ImageAndGraphics replace(ImageAndGraphics imageAndGraphics, ImageAndGraphics imageAndGraphics2) {
        if (imageAndGraphics2 == null) {
            return imageAndGraphics;
        }
        if (imageAndGraphics != null) {
            imageAndGraphics.dispose();
        }
        return imageAndGraphics2;
    }

    private ImageAndGraphics createIG(ImageAndGraphics imageAndGraphics, int n, int n2) {
        Image image;
        if (imageAndGraphics != null) {
            imageAndGraphics.dispose();
        }
        if ((image = this.canvas.createImage(n, n2)) == null) {
            image = new BufferedImage(n, n2, 1);
        }
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        return new ImageAndGraphics(image, (Graphics)graphics2D);
    }

    @Override
    protected void invokeRender(int n) {
        if (this.sceneBuffer == null) {
            return;
        }
        if (this.epsGraphics != null) {
            n |= 1;
        }
        final int n2 = n;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Task
        implements LockProtectedRunnable,
        Command {
            Task() {
            }

            public void run(boolean bl, Lock lock) {
                CanvasAdapter.this.invokeRenderSync(n2);
                if (CanvasAdapter.this.epsGraphics != null) {
                    UI.getJobManager((Context)CanvasAdapter.this.getView()).runLater((Command)this, (Object)CanvasAdapter.this.epsGraphics, (Context)CanvasAdapter.this.getView(), 10000);
                    CanvasAdapter.this.epsGraphics = null;
                } else {
                    CanvasAdapter.this.canvas.repaint();
                }
            }

            public String getCommandName() {
                return null;
            }

            public void run(Object object, Context context) {
                ObjectSourceImpl objectSourceImpl = new ObjectSourceImpl(object, "eps", new IOFlavor(MimeType.POSTSCRIPT, 8, null), context.getWorkbench().getRegistry(), null);
                FileChooserResult fileChooserResult = context.getWorkbench().chooseFileToSave(null, objectSourceImpl.getFlavor(), null);
                if (fileChooserResult == null) {
                    return;
                }
                FilterSource filterSource = IO.createPipeline((FilterSource)objectSourceImpl, (IOFlavor)new IOFlavor(MimeType.POSTSCRIPT, 64, null));
                try {
                    ((FileWriterSource)filterSource).write(fileChooserResult.file);
                }
                catch (IOException iOException) {
                    context.getWorkbench().logGUIInfo(IMP.I18N.msg("snapshot.failed", (Object)fileChooserResult.file), (Throwable)iOException);
                }
            }
        }
        Utils.executeForcedlyAndUninterruptibly((Lockable)this.getView().getGraph(), (LockProtectedRunnable)new Task(), (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void render(int n) throws InterruptedException {
        Object object;
        if (this.epsGraphics != null) {
            this.renderUninterruptibly();
        }
        ImageAndGraphics imageAndGraphics = this.sceneBuffer;
        this.initPaint(n, this.paintWidth, this.paintHeight);
        try {
            if ((n & 1) != 0) {
                this.imageFromRenderer = null;
                if (this.epsGraphics != null) {
                    this.graphics = this.epsGraphics;
                    this.paintScene(n, this.graphics);
                } else {
                    this.graphics = (Graphics2D)imageAndGraphics.getGraphics();
                    if (this.antialiasing) {
                        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    this.paintScene(n, this.graphics);
                    this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
            }
            Object var4_3 = null;
            if (this.epsGraphics != null) return;
        }
        catch (Throwable throwable) {
            Object object2;
            Object var4_4 = null;
            if (this.epsGraphics != null) throw throwable;
            this.renderUninterruptibly();
            if (this.drawBuffer != null) {
                object2 = this.drawBuffer.getGraphics();
                ((Graphics2D)object2).setTransform(IDENTITY);
                ((Graphics)object2).drawImage(this.sceneBuffer.getImage(), 0, 0, null);
                this.graphics = (Graphics2D)object2;
                this.paintHighlight(n, this.graphics);
            }
            object2 = this.canvasBufferLock;
            synchronized (object2) {
                imageAndGraphics = this.drawBuffer;
                this.drawBuffer = this.canvasBuffer;
                this.canvasBuffer = imageAndGraphics;
                throw throwable;
            }
        }
        this.renderUninterruptibly();
        if (this.drawBuffer != null) {
            object = this.drawBuffer.getGraphics();
            ((Graphics2D)object).setTransform(IDENTITY);
            ((Graphics)object).drawImage(this.sceneBuffer.getImage(), 0, 0, null);
            this.graphics = (Graphics2D)object;
            this.paintHighlight(n, this.graphics);
        }
        object = this.canvasBufferLock;
        synchronized (object) {
            imageAndGraphics = this.drawBuffer;
            this.drawBuffer = this.canvasBuffer;
            this.canvasBuffer = imageAndGraphics;
            return;
        }
    }

    protected abstract void initPaint(int var1, int var2, int var3);

    protected abstract void paintScene(int var1, Graphics2D var2) throws InterruptedException;

    protected abstract void paintHighlight(int var1, Graphics2D var2);

    @Override
    public void makeSnapshot(ObjectConsumer<? super RenderedImage> objectConsumer) {
        RenderedImage renderedImage = this.imageFromRenderer;
        if (renderedImage != null) {
            objectConsumer.consume((Object)renderedImage);
            return;
        }
        Image image = this.sceneBuffer.getImage();
        if (!(image instanceof BufferedImage)) {
            return;
        }
        objectConsumer.consume((Object)((BufferedImage)image).getSubimage(0, 0, this.currentWidth, this.currentHeight));
    }

    public static void writeEPS(Item item, Object object, Context context) {
        ViewComponent viewComponent;
        View view = View.get(context);
        if (view != null && (viewComponent = view.getViewComponent()) instanceof CanvasAdapter) {
            ((CanvasAdapter)viewComponent).epsGraphics = new EpsGraphics2D(context.getWorkbench().getName());
            viewComponent.repaint(1);
        }
    }

    public final Graphics2D getGraphics() {
        return this.graphics;
    }

    public void resetGraphicsTransform() {
        this.getGraphics().setTransform(IDENTITY);
    }

    public abstract void setColor(Color var1);

    public void setColor(int n) {
        this.setColor(Utils.getApproximateColor((int)n));
    }

    public void setColor(Tuple3f tuple3f) {
        this.setColor(CanvasAdapter.getIntColor(tuple3f));
    }

    public void setColor(Color color, int n, boolean bl) {
        int n2 = ViewSelection.getColor(color.getRGB(), n, bl);
        this.setColor(n2 == color.getRGB() ? color : Utils.getApproximateColor((int)n2));
    }

    public void setColor(int n, int n2, boolean bl) {
        int n3 = ViewSelection.getColor(n, n2, bl);
        if (n3 == n) {
            this.setColor(n3);
        } else {
            this.setColor(Utils.getApproximateColor((int)n3));
        }
    }

    public void setColor(Tuple3f tuple3f, int n, boolean bl) {
        int n2 = CanvasAdapter.getIntColor(tuple3f);
        int n3 = ViewSelection.getColor(n2, n, bl);
        if (n3 == n2) {
            this.setColor(n3);
        } else {
            this.setColor(Utils.getApproximateColor((int)n3));
        }
    }

    public class CanvasComponent
    extends Component {
        private final Dimension preferredSize;

        public CanvasComponent(int n, int n2) {
            this.preferredSize = new Dimension(n, n2);
            this.setSize(this.preferredSize);
        }

        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        public void paint(Graphics graphics) {
            CanvasAdapter.this.paint(graphics);
        }
    }
}

