/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.io;

import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.XMLReaderBase;
import de.grogra.util.MimeType;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLTableReader
extends XMLReaderBase {
    public static final MimeType MIME_TYPE = new MimeType("text/x-grogra-table+xml", null);
    public static final IOFlavor DOUBLE_FLAVOR = IOFlavor.valueOf(double[][].class);
    public static final IOFlavor STRING_FLAVOR = IOFlavor.valueOf(String[][].class);
    private int depth;
    private ObjectList row;
    private ObjectList rows;
    private final boolean readDoubles;
    private Locator loc;

    public XMLTableReader(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.readDoubles = filterItem.getName().indexOf("double") >= 0;
        this.setFlavor(this.readDoubles ? DOUBLE_FLAVOR : STRING_FLAVOR);
    }

    protected Object getObjectImpl() throws IOException {
        return this.rows.toArray(this.readDoubles ? (Object[])new double[this.rows.size()][] : (Object[])new String[this.rows.size()][]);
    }

    public void startDocument() {
        this.depth = 0;
        this.row = new ObjectList();
        this.rows = new ObjectList();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.depth == 1) {
            this.row.clear();
        }
        ++this.depth;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (--this.depth == 1) {
            if (this.readDoubles) {
                double[] dArray = new double[this.row.size()];
                for (int i = 0; i < dArray.length; ++i) {
                    try {
                        dArray[i] = Double.parseDouble((String)this.row.get(i));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXParseException(null, this.loc, numberFormatException);
                    }
                }
                this.rows.add((Object)dArray);
            } else {
                this.rows.add((Object)this.row.toArray((Object[])new String[this.row.size()]));
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.depth == 3) {
            this.row.add((Object)new String(cArray, n, n2).trim());
        }
    }
}

