/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.net;

import de.grogra.imp.net.Connection;
import de.grogra.imp.net.MessageHandler;
import de.grogra.imp.net.SimpleResponseHandler;
import de.grogra.persistence.BindingsCache;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceConnection;
import de.grogra.persistence.PersistenceException;
import de.grogra.persistence.PersistenceInputStream;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.PersistenceOutputStream;
import de.grogra.persistence.Transaction;
import de.grogra.xl.util.IntHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class ClientConnection
extends PersistenceConnection
implements MessageHandler {
    static final int REGISTER_ID = 0;
    static final int INITIALIZE_ID = 1;
    static final int COMMIT_LOCAL_ID = 2;
    static final int COMMIT_ID = 3;
    static final int ROLLBACK_LOCAL_ID = 4;
    static final String REGISTER = "0persistence0";
    static final String INITIALIZE = "1persistence1";
    static final String COMMIT_LOCAL = "2persistence2";
    static final String COMMIT = "3persistence3";
    static final String ROLLBACK_LOCAL = "4persistence4";
    static final int CONNECT_MAGIC = -725372255;
    static final int INITIALIZE_MAGIC = -1070394965;
    final Connection connection;
    PersistenceInputStream pin;
    PersistenceOutputStream pout;
    String name;
    final IntHashMap managers = new IntHashMap();

    public ClientConnection(final PersistenceBindings persistenceBindings, Connection connection) throws IOException {
        super(persistenceBindings);
        this.connection = connection;
        connection.addMessageHandler(this);
        SimpleResponseHandler simpleResponseHandler = new SimpleResponseHandler(3){

            protected void handleUserResponse(Connection connection, long l, long l2) throws IOException {
                DataInputStream dataInputStream = ClientConnection.this.connection.getIn();
                ClientConnection.this.pin = new PersistenceInputStream(persistenceBindings, dataInputStream);
                ClientConnection.this.connection.consumeInt(-725372255);
                ClientConnection.this.initializeCache(new BindingsCache(persistenceBindings, dataInputStream.readShort()));
                ClientConnection.this.name = dataInputStream.readUTF();
            }
        };
        long l = connection.beginMessage("connectremote", simpleResponseHandler);
        this.pout = new PersistenceOutputStream(this.getLocalCache(), connection.getOut());
        this.pout.flush();
        connection.getOut().writeInt(-725372255);
        connection.end(l);
        simpleResponseHandler.waitForResultWrapInterruption();
    }

    public String getName() {
        return this.name;
    }

    public synchronized void commit(Transaction.Data data, long l) {
        try {
            long l2 = this.connection.beginMessage(COMMIT_LOCAL, null);
            data.getKey().write((DataOutput)this.connection.getOut());
            this.connection.getOut().writeLong(l);
            this.pout.write(this.getLocalCache());
            data.write((DataOutput)this.pout);
            this.pout.flush();
            this.connection.end(l2);
        }
        catch (IOException iOException) {
            throw new PersistenceException((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short registerManager(PersistenceManager persistenceManager, String string) {
        try {
            SimpleResponseHandler simpleResponseHandler = new SimpleResponseHandler(0);
            long l = this.connection.beginMessage(REGISTER, simpleResponseHandler);
            this.connection.getOut().writeUTF(string);
            this.connection.end(l);
            short s = (short)simpleResponseHandler.getInt();
            IntHashMap intHashMap = this.managers;
            synchronized (intHashMap) {
                this.managers.put((int)s, (Object)persistenceManager);
            }
            return s;
        }
        catch (Exception exception) {
            throw new PersistenceException((Throwable)exception);
        }
    }

    public void deregisterManager(PersistenceManager persistenceManager) {
    }

    public void initialize(final PersistenceManager persistenceManager) throws IOException {
        SimpleResponseHandler simpleResponseHandler = new SimpleResponseHandler(3){

            protected void handleUserResponse(Connection connection, long l, long l2) throws IOException {
                persistenceManager.readExtent(ClientConnection.this.pin);
            }
        };
        long l = this.connection.beginMessage(INITIALIZE, simpleResponseHandler);
        this.connection.getOut().writeShort(persistenceManager.getId());
        this.connection.end(l);
        simpleResponseHandler.waitForResultWrapInterruption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Connection connection, long l, String string, boolean bl) throws IOException {
        PersistenceManager persistenceManager;
        int n;
        if (COMMIT_LOCAL.equals(string)) {
            n = 2;
        } else if (COMMIT.equals(string)) {
            n = 3;
        } else if (ROLLBACK_LOCAL.equals(string)) {
            n = 4;
        } else {
            return false;
        }
        if (bl) {
            return true;
        }
        DataInputStream dataInputStream = connection.getIn();
        short s = dataInputStream.readShort();
        IntHashMap intHashMap = this.managers;
        synchronized (intHashMap) {
            persistenceManager = (PersistenceManager)this.managers.get((int)s);
        }
        intHashMap = Transaction.Key.read((DataInput)dataInputStream);
        long l2 = dataInputStream.readLong();
        switch (n) {
            case 2: {
                persistenceManager.localTransactionCommitted((Transaction.Key)intHashMap, l2);
                break;
            }
            case 4: {
                persistenceManager.localTransactionRolledBack((Transaction.Key)intHashMap, l2);
                break;
            }
            case 3: {
                Transaction.Data data = new Transaction.Data(true, (Transaction.Key)intHashMap, this.pin.readCache());
                data.read((DataInput)this.pin);
                persistenceManager.transactionCommitted(data, l2);
            }
        }
        return true;
    }
}

