/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class MTGBranchElement {
    private double length;
    private double topdia;
    private double botdia;
    private double alpha;
    private double beta;
    private double gamma;
    private int nodeIndex;
    private Vector3d _dirp;
    private Vector3d _dirs;
    private Vector3d _origin;
    private Point3d[] topSurface;
    private Point3d[] botSurface;
    private int numOfSurfacePoints;
    private int order;

    public void setOrder(int n) {
        this.order = n;
    }

    public int getOrder() {
        return this.order;
    }

    public int getNumOfSurfacePoints() {
        return this.numOfSurfacePoints;
    }

    public Point3d[] getTopSurface(MTGBranchElement mTGBranchElement) {
        if (this.topSurface == null || this.botSurface == null) {
            this.topSurface = new Point3d[this.numOfSurfacePoints];
            this.botSurface = new Point3d[this.numOfSurfacePoints];
            this.computeSurfaces(mTGBranchElement);
        }
        return this.topSurface;
    }

    public Point3d[] getBotSurface(MTGBranchElement mTGBranchElement) {
        if (this.topSurface == null || this.botSurface == null) {
            this.topSurface = new Point3d[this.numOfSurfacePoints];
            this.botSurface = new Point3d[this.numOfSurfacePoints];
            this.computeSurfaces(mTGBranchElement);
        }
        return this.botSurface;
    }

    private void computeSurfaces(MTGBranchElement mTGBranchElement) {
        double d;
        double d2;
        int n;
        Point3d point3d;
        Point3d point3d2;
        Point3d point3d3 = new Point3d(this._origin.x, this._origin.y, this._origin.z);
        if (mTGBranchElement == null) {
            point3d2 = new Point3d((Tuple3d)this._dirp);
            point3d2.scale(this.length);
            point3d = new Point3d(point3d3.x + point3d2.x, point3d3.y + point3d2.y, point3d3.z + point3d2.z);
        } else {
            point3d = new Point3d((Tuple3d)mTGBranchElement.getOrigin());
            point3d2 = new Point3d();
            point3d2.sub((Tuple3d)point3d, (Tuple3d)point3d3);
        }
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.setTranslation(new Vector3d(-point3d3.x, -point3d3.y, -point3d3.z));
        Point3d point3d4 = new Point3d();
        Point3d point3d5 = new Point3d();
        matrix4d.transform(point3d3, point3d4);
        matrix4d.transform(point3d, point3d5);
        point3d2.sub((Tuple3d)point3d5, (Tuple3d)point3d4);
        double d3 = 0.0;
        if (point3d2.x == 0.0 && point3d2.y >= 0.0) {
            d3 = 0.0;
        } else if (point3d2.x == 0.0 && point3d2.y < 0.0) {
            d3 = Math.PI;
        } else if (point3d2.x > 0.0 && point3d2.y > 0.0) {
            d3 = Math.atan(point3d2.x / point3d2.y);
        } else if (point3d2.x > 0.0 && point3d2.y < 0.0) {
            d3 = Math.atan(Math.abs(point3d2.y) / point3d2.x) + 1.5707963267948966;
        } else if (point3d2.x < 0.0 && point3d2.y < 0.0) {
            d3 = Math.atan(Math.abs(point3d2.x) / Math.abs(point3d2.y)) + Math.PI;
        } else if (point3d2.x < 0.0 && point3d2.y > 0.0) {
            d3 = Math.atan(point3d2.y / Math.abs(point3d2.x)) + 4.71238898038469;
        } else if (point3d2.y == 0.0 && point3d2.x > 0.0) {
            d3 = 1.5707963267948966;
        } else if (point3d2.y == 0.0 && point3d2.x < 0.0) {
            d3 = 4.71238898038469;
        }
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.setIdentity();
        matrix4d2.rotZ(d3);
        Point3d point3d6 = new Point3d();
        Point3d point3d7 = new Point3d();
        matrix4d2.transform(point3d4, point3d6);
        matrix4d2.transform(point3d5, point3d7);
        point3d2.sub((Tuple3d)point3d7, (Tuple3d)point3d6);
        double d4 = 0.0;
        if (point3d2.z == 0.0 && point3d2.y >= 0.0) {
            d4 = 0.0;
        } else if (point3d2.z == 0.0 && point3d2.y < 0.0) {
            d4 = Math.PI;
        } else if (point3d2.z > 0.0 && point3d2.y > 0.0) {
            d4 = Math.atan(point3d2.y / point3d2.z) + 4.71238898038469;
        } else if (point3d2.z > 0.0 && point3d2.y < 0.0) {
            d4 = Math.atan(point3d2.z / Math.abs(point3d2.y)) + Math.PI;
        } else if (point3d2.z < 0.0 && point3d2.y < 0.0) {
            d4 = Math.atan(Math.abs(point3d2.y) / Math.abs(point3d2.z)) + 1.5707963267948966;
        } else if (point3d2.z < 0.0 && point3d2.y > 0.0) {
            d4 = Math.atan(Math.abs(point3d2.z) / point3d2.y);
        } else if (point3d2.y == 0.0 && point3d2.z > 0.0) {
            d4 = 4.71238898038469;
        } else if (point3d2.y == 0.0 && point3d2.z < 0.0) {
            d4 = 1.5707963267948966;
        }
        Matrix4d matrix4d3 = new Matrix4d();
        matrix4d3.setIdentity();
        matrix4d3.rotX(d4);
        Point3d point3d8 = new Point3d();
        Point3d point3d9 = new Point3d();
        matrix4d3.transform(point3d6, point3d8);
        matrix4d3.transform(point3d7, point3d9);
        Point3d point3d10 = new Point3d(point3d8);
        Point3d point3d11 = new Point3d(point3d9);
        double d5 = Math.PI * 2 / (double)this.numOfSurfacePoints;
        for (n = 0; n < this.numOfSurfacePoints; ++n) {
            d2 = Math.cos((double)(n + 1) * d5) * this.botdia;
            d = Math.sin((double)(n + 1) * d5) * this.botdia;
            this.botSurface[n] = new Point3d(d2, 0.0, d);
        }
        for (n = 0; n < this.numOfSurfacePoints; ++n) {
            d2 = Math.cos((double)(n + 1) * d5) * this.topdia;
            d = Math.sin((double)(n + 1) * d5) * this.topdia;
            this.topSurface[n] = new Point3d(d2, point3d11.y, d);
        }
        matrix4d3.invert();
        matrix4d2.invert();
        matrix4d.invert();
        for (n = 0; n < this.botSurface.length; ++n) {
            matrix4d3.transform(this.botSurface[n]);
            matrix4d2.transform(this.botSurface[n]);
            matrix4d.transform(this.botSurface[n]);
        }
        for (n = 0; n < this.topSurface.length; ++n) {
            matrix4d3.transform(this.topSurface[n]);
            matrix4d2.transform(this.topSurface[n]);
            matrix4d.transform(this.topSurface[n]);
        }
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double d) {
        this.length = d;
    }

    public double getTopDia() {
        return this.topdia;
    }

    public void setTopDia(double d) {
        this.topdia = d;
    }

    public double getBotDia() {
        return this.botdia;
    }

    public void setBotDia(double d) {
        this.botdia = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double d) {
        this.gamma = d;
    }

    public Vector3d getDirp() {
        return this._dirp;
    }

    public void setDirp(Vector3d vector3d) {
        if (this._dirp == null) {
            this._dirp = new Vector3d();
        }
        this._dirp.set((Tuple3d)vector3d);
    }

    public Vector3d getDirs() {
        return this._dirs;
    }

    public void setDirs(Vector3d vector3d) {
        if (this._dirs == null) {
            this._dirs = new Vector3d();
        }
        this._dirs.set((Tuple3d)vector3d);
    }

    public Vector3d getDirt() {
        Vector3d vector3d = new Vector3d();
        vector3d.cross(this._dirp, this._dirs);
        vector3d.normalize();
        return vector3d;
    }

    public Vector3d getOrigin() {
        return this._origin;
    }

    public void setOrigin(Vector3d vector3d) {
        if (this._origin == null) {
            this._origin = new Vector3d();
        }
        this._origin.set((Tuple3d)vector3d);
    }

    public MTGBranchElement(int n) {
        this.nodeIndex = n;
        this.length = 0.0;
        this.topdia = -1.0;
        this.botdia = -1.0;
        this.alpha = 0.0;
        this.beta = 0.0;
        this.gamma = 0.0;
        this.numOfSurfacePoints = 16;
        this.order = -1;
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double d) {
        this.beta = d;
    }
}

