/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.graph.impl.Node;
import de.grogra.icon.IconSource;
import de.grogra.imp3d.View3D;
import de.grogra.mtg.MTGFilter;
import de.grogra.persistence.ManageableType;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.MimeTypeItem;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ProjectLoader;
import de.grogra.pf.io.ResourceLoader;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemVisitor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.Showable;
import de.grogra.pf.ui.TextEditor;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.pf.ui.registry.UIItem;
import de.grogra.pf.ui.util.LockProtectedCommand;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.rgg.model.Runtime;
import de.grogra.util.Lock;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.xl.lang.ObjectToBoolean;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class MTGSourceFile
extends Item
implements UIItem,
ObjectToBoolean,
TreeModelListener,
Showable {
    private MTGFilter mtgFilter = null;
    MimeType mimeType;
    boolean editable = true;
    boolean disabled = false;
    transient String deactivationCategory;
    transient int activationStamp = -1;
    public static final Node.NType $TYPE = new Node.NType((Node)new MTGSourceFile());
    public static final Node.NType.Field mimeType$FIELD = new _Field("mimeType", 0x200000, (Type)ClassAdapter.wrap(MimeType.class), null, 0);
    public static final Node.NType.Field editable$FIELD;
    public static final Node.NType.Field disabled$FIELD;

    private MTGSourceFile() {
        this(null, null);
    }

    protected void setMTGFilter(MTGFilter mTGFilter) {
        this.mtgFilter = mTGFilter;
    }

    public MTGSourceFile(String string, MimeType mimeType) {
        super(string);
        this.mimeType = mimeType;
    }

    public FileSource toFileSource() {
        return FileSource.createFileSource((String)this.getName(), (MimeType)this.mimeType, (RegistryContext)this, (ModifiableMap)new StringMap((Map)this));
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public MimeTypeItem getMimeTypeItem() {
        return MimeTypeItem.get((RegistryContext)this, (MimeType)this.mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateImpl() {
        FileSource fileSource;
        FilterSource filterSource;
        if (this.disabled) {
            this.activationStamp = -1;
            return;
        }
        Object object = this.getRegistry().getProjectFile(this.getName());
        if (object != null) {
            this.getRegistry().addFileSystemListener((TreeModelListener)this);
            this.getRegistry().getFileSystem().setMimeType(object, this.mimeType);
        }
        if (!((filterSource = IO.createPipeline((FilterSource)(fileSource = this.toFileSource()), (IOFlavor)IOFlavor.RESOURCE_LOADER)) instanceof ObjectSource)) {
            return;
        }
        filterSource.initProgressMonitor(UI.createProgressAdapter((Context)Workbench.get((RegistryContext)this)));
        try {
            final ResourceLoader resourceLoader = (ResourceLoader)((ObjectSource)filterSource).getObject();
            this.deactivationCategory = resourceLoader.getJoinedDeactivationCategory();
            if (this.activationStamp != this.getRegistry().getActivationStamp()) {
                this.activationStamp = this.getRegistry().getActivationStamp();
                ((Item)this.getAxisParent()).forAll(null, null, new ItemVisitor(){

                    public void visit(Item item, Object object) {
                        if (!item.isActivated() && item instanceof MTGSourceFile && !((MTGSourceFile)item).disabled && ((MTGSourceFile)item).activationStamp != MTGSourceFile.this.activationStamp && resourceLoader.addResource((FilterSource)((MTGSourceFile)item).toFileSource())) {
                            ((MTGSourceFile)item).activationStamp = MTGSourceFile.this.activationStamp;
                        }
                    }
                }, null, false);
                resourceLoader.loadResource(this.getRegistry());
            }
        }
        catch (Exception exception) {
            Workbench.get((RegistryContext)this).logGUIInfo(IO.I18N.msg("openfile.failed", (Object)fileSource.getSystemId()), (Throwable)exception);
        }
        finally {
            filterSource.setProgress(null, 2.0f);
        }
    }

    protected void deactivateImpl() {
        this.getRegistry().removeFileSystemListener((TreeModelListener)this);
    }

    protected Object getDescriptionImpl(String string) {
        if ("Name".equals(string)) {
            return IO.toPath((String)this.getName());
        }
        Object object = super.getDescriptionImpl(string);
        return "Icon".equals(string) ? UI.getIcon((String)this.getName(), (String)this.mimeType.getMediaType(), (IconSource)((IconSource)object), (RegistryContext)this, (boolean)true) : object;
    }

    public Object invoke(Context context, String string, Object object) {
        return null;
    }

    public void show(Context context) {
        this.show(context, null);
    }

    public void show(Context context, String string) {
        MimeTypeItem mimeTypeItem = this.getMimeTypeItem();
        if (mimeTypeItem != null) {
            if (this.editable && mimeTypeItem.isEditable()) {
                TextEditor textEditor;
                Panel[] panelArray = context.getWindow().getPanels((ObjectToBoolean)this);
                for (int i = 0; i < panelArray.length; ++i) {
                    textEditor = (TextEditor)panelArray[i];
                    if (!Utils.isContained((Object)this.getName(), (Object[])textEditor.getDocuments())) continue;
                    textEditor.openDocument(this.getName(), string);
                    textEditor.show(false, null);
                    return;
                }
                textEditor = panelArray.length > 0 ? (TextEditor)panelArray[0] : (TextEditor)PanelFactory.createPanel((Context)context, (String)"/ui/panels/texteditor", null);
                textEditor.openDocument(this.getName(), string);
                textEditor.show(false, null);
            } else if (mimeTypeItem.isViewable()) {
                context.getWorkbench().showViewerPanel(this.getName(), this.getName(), (Map)this);
            }
        }
    }

    public void showLater(Context context) {
        UI.getJobManager((Context)context).runLater(new Command(){

            public void run(Object object, Context context) {
                MTGSourceFile.this.show(context, null);
            }

            public String getCommandName() {
                return null;
            }
        }, null, context, 10000);
    }

    public boolean isAvailable(Context context) {
        return true;
    }

    public boolean isEnabled(Context context) {
        return true;
    }

    public int getUINodeType() {
        return 8;
    }

    public boolean evaluateBoolean(Object object) {
        return object instanceof TextEditor;
    }

    public void addRequiredFiles(Collection collection) {
        Object object = this.getRegistry().getProjectFile(this.getName());
        if (object != null) {
            collection.add(object);
        }
    }

    public static MTGSourceFile get(RegistryContext registryContext, String string) {
        Item item = registryContext.getRegistry().getItem("/project/objects/files");
        return item != null ? (MTGSourceFile)item.getItem((CharSequence)string) : null;
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (FileSystem.isContainedInChildren((Object)this.getRegistry().getProjectFile(this.getName()), (TreeModelEvent)treeModelEvent)) {
            MTGSourceFile.refresh((Item)this.getAxisParent(), this, this.deactivationCategory, new Command(){

                public String getCommandName() {
                    return null;
                }

                public void run(Object object, Context context) {
                    try {
                        FileSource fileSource;
                        MTGSourceFile.this.getRegistry().getProjectGraph().removeAllFromExtent();
                        Node node = null;
                        if (MTGSourceFile.this.mtgFilter == null) {
                            fileSource = MTGSourceFile.this.toFileSource();
                            MTGSourceFile.this.mtgFilter = new MTGFilter(fileSource);
                            if (MTGSourceFile.this.mtgFilter == null) {
                                return;
                            }
                            node = (Node)MTGSourceFile.this.mtgFilter.getObject(fileSource);
                        } else {
                            node = (Node)MTGSourceFile.this.mtgFilter.getObject();
                        }
                        if (node != null) {
                            MTGSourceFile.this.getRegistry().setEmptyGraph();
                            ((Node)MTGSourceFile.this.getRegistry().getProjectGraph().getRoot("MainGraph")).appendBranchNode(node);
                            Runtime.INSTANCE.setCurrentGraph(MTGSourceFile.this.getRegistry().getProjectGraph());
                            fileSource = View3D.getDefaultView((Context)context);
                            if (fileSource != null) {
                                fileSource.repaint();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (Utils.getBoolean((Map)UI.getOptions((Context)context), (Object)"saveProjectOnFileModification")) {
                        context.getWorkbench().save(false);
                    }
                }
            });
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public static void refresh(final Item item, final MTGSourceFile mTGSourceFile, final String string, final Command command) {
        Workbench workbench = Workbench.get((RegistryContext)item);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Deactivator
        extends LockProtectedCommand
        implements ItemVisitor {
            Deactivator(Workbench workbench) {
                super((Lockable)workbench.getRegistry().getProjectGraph(), true, 10000);
            }

            public String getCommandName() {
                return null;
            }

            protected void runImpl(Object object, Context context, Lock lock) {
                item.forAll(null, null, (ItemVisitor)this, null, false);
                item.getRegistry().activateItems();
                if (command != null) {
                    UI.getJobManager((Context)context).runLater(command, object, context, 70536);
                }
            }

            public void visit(Item item2, Object object) {
                if (!item2.isActivated() || !(item2 instanceof MTGSourceFile)) {
                    return;
                }
                if (item2 == mTGSourceFile || ((MTGSourceFile)item2).activationStamp == -1 || string != null && item2 instanceof MTGSourceFile && string.equals(((MTGSourceFile)item2).deactivationCategory)) {
                    item2.deactivate();
                }
            }
        }
        workbench.getJobManager().runLater((Command)new Deactivator(workbench), null, (Context)workbench, 10000);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new MTGSourceFile();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)mimeType$FIELD);
        editable$FIELD = new _Field("editable", 0x200000, Type.BOOLEAN, null, 1);
        $TYPE.addManagedField((ManageableType.Field)editable$FIELD);
        disabled$FIELD = new _Field("disabled", 0x200000, Type.BOOLEAN, null, 2);
        $TYPE.addManagedField((ManageableType.Field)disabled$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setBoolean(Object object, boolean bl) {
            switch (this.id) {
                case 1: {
                    ((MTGSourceFile)object).editable = bl;
                    return;
                }
                case 2: {
                    ((MTGSourceFile)object).disabled = bl;
                    return;
                }
            }
            super.setBoolean(object, bl);
        }

        public boolean getBoolean(Object object) {
            switch (this.id) {
                case 1: {
                    return ((MTGSourceFile)object).isEditable();
                }
                case 2: {
                    return ((MTGSourceFile)object).isDisabled();
                }
            }
            return super.getBoolean(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((MTGSourceFile)object).mimeType = (MimeType)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((MTGSourceFile)object).mimeType;
                }
            }
            return super.getObject(object);
        }
    }

    public static class Loader
    extends FilterBase
    implements ObjectSource,
    ProjectLoader {
        Registry m_registry;
        MTGSourceFile m_sourceFile;
        private Node rootNode = null;
        private MTGFilter filter = null;

        public Loader(FilterItem filterItem, FilterSource filterSource) {
            super(filterItem, filterSource);
            this.setFlavor(IOFlavor.PROJECT_LOADER);
        }

        public Object getObject() {
            return this;
        }

        public void loadRegistry(Registry registry) throws IOException {
            this.m_registry = registry;
            File file = ((FileSource)this.source).getInputFile();
            registry.initFileSystem((FileSystem)new LocalFileSystem("pfs", file.getParentFile()));
            registry.setEmptyGraph();
            this.filter = new MTGFilter(this.item, this.source);
            this.rootNode = (Node)this.filter.getObject();
            this.m_sourceFile = new MTGSourceFile(IO.toSystemId((FileSystem)registry.getFileSystem(), (Object)file), new MimeType("text/mtg", null));
            this.m_sourceFile.setMTGFilter(this.filter);
            registry.getDirectory("/project/objects/files", null).addUserItem((Item)this.m_sourceFile);
            Workbench workbench = Workbench.get((RegistryContext)registry);
            if (workbench != null) {
                Item item = this.item.getItem((CharSequence)"layout");
                if (item != null) {
                    item = item.resolveLink((RegistryContext)registry);
                }
                if (item != null) {
                    workbench.setProperty("initial-layout", (Object)item.getAbsoluteName());
                    this.m_sourceFile.showLater((Context)workbench);
                }
            }
            workbench.setProperty(new String("scale count"), (Object)new Integer(3));
        }

        public void loadGraph(Registry registry) throws IOException {
            ((Node)registry.getProjectGraph().getRoot("MainGraph")).appendBranchNode(this.rootNode);
            Runtime.INSTANCE.setCurrentGraph(registry.getProjectGraph());
        }

        public void loadWorkbench(Workbench workbench) {
            workbench.setProperty(new String("scale count"), (Object)new Integer(3));
        }
    }
}

