/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg;

import de.grogra.graph.Attribute;
import de.grogra.graph.BooleanAttribute;
import de.grogra.graph.ByteAttribute;
import de.grogra.graph.CharAttribute;
import de.grogra.graph.DoubleAttribute;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.EdgePatternImpl;
import de.grogra.graph.FloatAttribute;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.IntAttribute;
import de.grogra.graph.LongAttribute;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.Path;
import de.grogra.graph.ShortAttribute;
import de.grogra.graph.Visitor;
import de.grogra.graph.VisitorImpl;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.IMP;
import de.grogra.imp.IMPWorkbench;
import de.grogra.imp.View;
import de.grogra.imp.objects.ImageRef;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.DisplayVisitor;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.ViewConfig3D;
import de.grogra.imp3d.VolumeAttribute;
import de.grogra.imp3d.objects.GRSVertex;
import de.grogra.imp3d.objects.GlobalTransformation;
import de.grogra.imp3d.objects.Matrix34dPair;
import de.grogra.imp3d.objects.NURBSCurve;
import de.grogra.imp3d.objects.NURBSSurface;
import de.grogra.imp3d.objects.Null;
import de.grogra.imp3d.objects.Parallelogram;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.objects.Transformation;
import de.grogra.imp3d.ray2.Raytracer;
import de.grogra.imp3d.shading.MaterialRef;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.ShaderRef;
import de.grogra.math.BSplineCurve;
import de.grogra.math.BSplineCurveList;
import de.grogra.math.BSplineSurface;
import de.grogra.math.TMatrix4d;
import de.grogra.math.TVector3d;
import de.grogra.math.Transform3D;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.Transaction;
import de.grogra.pf.data.DatasetRef;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.ObjectSourceImpl;
import de.grogra.pf.registry.ObjectItem;
import de.grogra.pf.ui.ChartPanel;
import de.grogra.pf.ui.Console;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.edit.GraphSelection;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.rgg.Attributes;
import de.grogra.rgg.BooleanNode;
import de.grogra.rgg.BooleanSynth;
import de.grogra.rgg.ByteNode;
import de.grogra.rgg.ByteSynth;
import de.grogra.rgg.CharNode;
import de.grogra.rgg.CharSynth;
import de.grogra.rgg.CurveRef;
import de.grogra.rgg.DoubleNode;
import de.grogra.rgg.DoubleSynth;
import de.grogra.rgg.FileRef;
import de.grogra.rgg.FloatNode;
import de.grogra.rgg.FloatSynth;
import de.grogra.rgg.FunctionRef;
import de.grogra.rgg.IntNode;
import de.grogra.rgg.IntSynth;
import de.grogra.rgg.Location;
import de.grogra.rgg.LongNode;
import de.grogra.rgg.LongSynth;
import de.grogra.rgg.NodeFilter;
import de.grogra.rgg.NodeToDouble;
import de.grogra.rgg.NodeToFloat;
import de.grogra.rgg.NodeToInt;
import de.grogra.rgg.ObjectNode;
import de.grogra.rgg.ObjectSynth;
import de.grogra.rgg.RGGRoot;
import de.grogra.rgg.Reference;
import de.grogra.rgg.ShortNode;
import de.grogra.rgg.ShortSynth;
import de.grogra.rgg.Statistics;
import de.grogra.rgg.SurfaceRef;
import de.grogra.rgg.model.PropertyQueue;
import de.grogra.rgg.model.RGGGraph;
import de.grogra.rgg.model.RGGProducer;
import de.grogra.rgg.model.Runtime;
import de.grogra.turtle.Tropism;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.WrapException;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.Matrix34d;
import de.grogra.vecmath.geom.Cone;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Volume;
import de.grogra.xl.impl.base.GraphQueue;
import de.grogra.xl.impl.queues.QueueDescriptor;
import de.grogra.xl.lang.Aggregate;
import de.grogra.xl.lang.DisposableIterator;
import de.grogra.xl.lang.DoubleConsumer;
import de.grogra.xl.lang.DoubleToDouble;
import de.grogra.xl.lang.FloatToFloat;
import de.grogra.xl.lang.IntToDouble;
import de.grogra.xl.lang.ObjectConsumer;
import de.grogra.xl.lang.ObjectToBoolean;
import de.grogra.xl.lang.ObjectToByte;
import de.grogra.xl.lang.ObjectToChar;
import de.grogra.xl.lang.ObjectToDouble;
import de.grogra.xl.lang.ObjectToFloat;
import de.grogra.xl.lang.ObjectToInt;
import de.grogra.xl.lang.ObjectToLong;
import de.grogra.xl.lang.ObjectToObject;
import de.grogra.xl.lang.ObjectToObjectGenerator;
import de.grogra.xl.lang.ObjectToShort;
import de.grogra.xl.util.BooleanList;
import de.grogra.xl.util.ByteList;
import de.grogra.xl.util.CharList;
import de.grogra.xl.util.DoubleList;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.LongList;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.util.Operators;
import de.grogra.xl.util.ShortList;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library {
    public static final int successor = 256;
    public static final int branch = 512;
    public static final int contains = 1024;
    public static final int refine = 4096;
    public static final int notifies = 16384;
    public static final int mark = 8192;
    public static final int updates = 129;
    public static final int master = 129;
    public static final int EDGE_0 = 131072;
    public static final int EDGE_1 = 262144;
    public static final int EDGE_2 = 524288;
    public static final int EDGE_3 = 0x100000;
    public static final int EDGE_4 = 0x200000;
    public static final int EDGE_5 = 0x400000;
    public static final int EDGE_6 = 0x800000;
    public static final int EDGE_7 = 0x1000000;
    public static final int EDGE_8 = 0x2000000;
    public static final int EDGE_9 = 0x4000000;
    public static final int EDGE_10 = 0x8000000;
    public static final int EDGE_11 = 0x10000000;
    public static final int EDGE_12 = 0x20000000;
    public static final int EDGE_13 = 0x40000000;
    public static final int EDGE_14 = Integer.MIN_VALUE;
    public static final byte SKIN = 0;
    public static final byte SWEEP = 1;
    public static final I18NBundle I18N = I18NBundle.getInstance(Library.class);
    public static final double DEG = Math.PI / 180;
    public static final double R2D = 57.29577951308232;
    public static final Vector3d LEFT = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d UP = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d HEAD = new Vector3d(0.0, 0.0, 1.0);
    public static final Point3d ORIGIN = new Point3d(0.0, 0.0, 0.0);
    public static final RGGProducer.Creator makeGraph = new RGGProducer.Creator();
    private static final HashMap<String, String> EXPORT_FORMAT_MAP = Library.createMap();
    private static final ThreadLocal<Locals> LOCALS = new ThreadLocal();
    public static final PrintWriter out = new PrintWriter(new Writer(){

        public void write(char[] cArray, int n, int n2) {
            Console console = Library.console();
            if (console != null) {
                console.getOut().write(cArray, n, n2);
                console.getOut().flush();
            } else {
                if (n != 0 || n2 != cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n2];
                    System.arraycopy(cArray2, n, cArray, 0, n2);
                }
                System.out.print(cArray);
            }
        }

        public void flush() {
            Console console = Library.console();
            if (console != null) {
                console.getOut().flush();
            } else {
                System.out.flush();
            }
        }

        public void close() {
        }
    });

    private static HashMap<String, String> createMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("dxf", "image/vnd.dxf");
        hashMap.put("x3d", "model/vnd.x3d");
        hashMap.put("mtg", "text/mtg");
        return hashMap;
    }

    private static Locals currentLocals() {
        Locals locals = LOCALS.get();
        if (locals == null) {
            locals = new Locals();
            LOCALS.set(locals);
        }
        return locals;
    }

    public static Console console() {
        Workbench workbench = Workbench.current();
        if (workbench != null) {
            return (Console)PanelFactory.getAndShowPanel((Context)workbench, (String)"/ui/panels/rgg/console", (Map)Map.EMPTY_MAP);
        }
        return null;
    }

    public static IMPWorkbench workbench() {
        return (IMPWorkbench)Workbench.current();
    }

    public static void closeWorkbench() {
        IMPWorkbench iMPWorkbench = Library.workbench();
        if (iMPWorkbench != null) {
            iMPWorkbench.ignoreIfModified();
            IMP.closeWorkbench((Context)iMPWorkbench);
        }
    }

    public static GraphManager graph() {
        IMPWorkbench iMPWorkbench = Library.workbench();
        return iMPWorkbench != null ? iMPWorkbench.getRegistry().getProjectGraph() : null;
    }

    public static GraphState graphState() {
        return GraphState.current((Graph)Library.graph());
    }

    @Deprecated
    public static RGGGraph extent() {
        return Library.rggGraph();
    }

    public static RGGGraph rggGraph() {
        return Runtime.INSTANCE.currentGraph();
    }

    public static void allowNoninjectiveMatchesByDefault(boolean bl) {
        Library.rggGraph().allowNoninjectiveMatchesByDefault(bl);
    }

    @Deprecated
    public static void allowNoninjectiveMatchesForNextQuery(boolean bl) {
        Library.rggGraph().allowNoninjectiveMatchesForNextQuery(bl);
    }

    public static void setDerivationMode(int n) {
        Library.rggGraph().setDerivationMode(n);
    }

    public static void undo() {
        Library.workbench().undo();
    }

    public static Node namedNode(String string) {
        return Library.graph().getNodeForName(string);
    }

    public static void setStatus(String string) {
        Workbench workbench = Workbench.current();
        if (workbench != null) {
            workbench.beginStatus(null);
            workbench.setStatus(null, string);
        }
    }

    public static void chart(DatasetRef datasetRef, int n) {
        ChartPanel chartPanel = Library.workbench().getChartPanel(datasetRef.getName(), null);
        if (chartPanel != null) {
            chartPanel.setChart(datasetRef.resolve(), n, null);
            chartPanel.show(false, null);
        }
    }

    public static Node axisparent(Node node) {
        return node.getAxisParent();
    }

    public static boolean isAncestor(Node node, Node node2, int n) {
        block0: while (node2 != node) {
            for (Edge edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                Node node3 = edge.getSource();
                if (node3 == node2 || !edge.testEdgeBits(n)) continue;
                node2 = node3;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static int irandom(int n, int n2) {
        return Operators.getRandomGenerator().nextInt(n2 + 1 - n) + n;
    }

    public static float random(float f, float f2) {
        return Operators.getRandomGenerator().nextFloat() * (f2 - f) + f;
    }

    public static boolean probability(float f) {
        return f >= 1.0f || Operators.getRandomGenerator().nextFloat() < f;
    }

    public static float normal(float f, float f2) {
        return f + f2 * (float)Operators.getRandomGenerator().nextGaussian();
    }

    public static double lognormal(double d, double d2) {
        double d3 = d2 / d;
        double d4 = Math.log1p(d3 * d3);
        return d * Math.exp(-0.5 * d4 + Math.sqrt(d4) * Operators.getRandomGenerator().nextGaussian());
    }

    public static double normal(double d, double d2) {
        return d + d2 * Operators.getRandomGenerator().nextGaussian();
    }

    public static int distribution(float[] fArray) {
        float f = Operators.getRandomGenerator().nextFloat();
        int n = fArray.length - 1;
        for (int i = 0; i < n; ++i) {
            float f2;
            f -= fArray[i];
            if (!(f2 <= 0.0f)) continue;
            return i;
        }
        return n;
    }

    public static void setSeed(long l) {
        Operators.getRandomGenerator().setSeed(l);
    }

    public static <C extends Node> C ancestor(Node node, Class<C> clazz) {
        while (true) {
            Node node2 = null;
            for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                if (!edge.testEdgeBits(768) || !edge.isTarget(node)) continue;
                node2 = edge.getSource();
                break;
            }
            if (node2 == null || clazz.isInstance(node2)) {
                return (C)((Node)clazz.cast(node2));
            }
            node = node2;
        }
    }

    public static <T> Node minDescendants(ObjectConsumer<? super T> objectConsumer, Node node, Class<T> clazz) {
        for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
            Node node2 = edge.getTarget();
            if (node == node2 || !edge.testEdgeBits(768)) continue;
            if (clazz.isInstance(node2)) {
                objectConsumer.consume((Object)node2);
                continue;
            }
            Library.minDescendants(objectConsumer, node2, clazz);
        }
        return null;
    }

    public static Node ancestor(Node node, ObjectToBoolean<? super Node> objectToBoolean) {
        while (true) {
            Node node2 = null;
            for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                if (!edge.testEdgeBits(768) || !edge.isTarget(node)) continue;
                node2 = edge.getSource();
                break;
            }
            if (node2 == null || objectToBoolean.evaluateBoolean(node2)) {
                return node2;
            }
            node = node2;
        }
    }

    public static Node successor(Node node, ObjectToBoolean<? super Node> objectToBoolean) {
        while (true) {
            Node node2 = null;
            for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                if (!edge.testEdgeBits(256) || !edge.isSource(node)) continue;
                node2 = edge.getTarget();
                break;
            }
            if (node2 == null || objectToBoolean.evaluateBoolean(node2)) {
                return node2;
            }
            node = node2;
        }
    }

    public static <T> Node descendants(ObjectConsumer<? super T> objectConsumer, Node node, Class<T> clazz) {
        ObjectList objectList = new ObjectList(100);
        objectList.push((Object)node);
        while (!objectList.isEmpty()) {
            node = (Node)objectList.pop();
            if (clazz.isInstance(node)) {
                objectConsumer.consume((Object)node);
            }
            for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                Node node2 = edge.getTarget();
                if (node2 == node || !edge.testEdgeBits(768)) continue;
                objectList.push((Object)node2);
            }
        }
        return null;
    }

    public static NodeFilter<Node> filter(final Class[] classArray, final boolean bl) {
        return new NodeFilter<Node>(){

            public boolean evaluateBoolean(Node node) {
                Class[] classArray2 = classArray;
                for (int i = classArray2.length - 1; i >= 0; --i) {
                    if (!classArray2[i].isInstance(node)) continue;
                    return bl;
                }
                return !bl;
            }
        };
    }

    public static Matrix34d transformation(Node node) {
        return GlobalTransformation.get((Object)node, (boolean)true, (GraphState)GraphState.current((Graph)node.getGraph()), (boolean)false);
    }

    public static Matrix34d transformation(Node node, boolean bl) {
        return GlobalTransformation.get((Object)node, (boolean)true, (GraphState)GraphState.current((Graph)node.getGraph()), (boolean)bl);
    }

    public static void location(Tuple3d tuple3d, Node node, boolean bl) {
        Matrix34d matrix34d = Library.transformation(node, bl);
        tuple3d.x = matrix34d.m03;
        tuple3d.y = matrix34d.m13;
        tuple3d.z = matrix34d.m23;
    }

    public static void direction(Tuple3d tuple3d, Node node, boolean bl) {
        Matrix34d matrix34d = Library.transformation(node, bl);
        tuple3d.x = matrix34d.m02;
        tuple3d.y = matrix34d.m12;
        tuple3d.z = matrix34d.m22;
    }

    public static Point3d location(Node node) {
        Point3d point3d = new Point3d();
        Library.location((Tuple3d)point3d, node, false);
        return point3d;
    }

    public static Point3d toPoint3d(Node node) {
        Point3d point3d = new Point3d();
        Library.location((Tuple3d)point3d, node, false);
        return point3d;
    }

    public static Tuple3d toTuple3d(Node node) {
        return Library.toPoint3d(node);
    }

    public static Vector3d direction(Node node) {
        Vector3d vector3d = new Vector3d();
        Library.direction((Tuple3d)vector3d, node, false);
        return vector3d;
    }

    public static Point3d endlocation(Node node) {
        Point3d point3d = new Point3d();
        Library.location((Tuple3d)point3d, node, true);
        return point3d;
    }

    public static Vector3d enddirection(Node node) {
        Vector3d vector3d = new Vector3d();
        Library.direction((Tuple3d)vector3d, node, true);
        return vector3d;
    }

    public static double angle(Node node) {
        double d;
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        Matrix3d matrix3d = new Matrix3d();
        GlobalTransformation.getParentValue((Object)node, (boolean)true, (GraphState)graphState, (boolean)true).getRotationScale(matrix3d);
        matrix3d.invert();
        Math2.lmul((Matrix3d)matrix3d, (Matrix34d)GlobalTransformation.get((Object)node, (boolean)true, (GraphState)graphState, (boolean)true));
        double d2 = matrix3d.m00 + matrix3d.m11 + matrix3d.m22;
        double d3 = matrix3d.determinant();
        if (d3 < 0.0) {
            d2 = -d2;
            d3 = -d3;
        }
        return (d = ((d2 *= Math.pow(d3, -0.3333333333333333)) - 1.0) * 0.5) >= 1.0 ? 0.0 : (d <= -1.0 ? 180.0 : Math.acos(d) * 57.29577951308232);
    }

    public static double inclination(Node node) {
        Matrix34d matrix34d = GlobalTransformation.get((Object)node, (boolean)true, (GraphState)GraphState.current((Graph)node.getGraph()), (boolean)true);
        double d = matrix34d.m22 / (matrix34d.m02 * matrix34d.m02 + matrix34d.m12 * matrix34d.m12 + matrix34d.m22 * matrix34d.m22);
        return d >= 1.0 ? 90.0 : (d <= -1.0 ? -90.0 : Math.asin(d) * 57.29577951308232);
    }

    public static double angle(Tuple3d tuple3d, Tuple3d tuple3d2) {
        double d = Math2.dot((Tuple3d)tuple3d, (Tuple3d)tuple3d) * Math2.dot((Tuple3d)tuple3d2, (Tuple3d)tuple3d2);
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = Math2.dot((Tuple3d)tuple3d, (Tuple3d)tuple3d2) / Math.sqrt(d);
        return d2 >= 1.0 ? 0.0 : (d2 <= -1.0 ? 180.0 : Math.acos(d2) * 57.29577951308232);
    }

    public static void setRandomTransform(Null nullVal, Transform3D transform3D, double d, double d2, double d3, double d4, double d5) {
        Random random;
        if (d2 >= d4 || d3 >= d5) {
            throw new IllegalArgumentException();
        }
        double d6 = 0.0;
        double d7 = 0.0;
        if (transform3D != null) {
            random = new Matrix4d();
            random.setIdentity();
            transform3D.transform((Matrix4d)random, (Matrix4d)random);
            d6 = ((Matrix4d)random).m03;
            d7 = ((Matrix4d)random).m13;
        }
        random = Operators.getRandomGenerator();
        double d8 = random.nextDouble() * (Math.PI * 2);
        d6 += Math.cos(d8) * (d *= random.nextGaussian());
        d7 += Math.sin(d8) * d;
        while (true) {
            if (d6 < d2) {
                d6 = 2.0 * d2 - d6;
                continue;
            }
            if (!(d6 > d4)) break;
            d6 = 2.0 * d4 - d6;
        }
        while (true) {
            if (d7 < d3) {
                d7 = 2.0 * d3 - d7;
                continue;
            }
            if (!(d7 > d5)) break;
            d7 = 2.0 * d5 - d7;
        }
        Null.transform$FIELD.setObject((Object)nullVal, null, (Object)new TVector3d(d6, d7, 0.0), nullVal.getGraph() != null ? nullVal.getGraph().getActiveTransaction() : null);
    }

    public static double distanceSquared(Node node, Node node2) {
        Matrix34d matrix34d = Library.transformation(node);
        double d = matrix34d.m03;
        double d2 = matrix34d.m13;
        double d3 = matrix34d.m23;
        matrix34d = Library.transformation(node2);
        double d4 = d - matrix34d.m03;
        double d5 = d4 * d4;
        d4 = d2 - matrix34d.m13;
        double d6 = d5 + d4 * d4;
        d4 = d3 - matrix34d.m23;
        return d6 + d4 * d4;
    }

    public static double distance(Node node, Node node2) {
        return Math.sqrt(Library.distanceSquared(node, node2));
    }

    public static Cone cone(Tuple3d tuple3d, Vector3d vector3d, double d) {
        Cone cone = new Cone();
        cone.setTransformation(tuple3d, (Tuple3d)vector3d);
        d = 1.0 / Math.tan(d * (Math.PI / 180));
        cone.scale(d, d, 1.0);
        cone.base = Double.POSITIVE_INFINITY;
        return cone;
    }

    public static Cone cone(Node node, boolean bl, double d) {
        Matrix34d matrix34d = Library.transformation(node, bl);
        return Library.cone((Tuple3d)new Point3d(matrix34d.m03, matrix34d.m13, matrix34d.m23), new Vector3d(matrix34d.m02, matrix34d.m12, matrix34d.m22), d);
    }

    public static Line ray(Tuple3d tuple3d, Tuple3d tuple3d2) {
        Line line = new Line();
        line.origin.set(tuple3d);
        line.direction.set(tuple3d2);
        line.start = 0.0;
        line.end = Double.POSITIVE_INFINITY;
        return line;
    }

    public static IntersectionList intersect(Line line, Volume volume) {
        IntersectionList intersectionList = Library.currentLocals().ilist;
        intersectionList.setSize(0);
        volume.computeIntersections(line, 0, intersectionList, null, null);
        return intersectionList;
    }

    public static IntersectionList operator$and(Line line, Volume volume) {
        return Library.intersect(line, volume);
    }

    public static Point3d toPoint3d(IntersectionList intersectionList) {
        return intersectionList.size > 0 ? new Point3d(intersectionList.elements[0].getPoint()) : null;
    }

    public static double height(Volume volume, double d, double d2) {
        Locals locals = Library.currentLocals();
        Line line = locals.line;
        line.origin.set(d, d2, 0.0);
        line.direction.set(0.0, 0.0, -1.0);
        line.start = -1.7976931348623157E308;
        line.end = Double.MAX_VALUE;
        IntersectionList intersectionList = locals.ilist;
        intersectionList.setSize(0);
        volume.computeIntersections(line, 1, intersectionList, null, null);
        return intersectionList.size > 0 ? intersectionList.elements[0].getPoint().z : 0.0;
    }

    public static Line toLine(Node node) {
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        Matrix34dPair matrix34dPair = (Matrix34dPair)GlobalTransformation.ATTRIBUTE.get((Object)node, true, graphState);
        Matrix34d matrix34d = matrix34dPair.get(false);
        Matrix34d matrix34d2 = matrix34dPair.get(true);
        Point3d point3d = new Point3d(matrix34d.m03, matrix34d.m13, matrix34d.m23);
        Vector3d vector3d = new Vector3d(matrix34d2.m03, matrix34d2.m13, matrix34d2.m23);
        vector3d.sub((Tuple3d)point3d);
        return new Line((Tuple3d)point3d, vector3d, 0.0, 1.0);
    }

    public static Volume volume(Node node) {
        return VolumeAttribute.getVolume((Object)node, (boolean)true, (GraphState)Library.graphState());
    }

    public static double distanceToLine(Tuple3d tuple3d, Line line) {
        return line.distance(tuple3d);
    }

    public static double intersectionLength(Line line, Cone cone) {
        double d = line.end - line.start;
        return cone.intersect(line) ? (line.end - line.start) / d : 0.0;
    }

    public static boolean directionalTropism(Matrix34d matrix34d, Tuple3d tuple3d, float f, Matrix4d matrix4d) {
        Vector3d vector3d = new Vector3d(tuple3d.z * matrix34d.m12 - tuple3d.y * matrix34d.m22, tuple3d.x * matrix34d.m22 - tuple3d.z * matrix34d.m02, tuple3d.y * matrix34d.m02 - tuple3d.x * matrix34d.m12);
        if ((double)((f = (float)((double)f * Math.sqrt(vector3d.lengthSquared() / (matrix34d.m02 * matrix34d.m02 + matrix34d.m12 * matrix34d.m12 + matrix34d.m22 * matrix34d.m22)))) * f) >= 1.0E-20) {
            Math2.invTransformVector((Matrix34d)matrix34d, (Tuple3d)vector3d);
            matrix4d.set(new AxisAngle4d(vector3d, (double)f));
            return true;
        }
        return false;
    }

    public static boolean positionalTropism(Matrix34d matrix34d, Tuple3d tuple3d, float f, Matrix4d matrix4d) {
        Vector3d vector3d;
        double d = tuple3d.x - matrix34d.m03;
        double d2 = tuple3d.y - matrix34d.m13;
        double d3 = tuple3d.z - matrix34d.m23;
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 > 0.0 && (double)((f = (float)((double)f * Math.sqrt((vector3d = new Vector3d(d3 * matrix34d.m12 - d2 * matrix34d.m22, d * matrix34d.m22 - d3 * matrix34d.m02, d2 * matrix34d.m02 - d * matrix34d.m12)).lengthSquared() / (d4 * (matrix34d.m02 * matrix34d.m02 + matrix34d.m12 * matrix34d.m12 + matrix34d.m22 * matrix34d.m22))))) * f) >= 1.0E-20) {
            Math2.invTransformVector((Matrix34d)matrix34d, (Tuple3d)vector3d);
            matrix4d.set(new AxisAngle4d(vector3d, (double)f));
            return true;
        }
        return false;
    }

    public static boolean orthogonalTropism(Matrix34d matrix34d, Tuple3d tuple3d, float f, Matrix4d matrix4d) {
        Vector3d vector3d = new Vector3d(tuple3d.z * matrix34d.m12 - tuple3d.y * matrix34d.m22, tuple3d.x * matrix34d.m22 - tuple3d.z * matrix34d.m02, tuple3d.y * matrix34d.m02 - tuple3d.x * matrix34d.m12);
        if ((double)((f = (float)((double)f * (-(matrix34d.m02 * tuple3d.x + matrix34d.m12 * tuple3d.y + matrix34d.m22 * tuple3d.z) / Math.sqrt(matrix34d.m02 * matrix34d.m02 + matrix34d.m12 * matrix34d.m12 + matrix34d.m22 * matrix34d.m22)))) * f) >= 1.0E-20) {
            Math2.invTransformVector((Matrix34d)matrix34d, (Tuple3d)vector3d);
            matrix4d.set(new AxisAngle4d(vector3d, (double)f));
            return true;
        }
        return false;
    }

    public static Null tropism(Node node, Vector3d vector3d, float f) {
        TMatrix4d tMatrix4d = new TMatrix4d();
        return Library.directionalTropism(Library.transformation(node, true), (Tuple3d)vector3d, f, (Matrix4d)tMatrix4d) ? new Null((Transform3D)tMatrix4d) : new Null();
    }

    public static Null tropism(Node node, Point3d point3d, float f) {
        TMatrix4d tMatrix4d = new TMatrix4d();
        return Library.positionalTropism(Library.transformation(node, true), (Tuple3d)point3d, f, (Matrix4d)tMatrix4d) ? new Null((Transform3D)tMatrix4d) : new Null();
    }

    public static Node cloneSubgraph(Node node) throws CloneNotSupportedException {
        return node.cloneGraph((EdgePattern)EdgePatternImpl.FORWARD, true);
    }

    public static Node cloneNode(Node node) throws CloneNotSupportedException {
        return node.clone(true);
    }

    public static boolean booleanValue(Node node) {
        return node instanceof BooleanNode ? ((BooleanNode)node).getValue() : false;
    }

    public static byte byteValue(Node node) {
        return node instanceof ByteNode ? ((ByteNode)node).getValue() : (byte)0;
    }

    public static short shortValue(Node node) {
        return node instanceof ShortNode ? ((ShortNode)node).getValue() : (short)0;
    }

    public static char charValue(Node node) {
        return node instanceof CharNode ? ((CharNode)node).getValue() : (char)'\u0000';
    }

    public static int intValue(Node node) {
        return node instanceof IntNode ? ((IntNode)node).getValue() : 0;
    }

    public static long longValue(Node node) {
        return node instanceof LongNode ? ((LongNode)node).getValue() : 0L;
    }

    public static float floatValue(Node node) {
        return node instanceof FloatNode ? ((FloatNode)node).getValue() : 0.0f;
    }

    public static double doubleValue(Node node) {
        return node instanceof DoubleNode ? ((DoubleNode)node).getValue() : 0.0;
    }

    public static Object objectValue(Node node) {
        return node instanceof ObjectNode ? ((ObjectNode)node).getValue() : (node instanceof NURBSCurve ? ((NURBSCurve)node).getCurve() : (node instanceof NURBSSurface ? ((NURBSSurface)node).getSurface() : null));
    }

    public static boolean isSelected(Node node) {
        Workbench workbench = Workbench.current();
        if (workbench != null) {
            Object object = UIProperty.WORKBENCH_SELECTION.getValue((Context)workbench);
            return object instanceof GraphSelection && ((GraphSelection)object).contains((Graph)node.getGraph(), (Object)node, true);
        }
        return false;
    }

    public static FunctionRef function(String string) {
        return new FunctionRef(string);
    }

    public static CurveRef curve(String string) {
        return new CurveRef(string);
    }

    public static SurfaceRef surface(String string) {
        return new SurfaceRef(string);
    }

    public static DatasetRef dataset(String string) {
        return new DatasetRef(string);
    }

    public static ShaderRef shader(String string) {
        return new ShaderRef(string);
    }

    public static ImageRef image(String string) {
        return new ImageRef(string);
    }

    @Deprecated
    public static MaterialRef material(String string) {
        System.err.println("material(String) is deprecated, use shader(String) instead");
        return new MaterialRef(string);
    }

    public static FileRef file(String string) {
        if (string.indexOf(47) < 0 && string.indexOf(58) < 0) {
            string = "pfs:" + string;
        }
        return new FileRef(string);
    }

    public static Reference reference(String string) {
        return new Reference(string);
    }

    public static void makeRenderedImage(String string) {
        Library.makeRenderedImage(string, 800, 600);
    }

    public static void makeRenderedImage(String string, int n, int n2) {
        Raytracer raytracer = new Raytracer((Workbench)Library.workbench(), n, n2);
        try {
            IMP.writeImage((Image)raytracer.computeImage(), (File)new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void makeRenderedImage(String string, String string2, int n, int n2) {
        ViewConfig3D viewConfig3D = View3D.getDefaultViewConfig((Context)Library.workbench());
        viewConfig3D = View3D.withCamera((ViewConfig3D)viewConfig3D, (Camera)((Camera)((ObjectItem)Library.workbench().getRegistry().getItem("/project/objects/3d/cameras/" + string2)).getObject()));
        Raytracer raytracer = new Raytracer((Workbench)Library.workbench(), viewConfig3D, n, n2);
        try {
            IMP.writeImage((Image)raytracer.computeImage(), (File)new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void makeRenderedImage(String string, Camera camera, int n, int n2) {
        ViewConfig3D viewConfig3D = View3D.getDefaultViewConfig((Context)Library.workbench());
        viewConfig3D = View3D.withCamera((ViewConfig3D)viewConfig3D, (Camera)camera);
        Raytracer raytracer = new Raytracer((Workbench)Library.workbench(), viewConfig3D, n, n2);
        try {
            IMP.writeImage((Image)raytracer.computeImage(), (File)new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void makeSnapshot(final String string) {
        View3D view3D = View3D.getDefaultView((Context)Library.workbench());
        view3D.getViewComponent().makeSnapshot(new ObjectConsumer(){

            public void consume(Object object) {
                IMP.writeImage((Image)((Image)object), (File)new File(string));
            }
        });
    }

    public static void export3DScene(String string, String string2) {
        Library.export3DScene(new File(string), string2);
    }

    public static void export3DScene(File file, String string) {
        View view = (View)View3D.getDefaultView((Context)Library.workbench()).getPanel();
        Library.workbench().export((FilterSource)new ObjectSourceImpl((Object)view, "view", view.getFlavor(), view.getWorkbench().getRegistry().getRootRegistry(), null), new MimeType(EXPORT_FORMAT_MAP.get(string.toLowerCase()), null), file);
    }

    public static Parallelogram leaf(float f, float f2) {
        Parallelogram parallelogram = new Parallelogram(f, f2);
        parallelogram.setShader((Shader)RGBAShader.GREEN);
        return parallelogram;
    }

    @Deprecated
    public static NURBSSurface Surface(BSplineSurface bSplineSurface) {
        return new NURBSSurface(bSplineSurface);
    }

    @Deprecated
    public static NURBSSurface Surface(BSplineCurve bSplineCurve) {
        return new NURBSSurface(bSplineCurve);
    }

    @Deprecated
    public static NURBSSurface Surface(float f) {
        return new NURBSSurface(f);
    }

    @Deprecated
    public static NURBSSurface Surface(byte by) {
        return new NURBSSurface(by);
    }

    @Deprecated
    public static NURBSSurface Surface(BSplineCurveList bSplineCurveList) {
        return new NURBSSurface(bSplineCurveList);
    }

    @Deprecated
    public static NURBSSurface Surface(BSplineCurve bSplineCurve, String string, boolean bl) {
        return new NURBSSurface(bSplineCurve, string, bl);
    }

    @Deprecated
    public static NURBSSurface Surface(byte by, String string, boolean bl) {
        return new NURBSSurface(by, string, bl);
    }

    public static RGBAShader visualizeAsColor(double d) {
        return d > 0.0 ? new RGBAShader(1.0f - (float)d, 1.0f, 1.0f - (float)d) : new RGBAShader(1.0f, 1.0f + (float)d, 1.0f + (float)d);
    }

    public static void print(Object object, int n) {
        Console console = Library.console();
        if (console != null) {
            console.getOut().print(object, n);
        } else {
            System.out.print(object);
        }
    }

    public static void print(Object object) {
        Console console = Library.console();
        if (console != null) {
            console.getOut().print(object, 192);
        } else {
            System.out.print(object);
        }
    }

    public static void println(Object object, int n) {
        Console console = Library.console();
        if (console != null) {
            console.getOut().println(object, n);
        } else {
            System.out.println(object);
        }
    }

    public static void println(Object object) {
        Console console = Library.console();
        if (console != null) {
            console.getOut().println(object, 192);
        } else {
            System.out.println(object);
        }
    }

    public static void clearConsole() {
        Console console = Library.console();
        console.clear();
    }

    public static double getTimeForRepaint() {
        long l = System.nanoTime();
        View3D.getDefaultView((Context)Library.workbench()).repaint();
        return (double)(System.nanoTime() - l) * 1.0E-6;
    }

    public static double getTimeForTraversingGraph() {
        DoNothingVisitor doNothingVisitor = new DoNothingVisitor();
        doNothingVisitor.init(Library.graphState());
        long l = System.nanoTime();
        Library.graph().accept(null, (Visitor)doNothingVisitor, null);
        return (double)(System.nanoTime() - l) * 1.0E-6;
    }

    public static int getGraphSize() {
        return Library.workbench().getRegistry().getProjectGraph().getGraphSize();
    }

    public static int getSceneGraphSize() {
        GraphManager graphManager = Library.workbench().getRegistry().getProjectGraph();
        HashMap<Node, String> hashMap = new HashMap<Node, String>();
        ObjectList objectList = new ObjectList();
        Library.getListOfNodes(graphManager.getRoot(), null, false, hashMap, (ObjectList<Node>)objectList);
        int n = 0;
        for (Node node : hashMap.keySet()) {
            if (!(node instanceof ShadedNull)) continue;
            ++n;
        }
        return n;
    }

    private static void getListOfNodes(Node node, Edge edge, boolean bl, HashMap<Node, String> hashMap, ObjectList<Node> objectList) {
        String string = hashMap.get(node);
        if (string == null) {
            int n = 0;
            int n2 = 0;
            for (Edge edge2 = node.getFirstEdge(); edge2 != null; edge2 = edge2.getNext(node)) {
                if (edge2.isSource(node)) {
                    ++n2;
                    continue;
                }
                if (edge2 == edge) continue;
                ++n;
            }
            string = n == 0 ? "" : "n" + hashMap.size();
            hashMap.put(node, string);
            for (int i = 0; i < 2; ++i) {
                for (Edge edge3 = node.getFirstEdge(); edge3 != null; edge3 = edge3.getNext(node)) {
                    if (i == 0 != (edge3.getEdgeBits() == 512) || !edge3.isSource(node)) continue;
                    objectList.add((Object)node);
                    Library.getListOfNodes(edge3.getTarget(), edge3, n2 > 0, hashMap, objectList);
                }
            }
        }
    }

    public static PrintWriter operator$shl(PrintWriter printWriter, Object object) {
        printWriter.print(object);
        return printWriter;
    }

    public static void println() {
        Library.println("");
    }

    public static void print(boolean bl) {
        Library.print(String.valueOf(bl));
    }

    public static void println(boolean bl) {
        Library.println(String.valueOf(bl));
    }

    public static PrintWriter operator$shl(PrintWriter printWriter, boolean bl) {
        printWriter.print(bl);
        return printWriter;
    }

    public static void print(char c) {
        Library.print(String.valueOf(c));
    }

    public static void println(char c) {
        Library.println(String.valueOf(c));
    }

    public static PrintWriter operator$shl(PrintWriter printWriter, char c) {
        printWriter.print(c);
        return printWriter;
    }

    public static void print(int n) {
        Library.print(String.valueOf(n));
    }

    public static void println(int n) {
        Library.println(String.valueOf(n));
    }

    public static PrintWriter operator$shl(PrintWriter printWriter, int n) {
        printWriter.print(n);
        return printWriter;
    }

    public static void print(long l) {
        Library.print(String.valueOf(l));
    }

    public static void println(long l) {
        Library.println(String.valueOf(l));
    }

    public static PrintWriter operator$shl(PrintWriter printWriter, long l) {
        printWriter.print(l);
        return printWriter;
    }

    public static void print(float f) {
        Library.print(String.valueOf(f));
    }

    public static void println(float f) {
        Library.println(String.valueOf(f));
    }

    public static PrintWriter operator$shl(PrintWriter printWriter, float f) {
        printWriter.print(f);
        return printWriter;
    }

    public static void print(double d) {
        Library.print(String.valueOf(d));
    }

    public static void println(double d) {
        Library.println(String.valueOf(d));
    }

    public static PrintWriter operator$shl(PrintWriter printWriter, double d) {
        printWriter.print(d);
        return printWriter;
    }

    public static float operator$index(FloatToFloat floatToFloat, float f) {
        return floatToFloat.evaluateFloat(f);
    }

    public static <E> List<E> operator$shl(List<E> list, E e) {
        list.add(e);
        return list;
    }

    public static <T> T operator$index(Node node, ObjectAttribute<T> objectAttribute) {
        return (T)node.getCurrentGraphState().getObject((Object)node, true, objectAttribute);
    }

    public static <T> boolean operator$in(T t, Collection<? super T> collection) {
        return collection != null && collection.contains(t);
    }

    public static <T> boolean synthesize(T t, ObjectToObjectGenerator<? super T, ? extends T> objectToObjectGenerator, ObjectToBoolean<BooleanSynth<? super T>> objectToBoolean) {
        ObjectList objectList = new ObjectList(100);
        BooleanList booleanList = new BooleanList();
        objectList.push(t);
        BooleanSynth booleanSynth = new BooleanSynth();
        booleanSynth.valuesList = booleanList;
        while (!objectList.isEmpty()) {
            int n;
            Object object = objectList.peek(1);
            if (object instanceof Node) {
                objectList.push(null);
                n = objectList.size();
                objectToObjectGenerator.evaluateObject((ObjectConsumer)objectList, object);
                objectList.set(n - 1, (Object)(objectList.size() - n));
                continue;
            }
            objectList.pop();
            booleanSynth.object = objectList.pop();
            booleanSynth.startIndex = booleanList.size - (Integer)object;
            n = objectToBoolean.evaluateBoolean(booleanSynth) ? 1 : 0;
            booleanList.setSize(booleanSynth.startIndex);
            booleanList.add(n != 0);
        }
        assert (booleanList.size == 1);
        return booleanList.pop();
    }

    public static <T> byte synthesize(T t, ObjectToObjectGenerator<? super T, ? extends T> objectToObjectGenerator, ObjectToByte<ByteSynth<? super T>> objectToByte) {
        ObjectList objectList = new ObjectList(100);
        ByteList byteList = new ByteList();
        objectList.push(t);
        ByteSynth byteSynth = new ByteSynth();
        byteSynth.valuesList = byteList;
        while (!objectList.isEmpty()) {
            byte by;
            Object object = objectList.peek(1);
            if (object instanceof Node) {
                objectList.push(null);
                by = objectList.size();
                objectToObjectGenerator.evaluateObject((ObjectConsumer)objectList, object);
                objectList.set(by - 1, (Object)(objectList.size() - by));
                continue;
            }
            objectList.pop();
            byteSynth.object = objectList.pop();
            byteSynth.startIndex = byteList.size - (Integer)object;
            by = objectToByte.evaluateByte(byteSynth);
            byteList.setSize(byteSynth.startIndex);
            byteList.add(by);
        }
        assert (byteList.size == 1);
        return byteList.pop();
    }

    public static <T> short synthesize(T t, ObjectToObjectGenerator<? super T, ? extends T> objectToObjectGenerator, ObjectToShort<ShortSynth<? super T>> objectToShort) {
        ObjectList objectList = new ObjectList(100);
        ShortList shortList = new ShortList();
        objectList.push(t);
        ShortSynth shortSynth = new ShortSynth();
        shortSynth.valuesList = shortList;
        while (!objectList.isEmpty()) {
            short s;
            Object object = objectList.peek(1);
            if (object instanceof Node) {
                objectList.push(null);
                s = objectList.size();
                objectToObjectGenerator.evaluateObject((ObjectConsumer)objectList, object);
                objectList.set(s - 1, (Object)(objectList.size() - s));
                continue;
            }
            objectList.pop();
            shortSynth.object = objectList.pop();
            shortSynth.startIndex = shortList.size - (Integer)object;
            s = objectToShort.evaluateShort(shortSynth);
            shortList.setSize(shortSynth.startIndex);
            shortList.add(s);
        }
        assert (shortList.size == 1);
        return shortList.pop();
    }

    public static <T> char synthesize(T t, ObjectToObjectGenerator<? super T, ? extends T> objectToObjectGenerator, ObjectToChar<CharSynth<? super T>> objectToChar) {
        ObjectList objectList = new ObjectList(100);
        CharList charList = new CharList();
        objectList.push(t);
        CharSynth charSynth = new CharSynth();
        charSynth.valuesList = charList;
        while (!objectList.isEmpty()) {
            char c;
            Object object = objectList.peek(1);
            if (object instanceof Node) {
                objectList.push(null);
                c = objectList.size();
                objectToObjectGenerator.evaluateObject((ObjectConsumer)objectList, object);
                objectList.set(c - 1, (Object)(objectList.size() - c));
                continue;
            }
            objectList.pop();
            charSynth.object = objectList.pop();
            charSynth.startIndex = charList.size - (Integer)object;
            c = objectToChar.evaluateChar(charSynth);
            charList.setSize(charSynth.startIndex);
            charList.add(c);
        }
        assert (charList.size == 1);
        return charList.pop();
    }

    public static <T> int synthesize(T t, ObjectToObjectGenerator<? super T, ? extends T> objectToObjectGenerator, ObjectToInt<IntSynth<? super T>> objectToInt) {
        ObjectList objectList = new ObjectList(100);
        IntList intList = new IntList();
        objectList.push(t);
        IntSynth intSynth = new IntSynth();
        intSynth.valuesList = intList;
        while (!objectList.isEmpty()) {
            int n;
            Object object = objectList.peek(1);
            if (object instanceof Node) {
                objectList.push(null);
                n = objectList.size();
                objectToObjectGenerator.evaluateObject((ObjectConsumer)objectList, object);
                objectList.set(n - 1, (Object)(objectList.size() - n));
                continue;
            }
            objectList.pop();
            intSynth.object = objectList.pop();
            intSynth.startIndex = intList.size - (Integer)object;
            n = objectToInt.evaluateInt(intSynth);
            intList.setSize(intSynth.startIndex);
            intList.add(n);
        }
        assert (intList.size == 1);
        return intList.pop();
    }

    public static <T> long synthesize(T t, ObjectToObjectGenerator<? super T, ? extends T> objectToObjectGenerator, ObjectToLong<LongSynth<? super T>> objectToLong) {
        ObjectList objectList = new ObjectList(100);
        LongList longList = new LongList();
        objectList.push(t);
        LongSynth longSynth = new LongSynth();
        longSynth.valuesList = longList;
        while (!objectList.isEmpty()) {
            Object object = objectList.peek(1);
            if (object instanceof Node) {
                objectList.push(null);
                int n = objectList.size();
                objectToObjectGenerator.evaluateObject((ObjectConsumer)objectList, object);
                objectList.set(n - 1, (Object)(objectList.size() - n));
                continue;
            }
            objectList.pop();
            longSynth.object = objectList.pop();
            longSynth.startIndex = longList.size - (Integer)object;
            long l = objectToLong.evaluateLong(longSynth);
            longList.setSize(longSynth.startIndex);
            longList.add(l);
        }
        assert (longList.size == 1);
        return longList.pop();
    }

    public static <T> float synthesize(T t, ObjectToObjectGenerator<? super T, ? extends T> objectToObjectGenerator, ObjectToFloat<FloatSynth<? super T>> objectToFloat) {
        ObjectList objectList = new ObjectList(100);
        FloatList floatList = new FloatList();
        objectList.push(t);
        FloatSynth floatSynth = new FloatSynth();
        floatSynth.valuesList = floatList;
        while (!objectList.isEmpty()) {
            Object object = objectList.peek(1);
            if (object instanceof Node) {
                objectList.push(null);
                int n = objectList.size();
                objectToObjectGenerator.evaluateObject((ObjectConsumer)objectList, object);
                objectList.set(n - 1, (Object)(objectList.size() - n));
                continue;
            }
            objectList.pop();
            floatSynth.object = objectList.pop();
            floatSynth.startIndex = floatList.size - (Integer)object;
            float f = objectToFloat.evaluateFloat(floatSynth);
            floatList.setSize(floatSynth.startIndex);
            floatList.add(f);
        }
        assert (floatList.size == 1);
        return floatList.pop();
    }

    public static <T> double synthesize(T t, ObjectToObjectGenerator<? super T, ? extends T> objectToObjectGenerator, ObjectToDouble<DoubleSynth<? super T>> objectToDouble) {
        ObjectList objectList = new ObjectList(100);
        DoubleList doubleList = new DoubleList();
        objectList.push(t);
        DoubleSynth doubleSynth = new DoubleSynth();
        doubleSynth.valuesList = doubleList;
        while (!objectList.isEmpty()) {
            Object object = objectList.peek(1);
            if (object instanceof Node) {
                objectList.push(null);
                int n = objectList.size();
                objectToObjectGenerator.evaluateObject((ObjectConsumer)objectList, object);
                objectList.set(n - 1, (Object)(objectList.size() - n));
                continue;
            }
            objectList.pop();
            doubleSynth.object = objectList.pop();
            doubleSynth.startIndex = doubleList.size - (Integer)object;
            double d = objectToDouble.evaluateDouble(doubleSynth);
            doubleList.setSize(doubleSynth.startIndex);
            doubleList.add(d);
        }
        assert (doubleList.size == 1);
        return doubleList.pop();
    }

    public static <T, V> V synthesize(T t, ObjectToObjectGenerator<? super T, ? extends T> objectToObjectGenerator, ObjectToObject<ObjectSynth<? super T, ? super V>, ? extends V> objectToObject) {
        ObjectList objectList = new ObjectList(100);
        ObjectList objectList2 = new ObjectList();
        objectList.push(t);
        ObjectSynth objectSynth = new ObjectSynth();
        objectSynth.valuesList = objectList2;
        while (!objectList.isEmpty()) {
            Object object = objectList.peek(1);
            if (object instanceof Node) {
                objectList.push(null);
                int n = objectList.size();
                objectToObjectGenerator.evaluateObject((ObjectConsumer)objectList, object);
                objectList.set(n - 1, (Object)(objectList.size() - n));
                continue;
            }
            objectList.pop();
            objectSynth.object = objectList.pop();
            objectSynth.startIndex = objectList2.size - (Integer)object;
            Object object2 = objectToObject.evaluateObject(objectSynth);
            objectList2.setSize(objectSynth.startIndex);
            objectList2.add(object2);
        }
        assert (objectList2.size == 1);
        return (V)objectList2.pop();
    }

    public static boolean operator$index(BooleanList booleanList, int n) {
        return booleanList.get(n);
    }

    public static BooleanList operator$shl(BooleanList booleanList, boolean bl) {
        booleanList.add(bl);
        return booleanList;
    }

    public static boolean operator$index(Node node, BooleanAttribute booleanAttribute) {
        return node.getCurrentGraphState().getBoolean((Object)node, true, booleanAttribute);
    }

    public static byte operator$index(ByteList byteList, int n) {
        return byteList.get(n);
    }

    public static ByteList operator$shl(ByteList byteList, byte by) {
        byteList.add(by);
        return byteList;
    }

    public static byte operator$index(Node node, ByteAttribute byteAttribute) {
        return node.getCurrentGraphState().getByte((Object)node, true, byteAttribute);
    }

    public static short operator$index(ShortList shortList, int n) {
        return shortList.get(n);
    }

    public static ShortList operator$shl(ShortList shortList, short s) {
        shortList.add(s);
        return shortList;
    }

    public static short operator$index(Node node, ShortAttribute shortAttribute) {
        return node.getCurrentGraphState().getShort((Object)node, true, shortAttribute);
    }

    public static char operator$index(CharList charList, int n) {
        return charList.get(n);
    }

    public static CharList operator$shl(CharList charList, char c) {
        charList.add(c);
        return charList;
    }

    public static char operator$index(Node node, CharAttribute charAttribute) {
        return node.getCurrentGraphState().getChar((Object)node, true, charAttribute);
    }

    public static int operator$index(IntList intList, int n) {
        return intList.get(n);
    }

    public static IntList operator$shl(IntList intList, int n) {
        intList.add(n);
        return intList;
    }

    public static int operator$index(Node node, IntAttribute intAttribute) {
        return node.getCurrentGraphState().getInt((Object)node, true, intAttribute);
    }

    public static long operator$index(LongList longList, int n) {
        return longList.get(n);
    }

    public static LongList operator$shl(LongList longList, long l) {
        longList.add(l);
        return longList;
    }

    public static long operator$index(Node node, LongAttribute longAttribute) {
        return node.getCurrentGraphState().getLong((Object)node, true, longAttribute);
    }

    public static float operator$index(FloatList floatList, int n) {
        return floatList.get(n);
    }

    public static FloatList operator$shl(FloatList floatList, float f) {
        floatList.add(f);
        return floatList;
    }

    public static float operator$index(Node node, FloatAttribute floatAttribute) {
        return node.getCurrentGraphState().getFloat((Object)node, true, floatAttribute);
    }

    public static double operator$index(DoubleList doubleList, int n) {
        return doubleList.get(n);
    }

    public static DoubleList operator$shl(DoubleList doubleList, double d) {
        doubleList.add(d);
        return doubleList;
    }

    public static double operator$index(Node node, DoubleAttribute doubleAttribute) {
        return node.getCurrentGraphState().getDouble((Object)node, true, doubleAttribute);
    }

    public static Node operator$index(Node node, int n) {
        return node.getBranchNode(n);
    }

    public static boolean operator$lt(Node node, Node node2) {
        return node.getId() < node2.getId();
    }

    public static boolean operator$le(Node node, Node node2) {
        return node.getId() <= node2.getId();
    }

    public static boolean operator$gt(Node node, Node node2) {
        return node.getId() > node2.getId();
    }

    public static boolean operator$ge(Node node, Node node2) {
        return node.getId() >= node2.getId();
    }

    public static int operator$index(Node node, NodeToInt nodeToInt) {
        return nodeToInt.evaluateInt(node);
    }

    public static float operator$index(Node node, NodeToFloat nodeToFloat) {
        return nodeToFloat.evaluateFloat(node);
    }

    public static double operator$index(Node node, NodeToDouble nodeToDouble) {
        return nodeToDouble.evaluateDouble(node);
    }

    public static Point3d operator$index(Node node, Location location) {
        return Library.location(node);
    }

    public static void mean(Aggregate aggregate, Tuple3f tuple3f) {
        if (aggregate.initialize()) {
            try {
                aggregate.aval = aggregate.getType().newInstance();
            }
            catch (Exception exception) {
                throw new WrapException((Throwable)exception);
            }
            ((Tuple3f)aggregate.aval).set(0.0f, 0.0f, 0.0f);
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            if (aggregate.ival > 1) {
                ((Tuple3f)aggregate.aval).scale(1.0f / (float)aggregate.ival);
            }
        } else {
            ((Tuple3f)aggregate.aval).add(tuple3f);
            ++aggregate.ival;
        }
    }

    public static void mean(Aggregate aggregate, Tuple3d tuple3d) {
        if (aggregate.initialize()) {
            try {
                aggregate.aval = aggregate.getType().newInstance();
            }
            catch (Exception exception) {
                throw new WrapException((Throwable)exception);
            }
            ((Tuple3d)aggregate.aval).set(0.0, 0.0, 0.0);
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            if (aggregate.ival > 1) {
                ((Tuple3d)aggregate.aval).scale(1.0 / (double)aggregate.ival);
            }
        } else {
            ((Tuple3d)aggregate.aval).add(tuple3d);
            ++aggregate.ival;
        }
    }

    public static boolean plot(Aggregate aggregate, IntToDouble intToDouble, int n) {
        if (aggregate.initialize()) {
            DatasetRef datasetRef = new DatasetRef("plotData");
            datasetRef.clear().addColumn((Comparable)((Object)"Values"));
            aggregate.aval1 = datasetRef;
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            Library.chart((DatasetRef)aggregate.aval1, 2);
        } else {
            ((DatasetRef)aggregate.aval1).addRow((Comparable)Integer.valueOf(n)).set(0, (Number)intToDouble.evaluateDouble(n));
        }
        return false;
    }

    public static boolean plot(Aggregate aggregate, DoubleToDouble doubleToDouble, double d) {
        if (aggregate.initialize()) {
            DatasetRef datasetRef = new DatasetRef("plotData");
            datasetRef.clear().addColumn((Comparable)((Object)"Values"));
            aggregate.aval1 = datasetRef;
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            Library.chart((DatasetRef)aggregate.aval1, 7);
        } else {
            ((DatasetRef)aggregate.aval1).addRow().set(0, (Number)d, (Number)doubleToDouble.evaluateDouble(d));
        }
        return false;
    }

    public static ObjectToDouble<double[]> toObjectToDouble(final DoubleToDouble doubleToDouble) {
        return new ObjectToDouble<double[]>(){

            public double evaluateDouble(double[] dArray) {
                return doubleToDouble.evaluateDouble(dArray[0]);
            }
        };
    }

    public static boolean plot(Aggregate aggregate, double d, double d2) {
        if (aggregate.initialize()) {
            DatasetRef datasetRef = new DatasetRef("plotData");
            datasetRef.clear().addColumn((Comparable)((Object)"Values"));
            aggregate.aval1 = datasetRef;
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            Library.chart((DatasetRef)aggregate.aval1, 7);
        } else {
            ((DatasetRef)aggregate.aval1).addRow().set(0, (Number)d, (Number)d2);
        }
        return false;
    }

    public static boolean plotPoints(Aggregate aggregate, double d, double d2) {
        if (aggregate.initialize()) {
            DatasetRef datasetRef = new DatasetRef("plotData");
            datasetRef.clear().addColumn((Comparable)((Object)"Values"));
            aggregate.aval1 = datasetRef;
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            Library.chart((DatasetRef)aggregate.aval1, 6);
        } else {
            ((DatasetRef)aggregate.aval1).addRow().set(0, (Number)d, (Number)d2);
        }
        return false;
    }

    public static void range(DoubleConsumer doubleConsumer, double d, double d2) {
        Library.range(doubleConsumer, d, d2, 100);
    }

    public static void range(DoubleConsumer doubleConsumer, double d, double d2, int n) {
        for (int i = 0; i <= n; ++i) {
            doubleConsumer.consume((d * (double)(n - i) + d2 * (double)i) / (double)n);
        }
    }

    public static int select(Aggregate aggregate, Node node) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new ObjectList();
        }
        if (aggregate.isFinished()) {
            aggregate.ival = ((ObjectList)aggregate.aval1).size();
            Library.workbench().select((Node[])((ObjectList)aggregate.aval1).toArray((Object[])new Node[aggregate.ival]));
        } else {
            ((ObjectList)aggregate.aval1).add((Object)node);
        }
        return 0;
    }

    public static DisposableIterator apply(final int n) {
        return new DisposableIterator(){
            final RGGGraph ex = Runtime.INSTANCE.currentGraph();
            int i = n;

            public boolean next() {
                if (--this.i < 0) {
                    return false;
                }
                this.ex.derive();
                return true;
            }

            public void dispose(Throwable throwable) {
                this.ex.derive();
            }
        };
    }

    public static DisposableIterator applyUntilFinished() {
        return new DisposableIterator(){
            final RGGGraph ex = Runtime.INSTANCE.currentGraph();
            boolean notFirst = false;
            long stamp;
            int graphStamp;

            public boolean next() {
                long l = this.ex.derive();
                int n = this.ex.getGraphManager().getStamp();
                if (this.notFirst && l == this.stamp && n == this.graphStamp) {
                    return false;
                }
                this.stamp = l;
                this.graphStamp = n;
                this.notFirst = true;
                return true;
            }

            public void dispose(Throwable throwable) {
            }
        };
    }

    @Deprecated
    public static void passBoundary() {
        Library.derive();
    }

    @Deprecated
    public static void apply() {
        Library.derive();
    }

    public static void derive() {
        RGGGraph rGGGraph = Runtime.INSTANCE.currentGraph();
        rGGGraph.derive();
    }

    public static GRSVertex newGRSVertices(ObjectConsumer<? super GRSVertex> objectConsumer) {
        Runtime.INSTANCE.currentGraph().getNewGRSVertices().evaluateObject(objectConsumer);
        return null;
    }

    public static DisposableIterator interpretiveRules() {
        return new DisposableIterator(){
            private final RGGGraph ex = Runtime.INSTANCE.currentGraph();
            private boolean next = true;
            private int old;

            public boolean next() {
                if (this.next) {
                    this.old = this.ex.getDerivationMode();
                    this.ex.setDerivationMode(this.old | 4);
                    this.next = false;
                    return true;
                }
                return false;
            }

            public void dispose(Throwable throwable) {
                this.ex.setDerivationMode(this.old);
            }
        };
    }

    public static void removeInterpretiveNodes() {
        Runtime.INSTANCE.currentGraph().removeInterpretiveNodesOnDerivation();
    }

    public static void moveToExtent(RGGProducer rGGProducer, Node node, final int n) {
        final Transaction transaction = rGGProducer != null ? null : node.getGraph().getActiveTransaction();
        final PropertyQueue propertyQueue = rGGProducer != null ? (PropertyQueue)rGGProducer.getQueues().getQueue((QueueDescriptor)PropertyQueue.PROPERTY_QUEUE) : null;
        VisitorImpl visitorImpl = new VisitorImpl(){

            public Object visitEnter(Path path, boolean bl) {
                if (bl) {
                    Node node = (Node)path.getObject(-1);
                    if (transaction != null) {
                        Node.extentIndex$FIELD.setInt((Object)node, null, n, transaction);
                    } else {
                        propertyQueue.setInt((PersistenceCapable)node, (PersistenceField)Node.extentIndex$FIELD, null, n);
                    }
                }
                return null;
            }

            public Object visitInstanceEnter() {
                return STOP;
            }
        };
        visitorImpl.init(node.getCurrentGraphState(), (EdgePattern)EdgePatternImpl.TREE);
        node.getGraph().accept((Object)node, (Visitor)visitorImpl, null);
    }

    public static void hide(Node node) {
        Transaction transaction = node.getGraph().getActiveTransaction();
        Node node2 = node.findAdjacent(true, false, -1);
        if (node2 != null) {
            node2.getEdgeTo(node).remove(transaction);
        }
        RGGRoot.getRoot(node.getGraph()).addEdgeBitsTo(node, 8192, transaction);
        Library.moveToExtent(null, node, 7);
    }

    public static void mergeTransformations(Node node, boolean bl) {
        Library.mergeTransformations(node, null, bl);
    }

    public static void mergeNonTropismTransformations(Node node, boolean bl) {
        Library.mergeNonTropismTransformations(node, null, bl);
    }

    public static void mergeNonTropismTransformations(Node node, final ObjectToBoolean<? super Node> objectToBoolean, boolean bl) {
        Library.mergeTransformations(node, (ObjectToBoolean<? super Node>)new ObjectToBoolean<Node>(){

            public boolean evaluateBoolean(Node node) {
                return !(node instanceof Tropism) && (objectToBoolean == null || objectToBoolean.evaluateBoolean((Object)node));
            }
        }, bl);
    }

    public static void mergeTransformations(Node node, ObjectToBoolean<? super Node> objectToBoolean, boolean bl) {
        Node node2;
        Object object;
        boolean bl2;
        Node node3;
        Node node4;
        Library.derive();
        GraphState graphState = node.getCurrentGraphState();
        Transaction transaction = node.getGraph().getActiveTransaction();
        ObjectList objectList = new ObjectList(1000);
        ObjectList objectList2 = new ObjectList(100);
        ObjectList objectList3 = new ObjectList(100);
        ObjectList objectList4 = new ObjectList(1000);
        objectList.push((Object)node);
        Matrix4d matrix4d = new Matrix4d();
        Matrix4d matrix4d2 = new Matrix4d();
        Matrix4d matrix4d3 = new Matrix4d();
        Math2.makeAffine((Matrix4d)matrix4d);
        Math2.makeAffine((Matrix4d)matrix4d2);
        Math2.makeAffine((Matrix4d)matrix4d3);
        while (!objectList.isEmpty()) {
            node3 = node4 = (Node)objectList.pop();
            boolean bl3 = false;
            objectList2.clear();
            objectList3.clear();
            bl2 = false;
            boolean bl4 = false;
            block1: while (node3 != null && (object = graphState.getObjectDefault((Object)node3, true, Attributes.TRANSFORMATION, (Object)graphState)) != graphState) {
                boolean bl5;
                boolean bl6 = bl5 = node3.getAccessor((Attribute)Attributes.SHAPE) != null;
                if (bl5 && (!bl || !(node3 instanceof Null)) || objectToBoolean != null && !objectToBoolean.evaluateBoolean((Object)node3)) break;
                objectList2.add((Object)node3);
                objectList3.add((Object)((Transformation)object));
                bl2 |= bl4;
                if (bl5) {
                    bl3 = true;
                    break;
                }
                node2 = null;
                for (Edge edge = node3.getFirstEdge(); edge != null; edge = edge.getNext(node3)) {
                    Node node5 = edge.getTarget();
                    if (node5 == node3 || !edge.testEdgeBits(768)) continue;
                    if (node2 != null) break block1;
                    bl4 = edge.testEdgeBits(512);
                    node2 = node5;
                }
                node3 = node2;
            }
            if (objectList2.size() > 1) {
                matrix4d3.setIdentity();
                for (int i = 0; i < objectList2.size(); ++i) {
                    Transformation transformation;
                    node3 = (Node)objectList2.get(i);
                    if (bl3 && i == objectList2.size() - 1) {
                        transformation = ((Null)node3).getTransform();
                        if (transformation == null) continue;
                        transformation.transform(matrix4d3, matrix4d3);
                        continue;
                    }
                    transformation = (Transformation)objectList3.get(i);
                    if (transformation == null) continue;
                    transformation.preTransform((Object)node3, true, matrix4d3, matrix4d, graphState);
                    transformation.postTransform((Object)node3, true, matrix4d, matrix4d2, matrix4d3, graphState);
                    node2 = matrix4d3;
                    matrix4d3 = matrix4d2;
                    matrix4d2 = node2;
                }
                if (bl2) {
                    matrix4d3.m33 = -1.0;
                }
                objectList4.push((Object)new TMatrix4d(matrix4d3)).push((Object)node4).push(objectList2.pop());
                node4 = node3;
            }
            for (object = node4.getFirstEdge(); object != null; object = object.getNext(node4)) {
                Node node6 = object.getTarget();
                if (node6 == node4 || !object.testEdgeBits(768)) continue;
                objectList.push((Object)node6);
            }
        }
        objectList2 = null;
        objectList3 = null;
        objectList = null;
        while (!objectList4.isEmpty()) {
            int n;
            Edge edge;
            Node node7;
            node4 = (Node)objectList4.pop();
            node3 = (Node)objectList4.pop();
            TMatrix4d tMatrix4d = (TMatrix4d)objectList4.pop();
            boolean bl7 = bl2 = tMatrix4d.m33 < 0.0;
            if (bl2) {
                tMatrix4d.m33 = 1.0;
            }
            if (node4 instanceof Null) {
                node7 = node4;
                Null.transform$FIELD.setObject((Object)node4, null, (Object)tMatrix4d, transaction);
                for (object = node4.getFirstEdge(); object != null; object = object.getNext(node4)) {
                    if (!object.isTarget(node4)) continue;
                    object.remove(transaction);
                }
            } else {
                node7 = new Null((Transform3D)tMatrix4d);
                object = node4.getFirstEdge();
                while (object != null) {
                    edge = object.getNext(node4);
                    node2 = object.getTarget();
                    if (node2 != node4) {
                        n = object.getEdgeBits();
                        object.remove(transaction);
                        node7.addEdgeBitsTo(node2, n, transaction);
                    }
                    object = edge;
                }
            }
            object = node3.getFirstEdge();
            while (object != null) {
                edge = object.getNext(node3);
                node2 = object.getSource();
                if (node2 != node3) {
                    n = object.getEdgeBits();
                    if (bl2 && (n & 0x100) != 0) {
                        n = n & 0xFFFFFEFF | 0x200;
                    }
                    object.remove(transaction);
                    node2.addEdgeBitsTo(node7, n, transaction);
                }
                object = edge;
            }
        }
        Library.derive();
    }

    public static void removeTransformationLeaves(Node node) {
        Library.removeTransformationLeaves(node, null);
    }

    public static void removeTransformationLeaves(Node node, final ObjectToBoolean<? super Node> objectToBoolean) {
        Library.removeLeaves(node, (ObjectToBoolean<? super Node>)new ObjectToBoolean<Node>(){

            public boolean evaluateBoolean(Node node) {
                if (node.getAccessor((Attribute)Attributes.TRANSFORMATION) == null) {
                    return false;
                }
                if (node.getAccessor((Attribute)Attributes.SHAPE) != null) {
                    return false;
                }
                return objectToBoolean == null || objectToBoolean.evaluateBoolean((Object)node);
            }
        });
    }

    public static void removeLeaves(Node node, ObjectToBoolean<? super Node> objectToBoolean) {
        Library.derive();
        Transaction transaction = node.getGraph().getActiveTransaction();
        ObjectList objectList = new ObjectList();
        objectList.push((Object)node);
        block0: while (!objectList.isEmpty()) {
            Node node2;
            Edge edge;
            Node node3 = (Node)objectList.pop();
            if (node3 != null) {
                objectList.push((Object)node3);
                objectList.push(null);
                for (edge = node3.getFirstEdge(); edge != null; edge = edge.getNext(node3)) {
                    node2 = edge.getTarget();
                    if (node2 == node3 || !edge.testEdgeBits(768)) continue;
                    objectList.push((Object)node2);
                }
                continue;
            }
            node3 = (Node)objectList.pop();
            for (edge = node3.getFirstEdge(); edge != null; edge = edge.getNext(node3)) {
                node2 = edge.getTarget();
                if (node2 != node3) continue block0;
            }
            if (!objectToBoolean.evaluateBoolean((Object)node3)) continue;
            node3.removeAll(transaction);
        }
        Library.derive();
    }

    public static Statistics statistics(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.ival1 = 0;
            aggregate.dval1 = 0.0;
            aggregate.dval2 = 0.0;
            aggregate.dval3 = 0.0;
            aggregate.dval = Double.MAX_VALUE;
            aggregate.dval4 = Double.MIN_VALUE;
        }
        if (!aggregate.isFinished()) {
            ++aggregate.ival1;
            aggregate.dval1 += d;
            aggregate.dval2 += d * d;
            aggregate.dval3 += d * d * d;
            aggregate.dval = Math.min(aggregate.dval, d);
            aggregate.dval4 = Math.max(aggregate.dval4, d);
        } else {
            aggregate.aval = new Statistics(aggregate.ival1, aggregate.dval1, aggregate.dval2, aggregate.dval3, aggregate.dval, aggregate.dval4);
        }
        return null;
    }

    public static void defer(Runnable runnable) {
        ((GraphQueue)Runtime.INSTANCE.currentGraph().getQueues().getQueue((QueueDescriptor)GraphQueue.EXECUTE_DESCRIPTOR)).execute(runnable);
    }

    public static Vector3d randomDirection() {
        Vector3d vector3d = new Vector3d();
        double d = Operators.getRandomGenerator().nextDouble();
        double d2 = Operators.getRandomGenerator().nextDouble();
        double d3 = Math.sqrt(1.0 - d * d);
        double d4 = Math.PI * 2 * d2;
        vector3d.x = d3 * Math.cos(d4);
        vector3d.y = d3 * Math.sin(d4);
        vector3d.z = 2.0 * d - 1.0;
        return vector3d;
    }

    private static class DoNothingVisitor
    extends DisplayVisitor {
        private DoNothingVisitor() {
        }

        void init(GraphState graphState) {
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.setIdentity();
            this.init(graphState, matrix4d, null, false);
        }

        protected void visitImpl(Object object, boolean bl, Shader shader, Path path) {
        }
    }

    private static final class Locals {
        final Line line = new Line();
        final IntersectionList ilist = new IntersectionList();

        Locals() {
        }
    }
}

