/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg.model;

import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Workbench;
import de.grogra.rgg.ConcurrentTask;
import de.grogra.rgg.model.QueueSolver;
import de.grogra.rgg.model.RGGGraph;
import de.grogra.rgg.model.Runtime;
import de.grogra.task.PartialTask;
import de.grogra.task.SolverInOwnThread;
import de.grogra.util.ThreadContext;
import de.grogra.xl.impl.queues.Queue;
import de.grogra.xl.impl.queues.QueueCollection;
import de.grogra.xl.util.ObjectList;
import java.util.List;

public class LocalSolver
extends SolverInOwnThread
implements QueueSolver {
    private final Workbench workbench;
    private GraphState state;
    private RGGGraph extent;
    private final Object initLock = new Object();

    public LocalSolver(Workbench workbench) {
        this.workbench = workbench;
    }

    protected void solveImpl(PartialTask partialTask) {
        ConcurrentTask concurrentTask = (ConcurrentTask)partialTask;
        concurrentTask.setGraphState(this.state);
        concurrentTask.run();
        concurrentTask.markProcessed();
    }

    protected Thread createThread() {
        Thread thread = new Thread((Runnable)((Object)this), this.toString());
        thread.setPriority(1);
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueuesTo(QueueCollection queueCollection) {
        Object object = this.initLock;
        synchronized (object) {
            if (this.extent != null) {
                ObjectList objectList = new ObjectList();
                this.extent.getQueues().getQueues((List)objectList);
                RGGGraph.addQueues(queueCollection, (ObjectList<? extends Queue>)objectList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueues() {
        Object object = this.initLock;
        synchronized (object) {
            if (this.extent != null) {
                this.extent.getQueues().clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.initLock;
        synchronized (object) {
            Registry.setCurrent((RegistryContext)this.workbench);
            Workbench.setCurrent((Workbench)this.workbench);
            ThreadContext threadContext = ThreadContext.current();
            ThreadContext threadContext2 = this.workbench.getJobManager().getThreadContext();
            threadContext.setPriority((short)Short.MAX_VALUE);
            this.state = GraphState.get((Graph)this.workbench.getRegistry().getProjectGraph(), (ThreadContext)threadContext2).forContext(threadContext);
            this.extent = Runtime.INSTANCE.currentGraph();
            this.extent.derive();
        }
        try {
            super.run();
        }
        finally {
            Registry.setCurrent(null);
            Workbench.setCurrent(null);
            this.state.dispose();
            this.state = null;
        }
    }
}

