/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg.model;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.NURBSCurve;
import de.grogra.imp3d.objects.NURBSSurface;
import de.grogra.math.BSplineCurve;
import de.grogra.math.BSplineSurface;
import de.grogra.rgg.BooleanNode;
import de.grogra.rgg.ByteNode;
import de.grogra.rgg.CharNode;
import de.grogra.rgg.DoubleNode;
import de.grogra.rgg.FloatNode;
import de.grogra.rgg.IntNode;
import de.grogra.rgg.LongNode;
import de.grogra.rgg.ObjectNode;
import de.grogra.rgg.RGGRoot;
import de.grogra.rgg.Reference;
import de.grogra.rgg.ShortNode;
import de.grogra.rgg.model.RGGGraph;
import de.grogra.rgg.model.Runtime;
import de.grogra.rgg.model.VVProducer;
import de.grogra.xl.impl.base.Producer;
import de.grogra.xl.impl.base.RuntimeModel;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.EdgePattern;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.util.Operators;

public class RGGProducer
extends Producer {
    private boolean probabilitySet;
    private double probability;
    private VVProducer vvProd;

    public RGGProducer(QueryState queryState) {
        super(queryState);
    }

    RGGProducer(Runtime runtime) {
        super((RuntimeModel)runtime);
    }

    public VVProducer vv() {
        if (this.vvProd == null) {
            this.vvProd = new VVProducer(this);
        }
        return this.vvProd;
    }

    void nodeUsed0(Node node) {
        this.nodeUsed(node);
    }

    QueryState getQueryState0() {
        return this.getQueryState();
    }

    public boolean ruleProbability(double d) {
        if (!this.probabilitySet) {
            QueryState queryState = this.getQueryState();
            this.probability = Operators.getRandomGenerator().nextDouble();
            this.probabilitySet = true;
        }
        if (d > 0.0) {
            this.probability -= d;
        }
        return this.probability <= 0.0;
    }

    public boolean producer$beginExecution(int n) {
        this.probabilitySet = false;
        return super.producer$beginExecution(n);
    }

    public void producer$endExecution(boolean bl) {
        super.producer$endExecution(bl);
        QueryState queryState = this.getQueryState();
        if (bl && queryState != null) {
            ((RGGGraph)queryState.getGraph()).productionStateEnded(this);
        }
    }

    public RGGProducer producer$getProducer() {
        return this;
    }

    public Node producer$getLeftmostMatch() {
        Object object = this.getQueryState().getInValue();
        return object instanceof Node ? (Node)object : null;
    }

    public Node producer$getRoot() {
        QueryState queryState = this.getQueryState();
        return queryState != null ? RGGRoot.getRoot(((RGGGraph)queryState.getGraph()).getGraphManager()) : null;
    }

    public VVProducer operator$space(VVProducer vVProducer) {
        return vVProducer;
    }

    public RGGProducer operator$space(Node node) {
        this.addNodeImpl(node, true);
        return this;
    }

    public RGGProducer producer$push() {
        this.pushImpl();
        return this;
    }

    public RGGProducer producer$begin() {
        return this;
    }

    public void producer$end() {
    }

    public RGGProducer producer$separate() {
        this.separateImpl();
        return this;
    }

    public RGGProducer producer$pop(Object object) {
        this.popImpl();
        return this;
    }

    public RGGProducer operator$arrow(Node node, int n) {
        this.addEdgeImpl(this.getPreviousNode(), node, n, (EdgeDirection)EdgeDirection.FORWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$arrow(Node node, Node node2) {
        return this.operator$arrow(node2, 1).operator$arrow(node, 128);
    }

    public RGGProducer operator$leftArrow(Node node, int n) {
        this.addEdgeImpl(this.getPreviousNode(), node, n, (EdgeDirection)EdgeDirection.BACKWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$leftArrow(Node node, Node node2) {
        return this.operator$leftArrow(node2, 128).operator$leftArrow(node, 1);
    }

    public RGGProducer operator$sub(Node node, int n) {
        this.addEdgeImpl(this.getPreviousNode(), node, n, (EdgeDirection)EdgeDirection.UNDIRECTED);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$sub(Node node, Node node2) {
        return this.operator$arrow(node, node2);
    }

    public RGGProducer operator$xLeftRightArrow(Node node, int n) {
        this.addEdgeImpl(this.getPreviousNode(), node, n, (EdgeDirection)EdgeDirection.BOTH);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$xLeftRightArrow(Node node, Node node2) {
        Node node3 = (Node)this.getPreviousNode();
        this.operator$arrow(node, node2);
        this.addEdgeImpl(node, node2, 1, (EdgeDirection)EdgeDirection.FORWARD);
        this.addEdgeImpl(node2, node3, 128, (EdgeDirection)EdgeDirection.FORWARD);
        return this;
    }

    public RGGProducer operator$gt(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 256, (EdgeDirection)EdgeDirection.FORWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$lt(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 256, (EdgeDirection)EdgeDirection.BACKWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$line(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 256, (EdgeDirection)EdgeDirection.UNDIRECTED);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$leftRightArrow(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 256, (EdgeDirection)EdgeDirection.BOTH);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$plusArrow(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 512, (EdgeDirection)EdgeDirection.FORWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$plusLeftArrow(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 512, (EdgeDirection)EdgeDirection.BACKWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$plusLine(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 512, (EdgeDirection)EdgeDirection.UNDIRECTED);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$plusLeftRightArrow(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 512, (EdgeDirection)EdgeDirection.BOTH);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$slashArrow(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 4096, (EdgeDirection)EdgeDirection.FORWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$slashLeftArrow(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 4096, (EdgeDirection)EdgeDirection.BACKWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$slashLine(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 4096, (EdgeDirection)EdgeDirection.UNDIRECTED);
        this.addNodeImpl(node, false);
        return this;
    }

    public RGGProducer operator$slashLeftRightArrow(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 4096, (EdgeDirection)EdgeDirection.BOTH);
        this.addNodeImpl(node, false);
        return this;
    }

    public void producer$visitEdge(EdgePattern edgePattern) {
        int n = edgePattern.getMatchIndex();
        switch (edgePattern.getParameterType(n).getTypeId()) {
            case 6: {
                super.producer$visitEdge(edgePattern);
                break;
            }
            case 0: {
                Object object = this.getQueryState().abound(n);
                if (!(object instanceof Node)) break;
                this.deleteNodeQueue.deleteNode(object);
            }
        }
    }

    public static Node toNode(boolean bl) {
        return new BooleanNode(bl);
    }

    public static Node toNode(byte by) {
        return new ByteNode(by);
    }

    public static Node toNode(short s) {
        return new ShortNode(s);
    }

    public static Node toNode(char c) {
        return new CharNode(c);
    }

    public static Node toNode(int n) {
        return new IntNode(n);
    }

    public static Node toNode(long l) {
        return new LongNode(l);
    }

    public static Node toNode(float f) {
        return new FloatNode(f);
    }

    public static Node toNode(double d) {
        return new DoubleNode(d);
    }

    public static Node toNode(Object object) {
        return new ObjectNode(object);
    }

    public static Node toNode(BSplineCurve bSplineCurve) {
        return new NURBSCurve(bSplineCurve);
    }

    public static Node toNode(BSplineSurface bSplineSurface) {
        return new NURBSSurface(bSplineSurface);
    }

    public static Node toNode(Reference reference) {
        return reference.resolve();
    }

    public static final class Creator {
        public RGGProducer producer$begin() {
            return new RGGProducer(Runtime.INSTANCE);
        }
    }
}

