/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.query;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Method;
import de.grogra.reflect.Type;
import de.grogra.xl.query.BytecodeSerialization;
import de.grogra.xl.query.Graph;
import de.grogra.xl.query.MatchConsumer;
import de.grogra.xl.query.Producer;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.query.UserDefinedPattern;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.XBitSet;

public abstract class Pattern
implements BytecodeSerialization.Serializable {
    public static final Matcher NULL_MATCHER = new Matcher(0.95f){

        public void findMatches(QueryState queryState, MatchConsumer matchConsumer, int n) {
            matchConsumer.matchFound(queryState, n);
        }

        protected boolean isLessThanOverride(Matcher matcher) {
            return true;
        }

        public float getBaseCosts() {
            return 0.0f;
        }
    };
    public static final int NODE_MASK = 1;
    public static final int CONTEXT_MASK = 2;
    public static final int INPUT_MASK = 4;
    public static final int OUTPUT_MASK = 8;
    private final Type[] parameterTypes;
    private final int declaredParameterCount;

    protected Pattern(Type[] typeArray, int n) {
        this.parameterTypes = typeArray;
        this.declaredParameterCount = n;
    }

    Pattern(Type type) {
        Method method;
        assert (this instanceof UserDefinedPattern);
        if (type == null) {
            type = ClassAdapter.wrap(this.getClass(), (boolean)false);
        }
        if ((method = UserDefinedPattern.findSignatureMethod(type)) == null) {
            throw new IncompatibleClassChangeError("No signature method for " + type);
        }
        this.parameterTypes = UserDefinedPattern.getSignature(method, null);
        if (this.parameterTypes == null) {
            throw new IncompatibleClassChangeError("Illegal signature method " + method);
        }
        this.declaredParameterCount = this.parameterTypes.length;
    }

    public final int getParameterCount() {
        return this.parameterTypes.length;
    }

    public final int getDeclaredParameterCount() {
        return this.declaredParameterCount;
    }

    public final Type getParameterType(int n) {
        return this.parameterTypes[n];
    }

    public abstract int getParameterKind(int var1);

    public boolean isDeleting() {
        return false;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1) + '[' + this.paramString() + "]@" + Integer.toHexString(this.hashCode());
    }

    protected String paramString() {
        return String.valueOf(this.parameterTypes.length);
    }

    public abstract Matcher createMatcher(Graph var1, XBitSet var2, IntList var3);

    public static abstract class Matcher
    implements Comparable {
        private final float branchingFactor;

        public Matcher(float f) {
            this.branchingFactor = f;
        }

        public final float getBranchingFactor() {
            return this.branchingFactor;
        }

        public float getBaseCosts() {
            return 1.0f;
        }

        public final int compareTo(Object object) {
            Matcher matcher = (Matcher)object;
            if (this.isLessThanOverride(matcher)) {
                return -1;
            }
            if (matcher.isLessThanOverride(this)) {
                return 1;
            }
            float f = this.getBranchingFactor() - matcher.getBranchingFactor();
            return f < 0.0f ? -1 : (f > 0.0f ? 1 : 0);
        }

        protected boolean isLessThanOverride(Matcher matcher) {
            return false;
        }

        public abstract void findMatches(QueryState var1, MatchConsumer var2, int var3);

        public void visitMatch(QueryState queryState, Producer producer) {
        }
    }
}

