/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.blocks.xFrogFileParser;

import de.grogra.blocks.xFrogFileParser.parser;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.PerspectiveProjection;
import de.grogra.imp3d.Projection;
import de.grogra.imp3d.shading.Phong;
import de.grogra.math.ChannelMap;
import de.grogra.persistence.Shareable;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ReaderSource;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.ui.Workbench;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class XFrogProjectLoader
extends FilterBase
implements ObjectSource,
Workbench.Loader {
    private parser p1 = null;
    Camera cam;

    public XFrogProjectLoader(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(IOFlavor.PROJECT_LOADER);
    }

    public Object getObject() {
        return this;
    }

    public void loadRegistry(Registry registry) throws IOException {
        Reader reader = ((ReaderSource)this.source).getReader();
        this.p1 = new parser();
        File file = ((FileSource)this.source).getInputFile();
        registry.initFileSystem((FileSystem)new LocalFileSystem("pfs", file.getParentFile()));
        this.p1.parseFile(reader, file.getParentFile(), registry);
        registry.setEmptyGraph();
        Tuple3f tuple3f = this.p1.getCameraParams();
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.rotX(-1.5707963267948966);
        matrix4d.setTranslation(new Vector3d((double)tuple3f.x, (double)tuple3f.y, 0.0));
        this.cam = new Camera();
        this.cam.setTransformation(matrix4d);
        PerspectiveProjection perspectiveProjection = new PerspectiveProjection();
        perspectiveProjection.setFieldOfView(tuple3f.z * (float)Math.PI / 180.0f);
        this.cam.setProjection((Projection)perspectiveProjection);
        Vector vector = this.p1.getTextures();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ChannelMap channelMap = (ChannelMap)enumeration.nextElement();
            Phong phong = new Phong();
            phong.setDiffuse(channelMap);
            registry.addSharedObject("/project/objects/3d/materials", (Shareable)phong, "texture" + n, true);
            ++n;
        }
    }

    public void loadGraph(Registry registry) throws IOException {
        ((Node)registry.getProjectGraph().getRoot("MainGraph")).appendBranchNode(this.p1.toGraph());
    }

    public void loadWorkbench(Workbench workbench) {
        workbench.setProperty("initial-camera", null);
    }
}

