/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.msml;

import de.grogra.msml.MSMLDatatype;
import de.grogra.msml.MSMLMetadata;
import de.grogra.msml.MSNode;
import de.grogra.pf.io.DOMSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.Expression;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.StringMap;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MSMLReader
extends FilterBase
implements ObjectSource {
    static final String MSML_NAMESPACE = "http://grogra.de/msml";
    Registry registry;
    HashMap elemAllocation = new HashMap();
    HashMap edgeTypes = new HashMap();
    HashMap idToNode = new HashMap();

    public MSMLReader(FilterItem filterItem, FilterSource filterSource) {
        this(Workbench.current().getRegistry(), filterItem, filterSource);
    }

    public MSMLReader(Registry registry, FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.registry = registry;
        this.setFlavor(IOFlavor.NODE);
        this.initElemAllocation();
        this.initEdgeTypeAllocation();
    }

    private void initEdgeTypeAllocation() {
        this.edgeTypes.put("successor", new Integer(256));
        this.edgeTypes.put("branch", new Integer(512));
        this.edgeTypes.put("refinement", new Integer(1024));
        this.edgeTypes.put("objectsplitter", new Integer(32768));
        this.edgeTypes.put("userdefined", new Integer(65536));
    }

    private void initElemAllocation() {
        for (de.grogra.graph.impl.Node node = this.item.getBranch(); node != null; node = node.getSuccessor()) {
            if (!(node instanceof Expression)) continue;
            Expression expression = (Expression)node;
            this.elemAllocation.put(expression.getName(), expression.evaluate((RegistryContext)this, new StringMap()));
        }
    }

    public Object getObject() throws IOException {
        Document document = ((DOMSource)this.source).getDocument();
        Node node = document.getLastChild();
        de.grogra.graph.impl.Node node2 = null;
        if (!node.getNamespaceURI().equals(MSML_NAMESPACE) || !this.getAttributeContent(node, "version").equals("1.0")) {
            throw new IOException();
        }
        node2 = this.traverse(node, this.toURL());
        return node2;
    }

    private de.grogra.graph.impl.Node traverse(Node node, URL uRL) throws IOException {
        de.grogra.graph.impl.Node node2;
        block22: {
            String string;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            node2 = null;
                            if (!node.getNamespaceURI().equals(MSML_NAMESPACE)) break block22;
                            string = node.getLocalName();
                            if (!string.equals("node")) break block23;
                            MSMLMetadata mSMLMetadata = new MSMLMetadata();
                            for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                                if (!this.isDOMElement_Node(node3) || !node3.getLocalName().equals("data") || !node3.getNamespaceURI().equals(MSML_NAMESPACE)) continue;
                                for (Node node4 = node3.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                                    if (!this.isDOMElement_Node(node4)) continue;
                                    String string2 = node4.getNamespaceURI() + node4.getLocalName();
                                    if (this.elemAllocation.containsKey(string2)) {
                                        node2 = ((MSMLDatatype)this.elemAllocation.get(string2)).export(this.registry, node4, node2, uRL);
                                        continue;
                                    }
                                    mSMLMetadata.addMetadata(string2 + node4.getAttributes().getNamedItem("name"), node4);
                                }
                            }
                            if (node2 == null) {
                                node2 = new de.grogra.graph.impl.Node();
                            }
                            if (mSMLMetadata.numberOfMetadataentries() > 0) {
                                node2.addEdgeBitsTo((de.grogra.graph.impl.Node)mSMLMetadata, 32768, null);
                            }
                            node2.setName(this.getAttributeContent(node, "name"));
                            this.idToNode.put(this.getAttributeContent(node, "id"), node2);
                            break block22;
                        }
                        if (!string.equals("scale")) break block24;
                        node2 = new de.grogra.graph.impl.Node();
                        node2.setName(this.getAttributeContent(node, "name"));
                        Vector<String> vector = new Vector<String>();
                        for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                            if (!this.isDOMElement_Node(node5) || !node5.getLocalName().equals("msobject") && !node5.getLocalName().equals("node")) continue;
                            this.traverse(node5, uRL);
                            vector.addElement(this.getAttributeContent(node5, "id"));
                        }
                        this.findEdges(node, vector);
                        for (int i = 0; i < vector.size(); ++i) {
                            de.grogra.graph.impl.Node node6 = (de.grogra.graph.impl.Node)this.idToNode.get(vector.get(i));
                            if (node6.getSource() != null) continue;
                            node2.addEdgeBitsTo(node6, 512, null);
                        }
                        break block22;
                    }
                    if (!string.equals("msobject")) break block25;
                    MSNode mSNode = new MSNode();
                    de.grogra.graph.impl.Node node7 = node2;
                    String string3 = this.getAttributeContent(node, "showScale");
                    mSNode.setName(this.getAttributeContent(node, "name"));
                    for (Node node8 = node.getFirstChild(); node8 != null; node8 = node8.getNextSibling()) {
                        Node node9;
                        if (!this.isDOMElement_Node(node8)) continue;
                        if (node8.getLocalName().equals("data")) {
                            for (node9 = node8.getFirstChild(); node9 != null; node9 = node9.getNextSibling()) {
                                String string4;
                                if (!this.isDOMElement_Node(node9) || !this.elemAllocation.containsKey(string4 = node9.getNamespaceURI() + node9.getLocalName())) continue;
                                node7 = ((MSMLDatatype)this.elemAllocation.get(string4)).export(this.registry, node9, node7, uRL);
                            }
                        }
                        if (!node8.getLocalName().equals("scale")) continue;
                        node9 = this.traverse(node8, uRL);
                        mSNode.addScale((de.grogra.graph.impl.Node)node9);
                        if (!string3.equals(this.getAttributeContent(node8, "name"))) continue;
                        mSNode.setScale((de.grogra.graph.impl.Node)node9);
                    }
                    if (node7 == null) {
                        node2 = mSNode;
                    } else {
                        node7.appendBranchNode((de.grogra.graph.impl.Node)mSNode);
                        node2 = node7;
                    }
                    this.findEdges(node, null);
                    this.idToNode.put(this.getAttributeContent(node, "id"), node2);
                    break block22;
                }
                if (!string.equals("group")) break block26;
                for (Node node10 = node.getFirstChild(); node10 != null; node10 = node10.getNextSibling()) {
                    if (!this.isDOMElement_Node(node10) || !node10.getNamespaceURI().equals(MSML_NAMESPACE)) continue;
                    if (node10.getLocalName().equals("data")) {
                        for (Node node11 = node10.getFirstChild(); node11 != null; node11 = node11.getNextSibling()) {
                            String string5;
                            if (!this.isDOMElement_Node(node11) || !this.elemAllocation.containsKey(string5 = node11.getNamespaceURI() + node11.getLocalName())) continue;
                            node2 = ((MSMLDatatype)this.elemAllocation.get(string5)).export(this.registry, node11, node2, uRL);
                        }
                    }
                    if (node10.getLocalName().equals("msobject")) {
                        if (node2 == null) {
                            node2 = new de.grogra.graph.impl.Node();
                        }
                        node2.addEdgeBitsTo(this.traverse(node10, uRL), 512, null);
                        node2.setName(this.getAttributeContent(node, "name"));
                    }
                    if (!node10.getLocalName().equals("group")) continue;
                    if (node2 == null) {
                        node2 = new de.grogra.graph.impl.Node();
                    }
                    node2.addEdgeBitsTo(this.traverse(node10, uRL), 512, null);
                    node2.setName(this.getAttributeContent(node, "name"));
                }
                break block22;
            }
            if (!string.equals("msml")) break block22;
            for (Node node12 = node.getFirstChild(); node12 != null; node12 = node12.getNextSibling()) {
                if (!this.isDOMElement_Node(node12) || !node12.getNamespaceURI().equals(MSML_NAMESPACE)) continue;
                if (node12.getLocalName().equals("library")) {
                    for (Node node13 = node12.getFirstChild(); node13 != null; node13 = node13.getNextSibling()) {
                        if (!this.isDOMElement_Node(node13) || !node13.getLocalName().equals("data")) continue;
                        for (Node node14 = node13.getFirstChild(); node14 != null; node14 = node14.getNextSibling()) {
                            String string6;
                            if (!this.isDOMElement_Node(node14) || !this.elemAllocation.containsKey(string6 = node14.getNamespaceURI() + node14.getLocalName())) continue;
                            ((MSMLDatatype)this.elemAllocation.get(string6)).export(this.registry, node14, node2, uRL);
                        }
                    }
                }
                if (!node12.getLocalName().equals("msobject") && !node12.getLocalName().equals("group")) continue;
                node2 = this.traverse(node12, uRL);
            }
        }
        return node2;
    }

    private void findEdges(Node node, Vector vector) {
        if (node.getNamespaceURI().equals(MSML_NAMESPACE)) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!this.isDOMElement_Node(node2) || !node2.getLocalName().equals("edge")) continue;
                String string = this.getAttributeContent(node2, "source");
                String string2 = this.getAttributeContent(node2, "target");
                de.grogra.graph.impl.Node node3 = (de.grogra.graph.impl.Node)this.idToNode.get(string);
                de.grogra.graph.impl.Node node4 = (de.grogra.graph.impl.Node)this.idToNode.get(string2);
                int n = (Integer)this.edgeTypes.get(this.getAttributeContent(node2, "type"));
                if (vector != null && !vector.contains(string) && vector.contains(string2)) {
                    n |= ((Integer)this.edgeTypes.get("objectsplitter")).intValue();
                }
                try {
                    int n2 = Integer.parseInt(this.getAttributeContent(node2, "order"));
                    n = n & 0xFFFFFF00 | n2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                node3.addEdgeBitsTo(node4, n, null);
            }
        }
    }

    protected boolean isDOMElement_Node(Node node) {
        return node.getNodeType() == 1;
    }

    private String getAttributeContent(Node node, String string) {
        String string2 = "";
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            string2 = node2.getNodeValue();
        }
        return string2;
    }
}

