/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.data;

import de.grogra.pf.data.Dataset;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.OutputStreamSource;
import de.grogra.util.MimeType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hpsf.MutableProperty;
import org.apache.poi.hpsf.MutablePropertySet;
import org.apache.poi.hpsf.MutableSection;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.hpsf.wellknown.SectionIDMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.RichTextString;

public class ExcelWriter
extends FilterBase
implements OutputStreamSource {
    public static final IOFlavor FLAVOR = new IOFlavor(new MimeType("application/vnd.ms-excel", null), 2, null);

    public ExcelWriter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
    }

    private static String makeValidString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            switch (stringBuffer.charAt(i)) {
                case '*': 
                case '/': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': {
                    stringBuffer.setCharAt(i, '_');
                }
            }
        }
        return stringBuffer.toString();
    }

    public void write(OutputStream outputStream) throws IOException {
        HSSFCell hSSFCell;
        Dataset dataset = (Dataset)((ObjectSource)this.source).getObject();
        int n = dataset.getColumnCount();
        int n2 = dataset.getRowCount();
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HSSFSheet hSSFSheet = hSSFWorkbook.createSheet(ExcelWriter.makeValidString(dataset.getTitle()));
        hSSFSheet.setZoom(9, 10);
        hSSFSheet.setAutobreaks(true);
        hSSFSheet.setFitToPage(true);
        HSSFPrintSetup hSSFPrintSetup = hSSFSheet.getPrintSetup();
        hSSFPrintSetup.setPaperSize((short)9);
        hSSFPrintSetup.setLandscape(true);
        hSSFPrintSetup.setFitWidth((short)1);
        HSSFFooter hSSFFooter = hSSFSheet.getFooter();
        hSSFFooter.setLeft("Created by GroIMP");
        hSSFFooter.setCenter(dataset.getTitle());
        hSSFFooter.setRight("Page " + HSSFFooter.page() + "/" + HSSFFooter.numPages());
        HSSFCellStyle hSSFCellStyle = hSSFWorkbook.createCellStyle();
        HSSFFont hSSFFont = hSSFWorkbook.createFont();
        hSSFCellStyle.setFillForegroundColor((short)22);
        hSSFCellStyle.setFillPattern((short)1);
        hSSFCellStyle.setAlignment((short)2);
        hSSFCellStyle.setBorderBottom((short)1);
        hSSFCellStyle.setBottomBorderColor((short)8);
        hSSFCellStyle.setBorderTop((short)1);
        hSSFCellStyle.setTopBorderColor((short)8);
        hSSFCellStyle.setBorderLeft((short)1);
        hSSFCellStyle.setLeftBorderColor((short)8);
        hSSFCellStyle.setBorderRight((short)1);
        hSSFCellStyle.setRightBorderColor((short)8);
        hSSFFont.setBoldweight((short)700);
        hSSFFont.setColor((short)8);
        hSSFCellStyle.setFont(hSSFFont);
        HSSFRow hSSFRow = hSSFSheet.createRow(0);
        for (int i = 0; i < n; ++i) {
            hSSFCell = hSSFRow.createCell((short)i);
            hSSFSheet.setColumnWidth((short)i, (short)7680);
            hSSFCell.setCellStyle(hSSFCellStyle);
            hSSFCell.setCellValue((RichTextString)new HSSFRichTextString(dataset.getColumnKey(i).toString()));
        }
        HSSFCellStyle hSSFCellStyle2 = hSSFWorkbook.createCellStyle();
        hSSFCellStyle2.setBorderBottom((short)1);
        hSSFCellStyle2.setBottomBorderColor((short)55);
        hSSFCellStyle2.setBorderLeft((short)1);
        hSSFCellStyle2.setLeftBorderColor((short)55);
        hSSFCellStyle2.setBorderRight((short)1);
        hSSFCellStyle2.setRightBorderColor((short)55);
        hSSFCellStyle = hSSFWorkbook.createCellStyle();
        hSSFCellStyle.setBorderBottom((short)1);
        hSSFCellStyle.setBottomBorderColor((short)55);
        hSSFCellStyle.setBorderLeft((short)1);
        hSSFCellStyle.setLeftBorderColor((short)55);
        hSSFCellStyle.setBorderRight((short)1);
        hSSFCellStyle.setRightBorderColor((short)55);
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            int n4 = n3;
            n3 = (short)(n3 + 1);
            hSSFRow = hSSFSheet.createRow(n4);
            for (int j = 0; j < n; ++j) {
                hSSFCell = hSSFRow.createCell((short)j);
                hSSFCell.setCellValue(dataset.getCell(i, j).getX());
                hSSFCell.setCellStyle(hSSFCellStyle2);
            }
        }
        hSSFWorkbook.write((OutputStream)byteArrayOutputStream);
        try {
            MutablePropertySet mutablePropertySet = new MutablePropertySet();
            MutableSection mutableSection = (MutableSection)mutablePropertySet.getFirstSection();
            mutableSection.setFormatID(SectionIDMap.SUMMARY_INFORMATION_ID);
            MutableProperty[] mutablePropertyArray = new MutableProperty[5];
            for (int i = 0; i < 5; ++i) {
                mutablePropertyArray[i] = new MutableProperty();
            }
            mutablePropertyArray[0].setID(2L);
            mutablePropertyArray[0].setType(31L);
            mutablePropertyArray[0].setValue((Object)dataset.getTitle());
            mutablePropertyArray[1].setID(4L);
            mutablePropertyArray[1].setType(31L);
            mutablePropertyArray[1].setValue((Object)"GroIMP");
            mutablePropertyArray[2].setID(3L);
            mutablePropertyArray[2].setType(31L);
            mutablePropertyArray[2].setValue((Object)dataset.getTitle());
            mutablePropertyArray[3].setID(8L);
            mutablePropertyArray[3].setType(31L);
            mutablePropertyArray[3].setValue((Object)"GroIMP");
            mutablePropertyArray[4].setID(18L);
            mutablePropertyArray[4].setType(31L);
            mutablePropertyArray[4].setValue((Object)"Microsoft Excel");
            mutableSection.setProperties((Property[])mutablePropertyArray);
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem();
            InputStream inputStream = mutablePropertySet.toInputStream();
            pOIFSFileSystem.createDocument(inputStream, "\u0005SummaryInformation");
            pOIFSFileSystem.writeFilesystem((OutputStream)byteArrayOutputStream);
        }
        catch (WritingNotSupportedException writingNotSupportedException) {
            // empty catch block
        }
        byteArrayOutputStream.writeTo(outputStream);
        byteArrayOutputStream.close();
    }
}

