/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.data;

import de.grogra.pf.data.Dataset;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.OutputStreamSource;
import de.grogra.util.MimeType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class XMLWriter
extends FilterBase
implements OutputStreamSource {
    public static final IOFlavor FLAVOR = new IOFlavor(MimeType.TEXT_XML, 2, null);

    public XMLWriter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
    }

    public void write(OutputStream outputStream) throws IOException {
        int n;
        Dataset dataset = (Dataset)((ObjectSource)this.source).getObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = dataset.getColumnCount();
        int n3 = dataset.getRowCount();
        byteArrayOutputStream.write(new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").getBytes());
        byteArrayOutputStream.write(new String("<table>\n").getBytes());
        byteArrayOutputStream.write(new String("\t<tableinfo>\n").getBytes());
        byteArrayOutputStream.write(new String("\t\t<name>").getBytes());
        byteArrayOutputStream.write(new String(dataset.getTitle()).getBytes());
        byteArrayOutputStream.write(new String("</name>\n").getBytes());
        byteArrayOutputStream.write(new String("\t</tableinfo>\n").getBytes());
        byteArrayOutputStream.write(new String("\t<tableheader>\n").getBytes());
        for (n = 0; n < n2; ++n) {
            byteArrayOutputStream.write(new String("\t\t<column>").getBytes());
            byteArrayOutputStream.write(dataset.getColumnKey(n).toString().getBytes());
            byteArrayOutputStream.write(new String("</column>\n").getBytes());
        }
        byteArrayOutputStream.write(new String("\t</tableheader>\n").getBytes());
        for (n = 0; n < n3; ++n) {
            byteArrayOutputStream.write(new String("\t<row>\n").getBytes());
            for (int i = 0; i < n2; ++i) {
                byteArrayOutputStream.write(new String("\t\t<column>").getBytes());
                byteArrayOutputStream.write(String.valueOf(dataset.getCell(n, i).getX()).getBytes());
                byteArrayOutputStream.write(new String("</column>\n").getBytes());
            }
            byteArrayOutputStream.write(new String("\t</row>\n").getBytes());
        }
        byteArrayOutputStream.writeTo(outputStream);
        byteArrayOutputStream.close();
    }
}

