/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.edit;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.AttributeChangeEvent;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.Attributes;
import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.ObjectAttributeAccessor;
import de.grogra.graph.impl.Node;
import de.grogra.persistence.PersistenceField;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.edit.GraphSelection;
import de.grogra.pf.ui.edit.Property;
import de.grogra.pf.ui.edit.PropertyEditor;
import de.grogra.pf.ui.edit.PropertyEditorTree;
import de.grogra.pf.ui.edit.SelectionBase;
import de.grogra.pf.ui.registry.AttributeItem;
import de.grogra.pf.ui.tree.RegistryAdapter;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.pf.ui.util.LockProtectedCommand;
import de.grogra.reflect.Field;
import de.grogra.reflect.FieldChain;
import de.grogra.reflect.FieldChainImpl;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.Described;
import de.grogra.util.Lock;
import de.grogra.util.Lockable;
import de.grogra.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GraphSelectionImpl
extends SelectionBase
implements GraphSelection {
    final Object[] objects;
    final boolean[] isNode;
    final GraphState[] states;

    public GraphSelectionImpl(Context context, GraphState[] graphStateArray, Object[] objectArray, boolean[] blArray) {
        super(context);
        this.states = graphStateArray;
        this.objects = objectArray;
        this.isNode = blArray;
    }

    public GraphSelectionImpl(Context context, GraphState graphState, Object object, boolean bl) {
        super(context);
        this.states = new GraphState[]{graphState};
        this.objects = new Object[]{object};
        this.isNode = new boolean[]{bl};
    }

    public int size() {
        int n = 0;
        for (int i = this.objects.length - 1; i >= 0; --i) {
            if (this.objects[i] == null) continue;
            ++n;
        }
        return n;
    }

    private int index(int n) {
        for (int i = 0; i < this.objects.length; ++i) {
            if (this.objects[i] == null || --n >= 0) continue;
            return i;
        }
        return -1;
    }

    public GraphState getGraphState(int n) {
        return this.states[this.index(n)];
    }

    public Object getObject(int n) {
        return this.objects[this.index(n)];
    }

    public boolean isNode(int n) {
        return this.isNode[this.index(n)];
    }

    public boolean contains(Graph graph, Object object, boolean bl) {
        for (int i = this.objects.length - 1; i >= 0; --i) {
            if (graph != this.states[i].getGraph() || object != this.objects[i] || bl != this.isNode[i]) continue;
            return true;
        }
        return false;
    }

    boolean isWritable(Attribute attribute) {
        for (int i = this.objects.length - 1; i >= 0; --i) {
            AttributeAccessor attributeAccessor;
            if (this.objects[i] == null || (attributeAccessor = this.states[i].getGraph().getAccessor(this.objects[i], this.isNode[i], attribute)) != null && attributeAccessor.isWritable(this.objects[i], this.states[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GraphSelectionImpl)) {
            return false;
        }
        GraphSelectionImpl graphSelectionImpl = (GraphSelectionImpl)object;
        if (graphSelectionImpl.objects.length != this.objects.length) {
            return false;
        }
        for (int i = 0; i < this.objects.length; ++i) {
            if (this.isNode[i] == graphSelectionImpl.isNode[i] && this.objects[i] == graphSelectionImpl.objects[i]) continue;
            return false;
        }
        return true;
    }

    public Object getDescription(String string) {
        if (this.size() == 1) {
            int n = 0;
            while (this.objects[n] == null) {
                ++n;
            }
            Object object = this.objects[n];
            if (object instanceof Described) {
                return ((Described)object).getDescription(string);
            }
            if (Utils.isStringDescription((String)string)) {
                String string2 = (String)this.states[n].getGraph().getDescription(object, this.isNode[n], "ShortDescription");
                return string2 == null ? UI.getClassDescription(object.getClass()) : UI.getClassDescription(object.getClass()) + " [" + string2 + ']';
            }
            return this.states[n].getGraph().getDescription(object, this.isNode[n], string);
        }
        if (Utils.isStringDescription((String)string)) {
            return UI.I18N.msg("selection.n-objects.Name", (Object)this.size());
        }
        return null;
    }

    protected PropertyEditor getEditorFor(Property property, Item item) {
        PropertyEditor propertyEditor;
        AttributeItem attributeItem;
        if (((GraphProperty)property).attr != null && (attributeItem = AttributeItem.get(this.context.getWorkbench(), ((GraphProperty)property).attr)) != null && (propertyEditor = attributeItem.getEditor()) != null) {
            return propertyEditor;
        }
        return super.getEditorFor(property, item);
    }

    protected UITree getHierarchySource() {
        return new RegistryAdapter(this.context);
    }

    protected Object getHierarchySourceRoot(UITree uITree) {
        return Item.resolveItem((RegistryContext)UI.getRegistry(this.context), (String)"/attributes");
    }

    protected PropertyEditorTree createTree() {
        return new Tree(this.context);
    }

    protected PropertyEditorTree.Node createPropertyNodes(PropertyEditorTree propertyEditorTree, Property property, UITree uITree, Object object) {
        return object instanceof AttributeItem && ((GraphProperty)property).attr != null && ((AttributeItem)((Object)object)).correspondsTo(((GraphProperty)property).attr) ? this.createPropertyNodes(propertyEditorTree, property, (Item)object) : null;
    }

    protected PropertyEditorTree.Node createPropertyNodesInGroup(PropertyEditorTree propertyEditorTree, Property property, UITree uITree, Object object) {
        return ((Item)object).hasName("others") ? this.createPropertyNodes(propertyEditorTree, property, null) : null;
    }

    protected String getLabelFor(Property property) {
        return (String)((GraphProperty)property).attr.getDescription("Name");
    }

    protected List getProperties(PropertyEditorTree propertyEditorTree) {
        Object object;
        int n;
        ArrayList<GraphProperty> arrayList = null;
        for (n = 0; n < this.objects.length; ++n) {
            if (this.objects[n] == null) continue;
            object = Arrays.asList(this.states[n].getGraph().getAttributes(this.objects[n], this.isNode[n]));
            if (arrayList == null) {
                arrayList = new ArrayList<GraphProperty>((Collection<GraphProperty>)object);
                continue;
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                if (object.contains(arrayList.get(i))) continue;
                arrayList.remove(i);
            }
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            object = (Attribute)arrayList.get(n);
            if (this.isWritable((Attribute)object)) {
                arrayList.set(n, new GraphProperty(propertyEditorTree.getContext(), (Attribute)object, null));
                continue;
            }
            arrayList.remove(n);
        }
        return arrayList;
    }

    public int getCapabilities() {
        return 6;
    }

    public void delete(boolean bl) {
        UI.getJobManager(this.context).execute(new ForAll(){

            void runImpl(GraphState graphState, Object object, boolean bl, Object object2) {
                Node node;
                if (bl && object instanceof Node && (node = (Node)object).getGraph() != null) {
                    node.removeAll(node.getGraph().getActiveTransaction());
                }
            }
        }, null, this.context, 10000);
    }

    abstract class ForAll
    extends LockProtectedCommand {
        private int index;

        ForAll() {
            super((Lockable)GraphSelectionImpl.this.states[0].getGraph(), true, 10000);
            this.index = 0;
        }

        protected void runImpl(Object object, Context context, Lock lock) {
            GraphState graphState = GraphSelectionImpl.this.states[this.index];
            while (this.index < GraphSelectionImpl.this.objects.length) {
                if (GraphSelectionImpl.this.states[this.index] != graphState) {
                    this.resource = GraphSelectionImpl.this.states[this.index].getGraph();
                    UI.getJobManager(context).runLater(this, object, context, 10000);
                    return;
                }
                if (GraphSelectionImpl.this.objects[this.index] != null) {
                    this.runImpl(GraphSelectionImpl.this.states[this.index], GraphSelectionImpl.this.objects[this.index], GraphSelectionImpl.this.isNode[this.index], object);
                }
                ++this.index;
            }
        }

        abstract void runImpl(GraphState var1, Object var2, boolean var3, Object var4);
    }

    class GraphProperty
    extends Property {
        final Attribute attr;
        final FieldChain field;

        GraphProperty(Context context, Attribute attribute, FieldChain fieldChain) {
            super(context, fieldChain == null ? attribute.getType() : fieldChain.getField(fieldChain.length() - 1).getType());
            this.attr = attribute;
            this.field = fieldChain;
            if (fieldChain != null) {
                Field field = fieldChain.getField(fieldChain.length() - 1);
                if (field instanceof PersistenceField) {
                    this.setQuantity(((PersistenceField)field).getQuantity());
                }
            } else {
                this.setQuantity(attribute.getQuantity());
            }
        }

        public String toString() {
            return '{' + this.attr.toString() + ',' + this.field + '}';
        }

        public void setValue(Object object) {
            UI.getJobManager(this.getContext()).execute(new ForAll(){

                void runImpl(GraphState graphState, Object object, boolean bl, Object object2) {
                    AttributeAccessor attributeAccessor = graphState.getGraph().getAccessor(object, bl, GraphProperty.this.attr);
                    if (attributeAccessor != null) {
                        if (GraphProperty.this.field == null) {
                            GraphProperty.this.attr.set(object, bl, object2, graphState);
                        } else {
                            ((ObjectAttributeAccessor)attributeAccessor).setSubfield(object, GraphProperty.this.field, null, object2, graphState);
                        }
                    }
                }
            }, object, this.getContext(), 10000);
        }

        public String getCommandName() {
            return null;
        }

        public Object getValue() {
            int n;
            Object object = null;
            boolean bl = true;
            for (n = 0; n < GraphSelectionImpl.this.objects.length; ++n) {
                if (GraphSelectionImpl.this.objects[n] == null) continue;
                Object object2 = this.attr.get(GraphSelectionImpl.this.objects[n], GraphSelectionImpl.this.isNode[n], GraphSelectionImpl.this.states[n]);
                if (bl) {
                    bl = false;
                    object = object2;
                    continue;
                }
                if (Utils.equal((Object)object, (Object)object2)) continue;
                object = null;
                break;
            }
            if (object != null && this.field != null) {
                for (n = 0; n < this.field.length(); ++n) {
                    try {
                        if (!this.field.getField(n).getDeclaringType().isInstance(object)) {
                            object = null;
                        }
                        object = Reflection.get(object, (Field)this.field.getField(n));
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                        return null;
                    }
                }
            }
            return object;
        }

        public boolean isWritable() {
            return GraphSelectionImpl.this.isWritable(this.attr);
        }

        public Property createSubProperty(Type type, Field field, int n) {
            return new GraphProperty(this.getContext(), this.attr, (FieldChain)new FieldChainImpl(this.field, field));
        }
    }

    class Tree
    extends PropertyEditorTree
    implements AttributeChangeListener,
    ChangeBoundaryListener {
        Tree(Context context) {
            super(context);
            ((PropertyEditorTree.Node)this.root).setDecription(GraphSelectionImpl.this);
        }

        protected void firstListenerAdded() {
            block0: for (int i = 0; i < GraphSelectionImpl.this.states.length; ++i) {
                GraphState graphState = GraphSelectionImpl.this.states[i];
                for (int j = 0; j < i; ++j) {
                    if (GraphSelectionImpl.this.states[j] == graphState) continue block0;
                }
                graphState.getGraph().addAttributeChangeListener((AttributeChangeListener)this);
                graphState.getGraph().addChangeBoundaryListener((ChangeBoundaryListener)this);
            }
        }

        protected void allListenersRemoved() {
            block0: for (int i = 0; i < GraphSelectionImpl.this.states.length; ++i) {
                GraphState graphState = GraphSelectionImpl.this.states[i];
                for (int j = 0; j < i; ++j) {
                    if (GraphSelectionImpl.this.states[j] == graphState) continue block0;
                }
                graphState.getGraph().removeAttributeChangeListener((AttributeChangeListener)this);
                graphState.getGraph().removeChangeBoundaryListener((ChangeBoundaryListener)this);
            }
        }

        public void attributeChanged(AttributeChangeEvent attributeChangeEvent) {
            if (GraphSelectionImpl.this.contains(attributeChangeEvent.getGraphState().getGraph(), attributeChangeEvent.getObject(), attributeChangeEvent.isNode())) {
                this.fireChanged(attributeChangeEvent);
                if (GraphSelectionImpl.this.size() == 1 && Attributes.NAME.isContained(attributeChangeEvent.getDependentAttributes())) {
                    this.valueForPathChanged(this.root.getTreePath(), null);
                }
            }
        }

        public void beginChange(GraphState graphState) {
            boolean bl = false;
            for (int i = 0; i < GraphSelectionImpl.this.objects.length; ++i) {
                if (GraphSelectionImpl.this.states[i] != graphState || GraphSelectionImpl.this.objects[i] == null || graphState.getGraph().getLifeCycleState(GraphSelectionImpl.this.objects[i], GraphSelectionImpl.this.isNode[i]) == 0) continue;
                GraphSelectionImpl.this.objects[i] = null;
                bl = true;
            }
            if (bl) {
                this.fireChanged(null);
                if (GraphSelectionImpl.this.size() == 0) {
                    GraphSelectionImpl.this.remove();
                } else {
                    this.valueForPathChanged(this.root.getTreePath(), null);
                }
            }
        }

        public void endChange(GraphState graphState) {
        }

        public int getPriority() {
            return 10;
        }

        protected boolean isNodeAffectedBy(PropertyEditorTree.PropertyNode propertyNode, Object object) {
            GraphProperty graphProperty = (GraphProperty)propertyNode.getProperty();
            AttributeChangeEvent attributeChangeEvent = (AttributeChangeEvent)object;
            return attributeChangeEvent == null || attributeChangeEvent.getAttribute() == null || (attributeChangeEvent.getAttribute() == graphProperty.attr ? Reflection.overlaps((FieldChain)graphProperty.field, null, (FieldChain)attributeChangeEvent.getSubField(), (int[])attributeChangeEvent.getIndices()) : graphProperty.attr.isContained(attributeChangeEvent.getDependentAttributes()));
        }
    }
}

