/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.tree;

import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.event.InputEditEvent;
import de.grogra.pf.ui.registry.ChoiceGroup;
import de.grogra.pf.ui.registry.UIPropertyDependency;
import de.grogra.pf.ui.tree.UINodeHandler;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.util.Disposable;
import de.grogra.util.EventListener;
import de.grogra.util.Map;
import de.grogra.util.MutableTree;
import de.grogra.util.Tree;
import de.grogra.util.TreeDiff;
import de.grogra.xl.lang.ObjectToBoolean;
import de.grogra.xl.util.ObjectList;
import java.util.Comparator;
import java.util.EventObject;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class UITreePipeline
extends MutableTree
implements UITree,
TreeModelListener,
RegistryContext {
    private final ObjectList transformers = new ObjectList(10, false);
    private final Diff diff = new Diff();
    private UITree source;
    private Object sourceRoot;
    private Map params;
    private boolean disposed = false;
    private static final Object INDICES_LOCK = new Object();
    private static int[][] INDICES = new int[32][];

    public UITreePipeline() {
        super(null);
    }

    public void initialize(UITree uITree, Object object, Map map) {
        object.getClass();
        if (this.source != null) {
            throw new IllegalStateException();
        }
        this.source = uITree;
        this.sourceRoot = object;
        this.params = map;
        for (int i = 0; i < this.transformers.size(); ++i) {
            ((Transformer)this.transformers.get(i)).initialize(this);
        }
        this.update();
    }

    public UITree getSource() {
        return this.source;
    }

    public Object getSourceRoot() {
        return this.sourceRoot;
    }

    public Object getParameter(String string, Object object) {
        return this.params != null ? this.params.get((Object)string, object) : object;
    }

    public Registry getRegistry() {
        return this.source.getContext().getWorkbench().getRegistry();
    }

    public void update() {
        if (this.source != null) {
            Tree tree = this.root == null ? null : new Tree(this.root);
            this.root = this.createInitialTree();
            for (int i = 0; i < this.transformers.size(); ++i) {
                ((Transformer)this.transformers.get(i)).transform((Node)this.root);
            }
            if (tree != null) {
                this.diff.compare((TreeModel)tree, this, this.diff, this, this.diff);
                TreePath treePath = new TreePath(this.root);
                TMEvent tMEvent = new TMEvent((Object)this, treePath);
                this.fireTreeModelEvent(0, tMEvent);
                int n = this.root.getChildCount();
                if (n > 0) {
                    this.fireChanged(this.root, n, treePath, tMEvent);
                }
                ((Node)((Object)tree.getRoot())).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChanged(Tree.Node node, int n, TreePath treePath, TMEvent tMEvent) {
        int[] nArray;
        if (n < INDICES.length) {
            nArray = INDICES[n];
        } else {
            Object object = INDICES_LOCK;
            synchronized (object) {
                if (n >= INDICES.length) {
                    INDICES = new int[n + 1][];
                }
            }
            nArray = null;
        }
        if (nArray == null) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            UITreePipeline.INDICES[n] = nArray;
        }
        tMEvent.set(treePath, nArray, node.getChildren());
        this.fireTreeModelEvent(0, tMEvent);
        Tree.Node node2 = node.children;
        while (node2 != null) {
            n = node2.getChildCount();
            if (n > 0) {
                this.fireChanged(node2, n, treePath.pathByAddingChild(node2), tMEvent);
            }
            node2 = node2.next;
        }
    }

    protected void firstListenerAdded() {
        this.source.addTreeModelListener(this);
    }

    protected void allListenersRemoved() {
        this.dispose();
    }

    public final void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.clearListeners();
        this.source.removeTreeModelListener(this);
        while (!this.transformers.isEmpty()) {
            ((Transformer)this.transformers.pop()).dispose();
        }
        this.disposeImpl();
    }

    protected void disposeImpl() {
    }

    public void add(Transformer transformer) {
        this.transformers.add((Object)transformer);
        this.update();
    }

    public void remove(Transformer transformer) {
        this.transformers.remove((Object)transformer);
        transformer.dispose();
        this.update();
    }

    public Node copyTree(UITree uITree, Object object, ObjectToBoolean objectToBoolean) {
        Node node = new Node(uITree, object);
        this.addTree(node, -1, uITree, object, objectToBoolean, null);
        return node;
    }

    public void addTree(Node node, int n, UITree uITree, Object object, ObjectToBoolean objectToBoolean, Comparator comparator) {
        if (!uITree.isLeaf(object)) {
            int n2 = uITree.getChildCount(object);
            block0: for (int i = 0; i < n2; ++i) {
                Node node2;
                Object object2 = uITree.getChild(object, i);
                if (!(objectToBoolean == null ? uITree.getType(object2) != 0 : objectToBoolean.evaluateBoolean(object2)) || !this.isAvailable(uITree, object2)) continue;
                if (comparator != null) {
                    node2 = (Node)node.children;
                    while (node2 != null) {
                        if (comparator.compare(object2, node2.getNode()) == 0) {
                            this.addTree(node2, -1, uITree, object2, objectToBoolean, comparator);
                            continue block0;
                        }
                        node2 = (Node)node2.next;
                    }
                }
                node2 = new Node(uITree, object2);
                this.addTree(node2, -1, uITree, object2, objectToBoolean, comparator);
                node.insertChild(node2, n);
            }
        }
    }

    protected Node createInitialTree() {
        return this.copyTree(this.source, this.sourceRoot, null);
    }

    protected boolean isAvailable(UITree uITree, Object object) {
        return uITree.isAvailable(object);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getChildren() == null) {
            if (this.source.nodesEqual(treeModelEvent.getTreePath().getLastPathComponent(), ((Node)this.root).getNode())) {
                this.fireTreeModelEvent(0, new TreeModelEvent((Object)this, new TreePath(this.root), null, null));
            }
        } else {
            ObjectList objectList = new ObjectList();
            this.treeNodesChanged((Node)this.root, objectList, treeModelEvent.getChildren());
        }
    }

    private void treeNodesChanged(Node node, ObjectList objectList, Object[] objectArray) {
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (!this.source.nodesEqual(objectArray[i], node.getNode())) continue;
            this.fireTreeModelEvent(0, objectList.isEmpty() ? new TreeModelEvent((Object)this, new TreePath((Object)node), null, null) : new TreeModelEvent((Object)this, objectList.toArray(), new int[]{this.getIndexOfChild(node)}, new Object[]{node}));
            return;
        }
        objectList.push((Object)node);
        node = (Node)node.children;
        while (node != null) {
            this.treeNodesChanged(node, objectList, objectArray);
            node = (Node)node.next;
        }
        objectList.pop();
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.treeStructureChanged(treeModelEvent);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.treeStructureChanged(treeModelEvent);
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            this.update();
            return;
        }
        for (int i = 0; i < this.transformers.size(); ++i) {
            if (!((Transformer)this.transformers.get(i)).isAffectedBy(treeModelEvent.getTreePath())) continue;
            this.update();
            return;
        }
    }

    public Context getContext() {
        if (this.source == null) {
            this.source.getClass();
        }
        return this.source.getContext();
    }

    public boolean nodesEqual(Object object, Object object2) {
        return this.nodesEqual((Node)((Object)object), (Node)((Object)object2));
    }

    public int getType(Object object) {
        return ((Node)((Object)object)).getType();
    }

    public String getName(Object object) {
        return ((Node)((Object)object)).getName();
    }

    public Object resolveLink(Object object) {
        Node node = (Node)((Object)object);
        return node.handler.resolveLink(node.node);
    }

    public boolean isAvailable(Object object) {
        Node node = (Node)((Object)object);
        return node.handler.isAvailable(node.node);
    }

    public boolean isEnabled(Object object) {
        Node node = (Node)((Object)object);
        return node.handler.isEnabled(node.node);
    }

    public boolean isLeaf(Object object) {
        return ((Node)((Object)object)).isLeaf();
    }

    public Object getDescription(Object object, String string) {
        Node node = (Node)((Object)object);
        return node.handler.getDescription(node.getNode(), string);
    }

    public void eventOccured(Object object, EventObject eventObject) {
        UITreePipeline.dispatchEvent(this, object, eventObject, true);
        ((Node)((Object)object)).handleEvent(eventObject);
    }

    static void dispatchEvent(UITree uITree, Object object, EventObject eventObject, boolean bl) {
        if (eventObject instanceof InputEditEvent && !((InputEditEvent)eventObject).isConsumed()) {
            if (object instanceof Command) {
                ((Command)object).run(eventObject, (InputEditEvent)eventObject);
                ((InputEditEvent)eventObject).consume();
            } else {
                UITree uITree2;
                InputEditEvent inputEditEvent;
                if (bl) {
                    inputEditEvent = (InputEditEvent)((InputEditEvent)eventObject).clone(((Node)((Object)object)).getNode());
                    uITree2 = ((UITreePipeline)uITree).source;
                } else {
                    inputEditEvent = (InputEditEvent)((InputEditEvent)eventObject).clone(object);
                    uITree2 = uITree;
                }
                block0: while ((object = uITree.getParent(object)) != null) {
                    Object object2;
                    if (bl) {
                        if (((Node)((Object)object)).handler != uITree2) continue;
                        object2 = ((Node)((Object)object)).getNode();
                    } else {
                        object2 = object;
                    }
                    int n = uITree2.getChildCount(object2);
                    for (int i = 0; i < n; ++i) {
                        Object object3 = uITree2.getChild(object2, i);
                        if (inputEditEvent.isConsumed()) break block0;
                        if (!uITree2.getName(object3).startsWith(".")) continue;
                        uITree2.eventOccured(object3, inputEditEvent);
                    }
                }
                if (inputEditEvent.isConsumed()) {
                    ((InputEditEvent)eventObject).consume();
                }
            }
        }
    }

    public Object invoke(Object object, String string, Object object2) {
        return ((Node)((Object)object)).invoke(string, object2);
    }

    private static class TMEvent
    extends TreeModelEvent {
        TMEvent(Object object, TreePath treePath) {
            super(object, treePath, null, null);
        }

        void set(TreePath treePath, int[] nArray, Object[] objectArray) {
            this.path = treePath;
            this.childIndices = nArray;
            this.children = objectArray;
        }
    }

    private final class Diff
    extends TreeDiff
    implements TreeDiff.NodeModel,
    TreeModelListener {
        private Diff() {
        }

        public boolean equals(Object object, Object object2) {
            return object.equals(object2);
        }

        public TreeDiff.DiffInfo getDiffInfo(Object object) {
            return ((Node)((Object)object)).getDiffInfo();
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            UITreePipeline.this.fireTreeModelEvent(0, treeModelEvent);
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            UITreePipeline.this.fireTreeModelEvent(1, treeModelEvent);
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            UITreePipeline.this.fireTreeModelEvent(2, treeModelEvent);
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            UITreePipeline.this.fireTreeModelEvent(3, treeModelEvent);
        }
    }

    public static interface Transformer
    extends Disposable {
        public void initialize(UITreePipeline var1);

        public void transform(Node var1);

        public boolean isAffectedBy(TreePath var1);
    }

    public final class Node
    extends Tree.Node
    implements EventListener {
        public Object userData;
        UINodeHandler handler;
        TreeDiff.DiffInfo diffInfo;
        ChoiceGroup group;
        private Object node;

        public Node(UINodeHandler uINodeHandler, Object object) {
            this.handler = uINodeHandler;
            this.node = object;
            this.setListeners(object, true);
        }

        private void setListeners(Object object, boolean bl) {
            if (object instanceof Item) {
                for (Item item = (Item)((Item)object).getBranch(); item != null; item = (Item)item.getSuccessor()) {
                    if (!(item instanceof UIPropertyDependency)) continue;
                    UIProperty uIProperty = ((UIPropertyDependency)item).getProperty();
                    if (bl) {
                        uIProperty.addPropertyListener(UITreePipeline.this.getContext(), this);
                        continue;
                    }
                    uIProperty.removePropertyListener(UITreePipeline.this.getContext(), this);
                }
            }
        }

        public void eventOccured(EventObject eventObject) {
            UITreePipeline.this.valueForPathChanged(this.getTreePath(), null);
        }

        TreeDiff.DiffInfo getDiffInfo() {
            if (this.diffInfo == null) {
                this.diffInfo = new TreeDiff.DiffInfo((Object)this);
            }
            return this.diffInfo;
        }

        public void dispose() {
            Node node = (Node)this.children;
            while (node != null) {
                node.dispose();
                node = (Node)node.next;
            }
            this.children = null;
            this.parent = null;
            this.setListeners(this.node, false);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Node && this.handler.nodesEqual(this.node, ((Node)((Object)object)).node);
        }

        public int getType() {
            return this.group != null ? 5 : this.handler.getType(this.node);
        }

        public String getName() {
            return this.handler.getName(this.node);
        }

        public UITreePipeline getPipeline() {
            return UITreePipeline.this;
        }

        public UINodeHandler getNodeHandler() {
            return this.handler;
        }

        public Object getNode() {
            return this.node;
        }

        public boolean isLeaf() {
            return this.handler.isLeaf(this.node);
        }

        public Object invoke(String string, Object object) {
            return this.group != null && "getChoiceGroup".equals(string) ? this.group : this.handler.invoke(this.node, string, object);
        }

        void handleEvent(EventObject eventObject) {
            if (this.group != null) {
                this.group.setSelected(UITreePipeline.this.getContext(), this.handler, this.node);
                UI.consume(eventObject);
            } else {
                this.handler.eventOccured(this.node, eventObject);
            }
        }

        public Node getChild(String string) {
            Node node = (Node)this.children;
            while (node != null) {
                if (string.equals(node.getName())) {
                    return node;
                }
                node = (Node)node.next;
            }
            return null;
        }

        public String toString() {
            return "Node@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + '[' + this.node + ']';
        }
    }
}

